/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNConfigEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNHostOptionsProvider
implements ISVNHostOptionsProvider {
    private final File myConfigDirectory;
    private SVNCompositeConfigFile myServersFile;
    private Map myServersOptions;
    private ISVNConfigEventHandler myConfigEventHandler;

    public DefaultSVNHostOptionsProvider() {
        this(null);
    }

    public DefaultSVNHostOptionsProvider(File file) {
        this.myConfigDirectory = file == null ? SVNWCUtil.getDefaultConfigurationDirectory() : file;
    }

    public void setInMemoryServersOptions(Map map) {
        this.myServersOptions = map;
    }

    protected SVNCompositeConfigFile getServersFile() {
        if (this.myServersFile == null) {
            SVNConfigFile sVNConfigFile = new SVNConfigFile(new File(this.myConfigDirectory, "servers"));
            SVNConfigFile sVNConfigFile2 = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"));
            this.myServersFile = new SVNCompositeConfigFile(sVNConfigFile2, sVNConfigFile);
            this.myServersFile.setGroupsToOptions(this.myServersOptions);
            if (this.myConfigEventHandler != null) {
                this.myConfigEventHandler.onLoad(null, this.myServersFile);
            }
        }
        return this.myServersFile;
    }

    @Override
    public ISVNHostOptions getHostOptions(SVNURL sVNURL) {
        return new DefaultSVNHostOptions(this.getServersFile(), sVNURL);
    }
}

