/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;

public class DefaultSVNHostOptions
implements ISVNHostOptions {
    private final SVNCompositeConfigFile myServersFile;
    private final SVNURL myURL;

    public DefaultSVNHostOptions(SVNCompositeConfigFile sVNCompositeConfigFile, SVNURL sVNURL) {
        this.myServersFile = sVNCompositeConfigFile;
        this.myURL = sVNURL;
    }

    private SVNCompositeConfigFile getServersFile() {
        return this.myServersFile;
    }

    public String getHost() {
        return this.myURL.getHost();
    }

    public String getProtocol() {
        return this.myURL.getProtocol();
    }

    @Override
    public Collection getAuthTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.getHostProperties();
        String string = (String)map.get("http-auth-types");
        if (string == null || "".equals(string.trim())) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String getAuthStorageEnabledOption() {
        Map map = this.getHostProperties();
        return (String)map.get("store-auth-creds");
    }

    protected boolean hasAuthStorageEnabledOption() {
        return this.getAuthStorageEnabledOption() != null;
    }

    @Override
    public boolean isAuthStorageEnabled() {
        String string = this.getAuthStorageEnabledOption();
        if (string == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    @Override
    public boolean isStorePasswords() {
        boolean bl2 = true;
        Map map = this.getHostProperties();
        String string = (String)map.get("store-passwords");
        if (string == null) {
            return bl2;
        }
        return "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    private String getStorePlainTextPasswordOption() {
        Map map = this.getHostProperties();
        return (String)map.get("store-plaintext-passwords");
    }

    public boolean hasStorePlainTextPasswordsOption() {
        return this.getStorePlainTextPasswordOption() != null;
    }

    @Override
    public boolean isStorePlainTextPasswords(String string, SVNAuthentication sVNAuthentication) {
        String string2 = this.getStorePlainTextPasswordOption();
        if (string2 == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    @Override
    public boolean isStoreSSLClientCertificatePassphrases() {
        Map map = this.getHostProperties();
        String string = (String)map.get("store-ssl-client-cert-pp");
        if (string == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    private String getStorePlainTextPassphraseOption() {
        Map map = this.getHostProperties();
        return (String)map.get("store-ssl-client-cert-pp-plaintext");
    }

    protected boolean hasStorePlainTextPassphrasesOption() {
        String string = this.getStorePlainTextPassphraseOption();
        return string != null;
    }

    @Override
    public boolean isStorePlainTextPassphrases(String string, SVNAuthentication sVNAuthentication) {
        String string2 = this.getStorePlainTextPassphraseOption();
        if (string2 == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    @Override
    public String getUserName() {
        Map map = this.getHostProperties();
        String string = (String)map.get("username");
        return string;
    }

    @Override
    public String getSSLClientCertFile() {
        Map map = this.getHostProperties();
        return (String)map.get("ssl-client-cert-file");
    }

    @Override
    public String getSSLClientCertPassword() {
        Map map = this.getHostProperties();
        return (String)map.get("ssl-client-cert-password");
    }

    @Override
    public boolean trustDefaultSSLCertificateAuthority() {
        Map map = this.getHostProperties();
        return !"no".equalsIgnoreCase((String)map.get("ssl-trust-default-ca"));
    }

    @Override
    public File[] getSSLAuthorityFiles() {
        Map map = this.getHostProperties();
        String string = (String)map.get("ssl-authority-files");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = string2 == null ? null : string2.trim();
                if (string2 == null || "".equals(string2)) continue;
                arrayList.add(new File(string2));
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public String getProxyHost() {
        return this.getProxyOption("http-proxy-host", "http.proxyHost");
    }

    @Override
    public String getProxyPort() {
        return this.getProxyOption("http-proxy-port", "http.proxyPort");
    }

    @Override
    public String getProxyUserName() {
        return this.getProxyOption("http-proxy-username", null);
    }

    @Override
    public String getProxyPassword() {
        return this.getProxyOption("http-proxy-password", null);
    }

    private String getProxyOption(String string, String string2) {
        String string3 = this.getHost();
        Map map = this.getHostProperties();
        String string4 = (String)map.get(string);
        if ((string4 == null || "".equals(string4.trim())) && string2 != null) {
            string4 = System.getProperty(string2);
        }
        if (string4 == null || "".equals(string4.trim())) {
            return null;
        }
        if (DefaultSVNHostOptions.hostExceptedFromProxy(string3, map)) {
            return null;
        }
        return string4;
    }

    private static boolean hostExceptedFromProxy(String string, Map map) {
        String string2 = (String)map.get("http-proxy-exceptions");
        String string3 = ",";
        if (string2 == null) {
            string2 = System.getProperty("http.nonProxyHosts");
            string3 = "|";
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!DefaultSVNOptions.matches(string4, string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getReadTimeout() {
        String string = this.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            Map map = this.getHostProperties();
            String string2 = (String)map.get("http-timeout");
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    @Override
    public int getConnectTimeout() {
        String string = this.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            return 60000;
        }
        return 0;
    }

    private Map getHostProperties() {
        Map map = this.getServersFile().getProperties("global");
        String string = this.getGroupName(this.getServersFile().getProperties("groups"));
        if (string != null) {
            Map map2 = this.getServersFile().getProperties(string);
            map.putAll(map2);
        }
        return map;
    }

    private String getGroupName(Map map) {
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!DefaultSVNOptions.matches(string3 = string3.trim(), this.getHost())) continue;
                return string;
            }
        }
        return null;
    }
}

