/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNGNUDiffGenerator
extends DefaultSVNDiffGenerator
implements ISVNGNUDiffGenerator {
    private String myHeader;
    private boolean myIsHeaderWritten;
    private FSRoot myOriginalRoot;
    private String myOriginalPath;
    private FSRoot myNewRoot;
    private String myNewPath;
    private boolean myIsDiffWritten;

    @Override
    public void displayHeader(int n2, String string, String string2, long l2, OutputStream outputStream) {
        switch (n2) {
            case 0: {
                if (this.myIsHeaderWritten) break;
                string = string.startsWith("/") ? string.substring(1) : string;
                this.myHeader = "Added: " + string;
                break;
            }
            case 1: {
                if (this.myIsHeaderWritten) break;
                string = string.startsWith("/") ? string.substring(1) : string;
                this.myHeader = "Deleted: " + string;
                break;
            }
            case 2: {
                if (this.myIsHeaderWritten) break;
                string = string.startsWith("/") ? string.substring(1) : string;
                this.myHeader = "Modified: " + string;
                break;
            }
            case 3: {
                if (this.myIsHeaderWritten) break;
                string = string.startsWith("/") ? string.substring(1) : string;
                string2 = string2.startsWith("/") ? string2.substring(1) : string2;
                this.myHeader = "Copied: " + string + " (from rev " + l2 + ", " + string2 + ")";
                break;
            }
            case 4: {
                try {
                    outputStream.write(this.getEOL());
                    break;
                }
                catch (IOException iOException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                    SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
                }
            }
        }
    }

    @Override
    public void displayFileDiff(String string, File file, File file2, String string2, String string3, String string4, String string5, OutputStream outputStream) {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream, 0L);
        super.displayFileDiff(string, file, file2, string2, string3, string4, string5, countingOutputStream);
        if (countingOutputStream.getPosition() > 0L) {
            try {
                outputStream.write(this.getEOL());
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
        }
        this.setDiffWritten(countingOutputStream.getPosition() > 0L);
    }

    public void setHeaderWritten(boolean bl2) {
        this.myIsHeaderWritten = bl2;
    }

    @Override
    protected boolean displayHeader(OutputStream outputStream, String string, boolean bl2) {
        if (this.myHeader != null) {
            outputStream.write(this.myHeader.getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
            this.myHeader = null;
            this.myIsHeaderWritten = true;
        } else if (!this.myIsHeaderWritten) {
            string = string.startsWith("/") ? string.substring(1) : string;
            String string2 = "Index: " + string;
            outputStream.write(string2.getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
            this.myIsHeaderWritten = true;
        }
        outputStream.write("===================================================================".getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        return false;
    }

    @Override
    protected void displayBinary(OutputStream outputStream, String string, String string2) {
        outputStream.write("(Binary files differ)".getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
    }

    @Override
    protected void displayHeaderFields(OutputStream outputStream, String string, String string2) {
        outputStream.write("--- ".getBytes(this.getEncoding()));
        String string3 = null;
        String string4 = null;
        try {
            string3 = this.generateLabel(this.myOriginalRoot, this.myOriginalPath);
            string4 = this.generateLabel(this.myNewRoot, this.myNewPath);
        }
        catch (SVNException sVNException) {
            throw new IOException(sVNException.getLocalizedMessage());
        }
        outputStream.write(string3.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        outputStream.write("+++ ".getBytes(this.getEncoding()));
        outputStream.write(string4.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
    }

    protected void setOriginalFile(FSRoot fSRoot, String string) {
        this.myOriginalRoot = fSRoot;
        this.myOriginalPath = string;
    }

    protected void setNewFile(FSRoot fSRoot, String string) {
        this.myNewRoot = fSRoot;
        this.myNewPath = string;
    }

    private String generateLabel(FSRoot fSRoot, String string) {
        Object object;
        String string2 = null;
        String string3 = null;
        long l2 = 0L;
        if (fSRoot != null) {
            object = fSRoot.getOwner();
            SVNProperties sVNProperties = null;
            if (fSRoot instanceof FSRevisionRoot) {
                FSRevisionRoot fSRevisionRoot = (FSRevisionRoot)fSRoot;
                l2 = fSRevisionRoot.getRevision();
                sVNProperties = ((FSFS)object).getRevisionProperties(l2);
            } else {
                FSTransactionRoot fSTransactionRoot = (FSTransactionRoot)fSRoot;
                string3 = fSTransactionRoot.getTxnID();
                sVNProperties = ((FSFS)object).getTransactionProperties(string3);
            }
            string2 = sVNProperties.getStringValue("svn:date");
        }
        object = null;
        if (string2 != null) {
            int n2 = string2.indexOf(84);
            object = string2.substring(0, n2) + " " + string2.substring(n2 + 1, n2 + 9) + " UTC";
        } else {
            object = "                       ";
        }
        if (string3 != null) {
            return string + '\t' + (String)object + " (txn " + string3 + ")";
        }
        return string + '\t' + (String)object + " (rev " + l2 + ")";
    }

    @Override
    protected boolean useLocalFileSeparatorChar() {
        return false;
    }

    public void setDiffWritten(boolean bl2) {
        this.myIsDiffWritten = bl2;
    }

    public boolean isDiffWritten() {
        return this.myIsDiffWritten;
    }

    public void printHeader(OutputStream outputStream) {
        if (this.myHeader != null) {
            try {
                this.displayHeader(outputStream, null, false);
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
        }
    }
}

