/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNConnectionOptions;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;

public class DefaultSVNConnectionOptions
implements ISVNConnectionOptions {
    private static final String[] DEFAULT_PASSWORD_STORE_TYPES = new String[]{"windows-cryptoapi", "keychain"};
    private final SVNCompositeConfigFile myServersFile;
    private final SVNCompositeConfigFile myConfigFile;

    public DefaultSVNConnectionOptions(SVNCompositeConfigFile sVNCompositeConfigFile, SVNCompositeConfigFile sVNCompositeConfigFile2) {
        this.myServersFile = sVNCompositeConfigFile;
        this.myConfigFile = sVNCompositeConfigFile2;
    }

    private SVNCompositeConfigFile getServersFile() {
        return this.myServersFile;
    }

    private SVNCompositeConfigFile getConfigFile() {
        return this.myConfigFile;
    }

    @Override
    public Collection getAuthTypes(SVNURL sVNURL) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = sVNURL.getHost();
        Map map = this.getHostProperties(string);
        String string2 = (String)map.get("http-auth-types");
        if (string2 == null || "".equals(string2.trim())) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String getAuthStorageEnabledOption(SVNURL sVNURL) {
        String string = sVNURL != null ? sVNURL.getHost() : null;
        Map map = this.getHostProperties(string);
        return (String)map.get("store-auth-creds");
    }

    public boolean hasAuthStorageEnabledOption(SVNURL sVNURL) {
        return this.getAuthStorageEnabledOption(sVNURL) != null;
    }

    @Override
    public boolean isAuthStorageEnabled(SVNURL sVNURL) {
        String string = this.getAuthStorageEnabledOption(sVNURL);
        if (string == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    @Override
    public String[] getPasswordStorageTypes() {
        String string = this.getConfigFile().getPropertyValue("auth", "password-stores");
        if (string == null) {
            return DEFAULT_PASSWORD_STORE_TYPES;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2 == null ? null : string2.trim();
            if (string2 == null || "".equals(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean isStorePasswords(SVNURL sVNURL) {
        String string;
        Map map;
        String string2;
        boolean bl2 = true;
        String string3 = this.getConfigFile().getPropertyValue("auth", "store-passwords");
        if (string3 != null) {
            bl2 = "yes".equalsIgnoreCase(string3) || "on".equalsIgnoreCase(string3) || "true".equalsIgnoreCase(string3);
        }
        if ((string2 = (String)(map = this.getHostProperties(string = sVNURL != null ? sVNURL.getHost() : null)).get("store-passwords")) == null) {
            return bl2;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    private String getStorePlainTextPasswordOption(SVNAuthentication sVNAuthentication) {
        SVNURL sVNURL = sVNAuthentication.getURL();
        String string = sVNURL != null ? sVNURL.getHost() : null;
        Map map = this.getHostProperties(string);
        return (String)map.get("store-plaintext-passwords");
    }

    @Override
    public boolean isStorePlainTextPasswords(String string, SVNAuthentication sVNAuthentication) {
        String string2 = this.getStorePlainTextPasswordOption(sVNAuthentication);
        if (string2 == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    @Override
    public boolean isStoreSSLClientCertificatePassphrases(SVNURL sVNURL) {
        String string = sVNURL != null ? sVNURL.getHost() : null;
        Map map = this.getHostProperties(string);
        String string2 = (String)map.get("store-ssl-client-cert-pp");
        if (string2 == null) {
            return true;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    private String getStorePlainTextPassphraseOption(SVNAuthentication sVNAuthentication) {
        SVNURL sVNURL = sVNAuthentication.getURL();
        String string = sVNURL != null ? sVNURL.getHost() : null;
        Map map = this.getHostProperties(string);
        return (String)map.get("store-ssl-client-cert-pp-plaintext");
    }

    @Override
    public boolean isStorePlainTextPassphrases(String string, SVNAuthentication sVNAuthentication) {
        String string2 = this.getStorePlainTextPassphraseOption(sVNAuthentication);
        if (string2 == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2);
    }

    @Override
    public String getUserName(SVNURL sVNURL) {
        String string = sVNURL != null ? sVNURL.getHost() : null;
        Map map = this.getHostProperties(string);
        String string2 = (String)map.get("username");
        return string2;
    }

    private String getDefaultSSHCommandLine() {
        Map map = this.getConfigFile().getProperties("tunnels");
        if (map == null || !map.containsKey("ssh")) {
            return null;
        }
        return (String)map.get("ssh");
    }

    private String getDefaultSSHOptionValue(String string, String string2, String string3) {
        String string4;
        String string5;
        if (string != null && (string5 = this.getDefaultSSHCommandLine()) != null && (string4 = DefaultSVNConnectionOptions.getOptionValue(string5, string)) != null) {
            return string4;
        }
        return System.getProperty(string2, System.getProperty(string3));
    }

    @Override
    public int getDefaultSSHPortNumber() {
        String string = this.getDefaultSSHCommandLine();
        if (string == null) {
            return -1;
        }
        String string2 = string.toLowerCase().trim().startsWith("plink") ? "-p" : "-P";
        String string3 = this.getDefaultSSHOptionValue(string2, "svnkit.ssh2.port", "javasvn.ssh2.port");
        if (string3 != null) {
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public String getDefaultSSHUserName() {
        String string = this.getDefaultSSHOptionValue("-l", "svnkit.ssh2.username", "javasvn.ssh2.username");
        if (string == null) {
            string = System.getProperty("user.name");
        }
        return string;
    }

    @Override
    public String getDefaultSSHPassword() {
        return this.getDefaultSSHOptionValue("-pw", "svnkit.ssh2.password", "javasvn.ssh2.password");
    }

    @Override
    public String getDefaultSSHKeyFile() {
        return this.getDefaultSSHOptionValue("-i", "svnkit.ssh2.key", "javasvn.ssh2.key");
    }

    @Override
    public String getDefaultSSHPassphrase() {
        return this.getDefaultSSHOptionValue(null, "svnkit.ssh2.passphrase", "javasvn.ssh2.passphrase");
    }

    @Override
    public String getSSLClientCertFile(SVNURL sVNURL) {
        Map map = this.getHostProperties(sVNURL.getHost());
        return (String)map.get("ssl-client-cert-file");
    }

    @Override
    public String getSSLClientCertPassword(SVNURL sVNURL) {
        Map map = this.getHostProperties(sVNURL.getHost());
        return (String)map.get("ssl-client-cert-password");
    }

    @Override
    public boolean trustDefaultSSLCertificateAuthority(SVNURL sVNURL) {
        String string = sVNURL.getHost();
        Map map = this.getHostProperties(string);
        return !"no".equalsIgnoreCase((String)map.get("ssl-trust-default-ca"));
    }

    @Override
    public File[] getSSLAuthorityFiles(SVNURL sVNURL) {
        String string = sVNURL.getHost();
        Map map = this.getHostProperties(string);
        String string2 = (String)map.get("ssl-authority-files");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string3 = string3 == null ? null : string3.trim();
                if (string3 == null || "".equals(string3)) continue;
                arrayList.add(new File(string3));
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public String getProxyHost(SVNURL sVNURL) {
        return this.getProxyOption(sVNURL, "http-proxy-host", "http.proxyHost");
    }

    @Override
    public String getProxyPort(SVNURL sVNURL) {
        return this.getProxyOption(sVNURL, "http-proxy-port", "http.proxyPort");
    }

    @Override
    public String getProxyUserName(SVNURL sVNURL) {
        return this.getProxyOption(sVNURL, "http-proxy-username", null);
    }

    @Override
    public String getProxyPassword(SVNURL sVNURL) {
        return this.getProxyOption(sVNURL, "http-proxy-password", null);
    }

    private String getProxyOption(SVNURL sVNURL, String string, String string2) {
        if (sVNURL == null || string == null) {
            return null;
        }
        String string3 = sVNURL.getHost();
        Map map = this.getHostProperties(string3);
        String string4 = (String)map.get(string);
        if ((string4 == null || "".equals(string4.trim())) && string2 != null) {
            string4 = System.getProperty(string2);
        }
        if (string4 == null || "".equals(string4.trim())) {
            return null;
        }
        if (DefaultSVNConnectionOptions.hostExceptedFromProxy(string3, map)) {
            return null;
        }
        return string4;
    }

    private static boolean hostExceptedFromProxy(String string, Map map) {
        String string2 = (String)map.get("http-proxy-exceptions");
        String string3 = ",";
        if (string2 == null) {
            string2 = System.getProperty("http.nonProxyHosts");
            string3 = "|";
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!DefaultSVNOptions.matches(string4, string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getReadTimeout(SVNURL sVNURL) {
        String string = sVNURL.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            String string2 = sVNURL.getHost();
            Map map = this.getHostProperties(string2);
            String string3 = (String)map.get("http-timeout");
            if (string3 != null) {
                try {
                    return Integer.parseInt(string3) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    @Override
    public int getConnectTimeout(SVNURL sVNURL) {
        String string = sVNURL.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            return 60000;
        }
        return 0;
    }

    private Map getHostProperties(String string) {
        Map map = this.getServersFile().getProperties("global");
        String string2 = DefaultSVNConnectionOptions.getGroupName(this.getServersFile().getProperties("groups"), string);
        if (string2 != null) {
            Map map2 = this.getServersFile().getProperties(string2);
            map.putAll(map2);
        }
        return map;
    }

    private static String getGroupName(Map map, String string) {
        for (String string2 : map.keySet()) {
            String string3 = (String)map.get(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (!DefaultSVNOptions.matches(string4, string)) continue;
                return string2;
            }
        }
        return null;
    }

    private static String getOptionValue(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\n\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string2.equals(string3) && stringTokenizer.hasMoreTokens()) {
                return stringTokenizer.nextToken();
            }
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string2.length());
        }
        return null;
    }
}

