/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$1;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$CacheAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$DumbAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$ExtendedHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$RuntimeStorage;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager$SimpleProxyManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNSSLTrustManager;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNAuthenticationManager
implements ISVNAuthenticationManager,
ISVNSSHHostVerifier,
ISVNSSLPasspharsePromptSupport {
    private boolean myIsStoreAuth;
    private File myConfigDirectory;
    private ISVNAuthenticationStorageOptions myAuthOptions;
    private DefaultSVNOptions myDefaultOptions;
    private ISVNHostOptionsProvider myHostOptionsProvider;
    private ISVNAuthenticationStorage myRuntimeAuthStorage;
    private ISVNAuthenticationProvider[] myProviders;
    private SVNAuthentication myPreviousAuthentication;
    private SVNErrorMessage myPreviousErrorMessage;
    private int myLastProviderIndex;
    private SVNAuthentication myLastLoadedAuth;
    private boolean myIsAuthenticationForced;
    private boolean myIsAutoDismissSensitiveData;

    public DefaultSVNAuthenticationManager(File file, boolean bl2, String string, String string2) {
        this(file, bl2, string, string2 != null ? string2.toCharArray() : null, null, null);
    }

    public DefaultSVNAuthenticationManager(File file, boolean bl2, String string, String string2, File file2, String string3) {
        this(file, bl2, string, string2 != null ? string2.toCharArray() : null, file2, string3 != null ? string3.toCharArray() : null);
    }

    public DefaultSVNAuthenticationManager(File file, boolean bl2, String string, char[] cArray, File file2, char[] cArray2) {
        this.myIsStoreAuth = bl2;
        this.myConfigDirectory = file;
        if (this.myConfigDirectory == null) {
            this.myConfigDirectory = SVNWCUtil.getDefaultConfigurationDirectory();
        }
        this.myProviders = new ISVNAuthenticationProvider[4];
        this.myProviders[0] = this.createDefaultAuthenticationProvider(string, cArray, file2, cArray2, this.myIsStoreAuth);
        this.myProviders[1] = this.createRuntimeAuthenticationProvider();
        this.myProviders[2] = this.createCacheAuthenticationProvider(new File(this.myConfigDirectory, "auth"), string);
    }

    public void setInMemoryServersOptions(Map map) {
        if (this.getHostOptionsProvider() instanceof DefaultSVNHostOptionsProvider) {
            DefaultSVNHostOptionsProvider defaultSVNHostOptionsProvider = (DefaultSVNHostOptionsProvider)this.getHostOptionsProvider();
            defaultSVNHostOptionsProvider.setInMemoryServersOptions(map);
        }
    }

    public void setInMemoryConfigOptions(Map map) {
        this.getDefaultOptions().setInMemoryConfigOptions(map);
    }

    public ISVNAuthenticationStorageOptions getAuthenticationStorageOptions() {
        if (this.myAuthOptions == null) {
            return ISVNAuthenticationStorageOptions.DEFAULT;
        }
        return this.myAuthOptions;
    }

    public void setAuthenticationStorageOptions(ISVNAuthenticationStorageOptions iSVNAuthenticationStorageOptions) {
        this.myAuthOptions = iSVNAuthenticationStorageOptions;
    }

    @Override
    public void setAuthenticationProvider(ISVNAuthenticationProvider iSVNAuthenticationProvider) {
        this.myProviders[3] = iSVNAuthenticationProvider;
    }

    protected File getConfigDirectory() {
        return this.myConfigDirectory;
    }

    public DefaultSVNOptions getDefaultOptions() {
        if (this.myDefaultOptions == null) {
            this.myDefaultOptions = new DefaultSVNOptions(this.myConfigDirectory, true);
        }
        return this.myDefaultOptions;
    }

    public ISVNHostOptionsProvider getHostOptionsProvider() {
        if (this.myHostOptionsProvider == null) {
            this.myHostOptionsProvider = new DefaultSVNAuthenticationManager$ExtendedHostOptionsProvider(this);
        }
        return this.myHostOptionsProvider;
    }

    protected void setHostOptionsProvider(ISVNHostOptionsProvider iSVNHostOptionsProvider) {
        this.myHostOptionsProvider = iSVNHostOptionsProvider;
    }

    public Collection getAuthTypes(SVNURL sVNURL) {
        return this.getHostOptionsProvider().getHostOptions(sVNURL).getAuthTypes();
    }

    @Override
    public ISVNProxyManager getProxyManager(SVNURL sVNURL) {
        ISVNHostOptions iSVNHostOptions = this.getHostOptionsProvider().getHostOptions(sVNURL);
        String string = iSVNHostOptions.getProxyHost();
        if (string == null) {
            return null;
        }
        String string2 = iSVNHostOptions.getProxyPort();
        String string3 = iSVNHostOptions.getProxyUserName();
        String string4 = iSVNHostOptions.getProxyPassword();
        return new DefaultSVNAuthenticationManager$SimpleProxyManager(string, string2, string3, string4);
    }

    @Override
    public TrustManager getTrustManager(SVNURL sVNURL) {
        ISVNHostOptions iSVNHostOptions = this.getHostOptionsProvider().getHostOptions(sVNURL);
        boolean bl2 = iSVNHostOptions.trustDefaultSSLCertificateAuthority();
        File[] fileArray = iSVNHostOptions.getSSLAuthorityFiles();
        File file = new File(this.myConfigDirectory, "auth/svn.ssl.server");
        return new DefaultSVNSSLTrustManager(file, sVNURL, fileArray, bl2, this);
    }

    @Override
    public SVNAuthentication getFirstAuthentication(String string, String string2, SVNURL sVNURL) {
        this.myPreviousAuthentication = null;
        this.myPreviousErrorMessage = null;
        this.myLastProviderIndex = 0;
        this.myLastLoadedAuth = null;
        for (int i2 = 0; i2 < this.myProviders.length; ++i2) {
            if (this.myProviders[i2] == null) continue;
            SVNAuthentication sVNAuthentication = this.myProviders[i2].requestClientAuthentication(string, sVNURL, string2, null, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (sVNAuthentication != null) {
                if (i2 == 2) {
                    this.myLastLoadedAuth = sVNAuthentication;
                }
                this.myPreviousAuthentication = sVNAuthentication;
                this.myLastProviderIndex = i2;
                if (sVNAuthentication.isPartial()) continue;
                return sVNAuthentication;
            }
            if (i2 != 3) continue;
            SVNErrorManager.cancelAuthentication(this.myPreviousErrorMessage, this.myPreviousAuthentication);
        }
        if ("svn.username".equals(string)) {
            return SVNUserNameAuthentication.newInstance("", this.getHostOptionsProvider().getHostOptions(sVNURL).isAuthStorageEnabled(), sVNURL, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", string2);
        return null;
    }

    @Override
    public SVNAuthentication getNextAuthentication(String string, String string2, SVNURL sVNURL) {
        int n2;
        for (int i2 = n2 = Math.min(this.myLastProviderIndex + 1, 3); i2 < this.myProviders.length; ++i2) {
            if (this.myProviders[i2] == null || (i2 == 1 || i2 == 2) && this.hasExplicitCredentials(string)) continue;
            SVNAuthentication sVNAuthentication = this.myProviders[i2].requestClientAuthentication(string, sVNURL, string2, this.myPreviousErrorMessage, this.myPreviousAuthentication, this.myIsStoreAuth);
            if (sVNAuthentication != null) {
                if (i2 == 2) {
                    this.myLastLoadedAuth = sVNAuthentication;
                }
                this.myPreviousAuthentication = sVNAuthentication;
                this.myLastProviderIndex = i2;
                if (sVNAuthentication.isPartial()) continue;
                return sVNAuthentication;
            }
            if (i2 != 3) continue;
            SVNErrorManager.cancelAuthentication(this.myPreviousErrorMessage, this.myPreviousAuthentication);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", string2);
        return null;
    }

    public void setDismissSensitiveDataUponUse(boolean bl2) {
        this.myIsAutoDismissSensitiveData = bl2;
    }

    public boolean isDismissSensitiveDataUponUse() {
        return this.myIsAutoDismissSensitiveData;
    }

    @Override
    public void acknowledgeAuthentication(boolean bl2, String string, String string2, SVNErrorMessage sVNErrorMessage, SVNAuthentication sVNAuthentication) {
        if (!bl2) {
            if (this.isDismissSensitiveDataUponUse()) {
                sVNAuthentication.dismissSensitiveData();
            }
            this.myPreviousErrorMessage = sVNErrorMessage;
            this.myPreviousAuthentication = sVNAuthentication;
            this.myLastLoadedAuth = null;
            return;
        }
        if (this.myIsStoreAuth && sVNAuthentication.isStorageAllowed() && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider && (this.myLastLoadedAuth == null || this.myLastLoadedAuth != sVNAuthentication)) {
            ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveAuthentication(sVNAuthentication, string, string2);
        }
        this.myLastLoadedAuth = null;
        if (!this.hasExplicitCredentials(string)) {
            ((DefaultSVNAuthenticationManager$CacheAuthenticationProvider)this.myProviders[1]).saveAuthentication(sVNAuthentication, string2);
        } else if (this.isDismissSensitiveDataUponUse()) {
            sVNAuthentication.dismissSensitiveData();
        }
    }

    @Override
    public void acknowledgeTrustManager(TrustManager trustManager) {
    }

    private boolean hasExplicitCredentials(String string) {
        if (("svn.simple".equals(string) || "svn.username".equals(string) || "svn.ssh".equals(string)) && this.myProviders[0] instanceof DefaultSVNAuthenticationManager$DumbAuthenticationProvider) {
            DefaultSVNAuthenticationManager$DumbAuthenticationProvider defaultSVNAuthenticationManager$DumbAuthenticationProvider = (DefaultSVNAuthenticationManager$DumbAuthenticationProvider)this.myProviders[0];
            String string2 = DefaultSVNAuthenticationManager$DumbAuthenticationProvider.access$000(defaultSVNAuthenticationManager$DumbAuthenticationProvider);
            char[] cArray = DefaultSVNAuthenticationManager$DumbAuthenticationProvider.access$100(defaultSVNAuthenticationManager$DumbAuthenticationProvider);
            if ("svn.username".equals(string)) {
                return string2 != null && !"".equals(string2);
            }
            return cArray != null && cArray.length > 0 && string2 != null && !"".equals(string2);
        }
        return false;
    }

    public void setRuntimeStorage(ISVNAuthenticationStorage iSVNAuthenticationStorage) {
        this.myRuntimeAuthStorage = iSVNAuthenticationStorage;
    }

    protected ISVNAuthenticationStorage getRuntimeAuthStorage() {
        if (this.myRuntimeAuthStorage == null) {
            this.myRuntimeAuthStorage = new DefaultSVNAuthenticationManager$RuntimeStorage(null);
        }
        return this.myRuntimeAuthStorage;
    }

    protected ISVNAuthenticationProvider getAuthenticationProvider() {
        return this.myProviders[3];
    }

    protected SVNSSHAuthentication getDefaultSSHAuthentication(SVNURL sVNURL) {
        String string = this.getDefaultOptions().getDefaultSSHUserName();
        String string2 = this.getDefaultOptions().getDefaultSSHPassword();
        String string3 = this.getDefaultOptions().getDefaultSSHKeyFile();
        int n2 = this.getDefaultOptions().getDefaultSSHPortNumber();
        String string4 = this.getDefaultOptions().getDefaultSSHPassphrase();
        if (string != null && string2 != null) {
            return SVNSSHAuthentication.newInstance(string, string2.toCharArray(), n2, this.getHostOptionsProvider().getHostOptions(sVNURL).isAuthStorageEnabled(), sVNURL, false);
        }
        if (string != null && string3 != null) {
            return SVNSSHAuthentication.newInstance(string, new File(string3), string4 != null ? string4.toCharArray() : null, n2, this.getHostOptionsProvider().getHostOptions(sVNURL).isAuthStorageEnabled(), sVNURL, false);
        }
        return null;
    }

    protected ISVNAuthenticationProvider createDefaultAuthenticationProvider(String string, char[] cArray, File file, char[] cArray2, boolean bl2) {
        return new DefaultSVNAuthenticationManager$DumbAuthenticationProvider(this, string, cArray, file, cArray2, bl2);
    }

    protected ISVNAuthenticationProvider createRuntimeAuthenticationProvider() {
        return new DefaultSVNAuthenticationManager$CacheAuthenticationProvider(this, null);
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File file, String string) {
        ISVNAuthenticationStorageOptions iSVNAuthenticationStorageOptions = this.createAuthenticationStorageOptions();
        return new DefaultSVNPersistentAuthenticationProvider(file, string, iSVNAuthenticationStorageOptions, this.getDefaultOptions(), this.getHostOptionsProvider());
    }

    public ISVNAuthenticationStorageOptions createAuthenticationStorageOptions() {
        return new DefaultSVNAuthenticationManager$1(this);
    }

    @Override
    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean bl2) {
        this.myIsAuthenticationForced = bl2;
    }

    @Override
    public int getReadTimeout(SVNRepository sVNRepository) {
        return this.getHostOptionsProvider().getHostOptions(sVNRepository.getLocation()).getReadTimeout();
    }

    @Override
    public int getConnectTimeout(SVNRepository sVNRepository) {
        return this.getHostOptionsProvider().getHostOptions(sVNRepository.getLocation()).getConnectTimeout();
    }

    @Override
    public void verifyHostKey(String string, int n2, String string2, byte[] byArray) {
        String string3 = string + ":" + n2 + " <" + string2 + ">";
        byte[] byArray2 = (byte[])this.getRuntimeAuthStorage().getData("svn.ssh.server", string3);
        if (byArray2 == null && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider) {
            byArray2 = ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).loadFingerprints(string3);
        }
        if (byArray2 == null || !DefaultSVNAuthenticationManager.equals(byArray2, byArray)) {
            SVNURL sVNURL = SVNURL.create("svn+ssh", null, string, n2, "", true);
            ISVNHostOptions iSVNHostOptions = this.getHostOptionsProvider().getHostOptions(sVNURL);
            boolean bl2 = iSVNHostOptions.isAuthStorageEnabled();
            if (this.getAuthenticationProvider() != null) {
                int n3 = this.getAuthenticationProvider().acceptServerAuthentication(sVNURL, string3, byArray, bl2);
                if (n3 == 2 && bl2) {
                    if (bl2 && byArray != null && this.myProviders[2] instanceof ISVNPersistentAuthenticationProvider) {
                        ((ISVNPersistentAuthenticationProvider)((Object)this.myProviders[2])).saveFingerprints(string3, byArray);
                    }
                } else if (n3 == 0) {
                    throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_NOT_SAVED, "Host key ('" + string3 + "') can not be verified."));
                }
                if (byArray != null) {
                    this.getRuntimeAuthStorage().putData("svn.ssh.server", string3, byArray);
                }
            }
        }
    }

    private static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == byArray) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public void dismissSensitiveData() {
        if (this.myRuntimeAuthStorage instanceof DefaultSVNAuthenticationManager$RuntimeStorage) {
            ((DefaultSVNAuthenticationManager$RuntimeStorage)this.myRuntimeAuthStorage).clear();
        }
        if (this.myProviders[0] instanceof DefaultSVNAuthenticationManager$DumbAuthenticationProvider) {
            ((DefaultSVNAuthenticationManager$DumbAuthenticationProvider)this.myProviders[0]).dismissSensitiveData();
        }
    }

    @Override
    public boolean isSSLPassphrasePromtSupported() {
        if (this.getAuthenticationProvider() == null) {
            return true;
        }
        if (this.getAuthenticationProvider() instanceof ISVNSSLPasspharsePromptSupport) {
            return ((ISVNSSLPasspharsePromptSupport)((Object)this.getAuthenticationProvider())).isSSLPassphrasePromtSupported();
        }
        return false;
    }

    static /* synthetic */ File access$400(DefaultSVNAuthenticationManager defaultSVNAuthenticationManager) {
        return defaultSVNAuthenticationManager.myConfigDirectory;
    }

    static /* synthetic */ boolean access$500(DefaultSVNAuthenticationManager defaultSVNAuthenticationManager) {
        return defaultSVNAuthenticationManager.myIsStoreAuth;
    }
}

