/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultLoadHandler$NodeBaton;
import org.tmatesoft.svn.core.internal.wc.DefaultLoadHandler$RevisionBaton;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultLoadHandler
implements ISVNLoadHandler {
    private FSFS myFSFS;
    private DefaultLoadHandler$RevisionBaton myCurrentRevisionBaton;
    private DefaultLoadHandler$NodeBaton myCurrentNodeBaton;
    private boolean myIsUsePreCommitHook;
    private boolean myIsUsePostCommitHook;
    private Map myRevisionsMap;
    private String myParentDir;
    private SVNUUIDAction myUUIDAction;
    private SVNDeltaReader myDeltaReader;
    private SVNDeltaGenerator myDeltaGenerator;
    private ISVNAdminEventHandler myProgressHandler;

    public DefaultLoadHandler(boolean bl2, boolean bl3, SVNUUIDAction sVNUUIDAction, String string, ISVNAdminEventHandler iSVNAdminEventHandler) {
        this.myProgressHandler = iSVNAdminEventHandler;
        this.myIsUsePreCommitHook = bl2;
        this.myIsUsePostCommitHook = bl3;
        this.myUUIDAction = sVNUUIDAction;
        this.myParentDir = SVNPathUtil.canonicalizePath(string);
        this.myRevisionsMap = new SVNHashMap();
    }

    public void setFSFS(FSFS fSFS) {
        this.myFSFS = fSFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRevision() {
        if (this.myCurrentRevisionBaton != null) {
            Object object;
            File file;
            this.myCurrentRevisionBaton.getConsumer().close();
            DefaultLoadHandler$RevisionBaton defaultLoadHandler$RevisionBaton = this.myCurrentRevisionBaton;
            this.myCurrentRevisionBaton = null;
            if (defaultLoadHandler$RevisionBaton.myRevision <= 0L) {
                return;
            }
            long l2 = defaultLoadHandler$RevisionBaton.myRevision;
            long l3 = -1L;
            try {
                l3 = defaultLoadHandler$RevisionBaton.getCommitter().commitTxn(this.myIsUsePreCommitHook, this.myIsUsePostCommitHook, null, null);
            }
            catch (SVNException sVNException) {
                try {
                    FSCommitter.abortTransaction(this.myFSFS, defaultLoadHandler$RevisionBaton.myTxn.getTxnId());
                }
                catch (SVNException sVNException2) {
                    // empty catch block
                }
                throw sVNException;
            }
            if (defaultLoadHandler$RevisionBaton.myDatestamp == null) {
                this.myFSFS.setRevisionProperty(defaultLoadHandler$RevisionBaton.myRevision, "svn:date", null);
            }
            if (!(file = this.myFSFS.getRevisionPropertiesFile(defaultLoadHandler$RevisionBaton.myRevision, true)).exists()) {
                object = SVNFileUtil.openFileForWriting(file);
                try {
                    SVNWCProperties.setProperties(new SVNProperties(), (OutputStream)object, "END");
                }
                finally {
                    SVNFileUtil.closeFile((OutputStream)object);
                }
            }
            this.myRevisionsMap.put(l2, l3);
            if (defaultLoadHandler$RevisionBaton.myDatestamp != null) {
                this.myFSFS.setRevisionProperty(l3, "svn:date", defaultLoadHandler$RevisionBaton.myDatestamp);
            }
            object = l3 == defaultLoadHandler$RevisionBaton.myRevision ? "\n------- Committed revision " + l3 + " >>>" : "\n------- Committed new rev " + l3 + " (loaded from original rev " + defaultLoadHandler$RevisionBaton.myRevision + ") >>>";
            if (this.myProgressHandler != null) {
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(l3, defaultLoadHandler$RevisionBaton.myRevision, SVNAdminEventAction.REVISION_LOADED, (String)object);
                this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
            }
        }
    }

    @Override
    public void openRevision(Map map) {
        this.myCurrentRevisionBaton = new DefaultLoadHandler$RevisionBaton(this);
        long l2 = -1L;
        if (map.containsKey("Revision-number")) {
            try {
                l2 = Long.parseLong((String)map.get("Revision-number"));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", map.get("Revision-number"));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        this.myCurrentRevisionBaton.myRevision = l2;
        long l3 = this.myFSFS.getYoungestRevision();
        this.myCurrentRevisionBaton.myRevisionOffset = l2 - (l3 + 1L);
        if (l2 > 0L) {
            this.myCurrentRevisionBaton.myTxn = FSTransactionRoot.beginTransaction(l3, 0, this.myFSFS);
            this.myCurrentRevisionBaton.myTxnRoot = this.myFSFS.createTransactionRoot(this.myCurrentRevisionBaton.myTxn);
            String string = "<<< Started new transaction, based on original revision " + l2;
            if (this.myProgressHandler != null) {
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(l2, SVNAdminEventAction.REVISION_LOAD, string);
                this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
            }
        }
    }

    @Override
    public void openNode(Map map) {
        Object object;
        if (this.myCurrentRevisionBaton.myRevision == 0L) {
            object = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpstream: Revision 0 must not contain node records");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        this.myCurrentNodeBaton = this.createNodeBaton(map);
        switch (this.myCurrentNodeBaton.myAction) {
            case 0: {
                object = "     * editing path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler == null) break;
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_EDIT_PATH, this.myCurrentNodeBaton.myPath, (String)object);
                this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                break;
            }
            case 2: {
                object = "     * deleting path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler != null) {
                    SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_DELETE_PATH, this.myCurrentNodeBaton.myPath, (String)object);
                    this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                }
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                break;
            }
            case 1: {
                object = "     * adding path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.maybeAddWithHistory(this.myCurrentNodeBaton)) {
                    object = (String)object + "COPIED...";
                }
                if (this.myProgressHandler == null) break;
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_ADD_PATH, this.myCurrentNodeBaton.myPath, (String)object);
                this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                break;
            }
            case 3: {
                object = "     * replacing path : " + this.myCurrentNodeBaton.myPath + " ...";
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                if (this.maybeAddWithHistory(this.myCurrentNodeBaton)) {
                    object = (String)object + "COPIED...";
                }
                if (this.myProgressHandler == null) break;
                SVNAdminEvent sVNAdminEvent = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_REPLACE_PATH, this.myCurrentNodeBaton.myPath, (String)object);
                this.myProgressHandler.handleAdminEvent(sVNAdminEvent, -1.0);
                break;
            }
            default: {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNRECOGNIZED_DATA, "Unrecognized node-action on node ''{0}''", (Object)this.myCurrentNodeBaton.myPath);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
    }

    @Override
    public void parseUUID(String string) {
        long l2;
        if (this.myUUIDAction == SVNUUIDAction.IGNORE_UUID) {
            return;
        }
        if (this.myUUIDAction != SVNUUIDAction.FORCE_UUID && (l2 = this.myFSFS.getYoungestRevision()) != 0L) {
            return;
        }
        this.myFSFS.setUUID(string);
    }

    @Override
    public void closeNode() {
        this.myCurrentNodeBaton = null;
    }

    @Override
    public void applyTextDelta() {
        FSDeltaConsumer fSDeltaConsumer = this.myCurrentRevisionBaton.getConsumer();
        fSDeltaConsumer.applyTextDelta(this.myCurrentNodeBaton.myPath, this.myCurrentNodeBaton.myBaseChecksum);
    }

    @Override
    public void setFullText() {
        FSDeltaConsumer fSDeltaConsumer = this.myCurrentRevisionBaton.getConsumer();
        fSDeltaConsumer.applyText(this.myCurrentNodeBaton.myPath);
    }

    @Override
    public void parseTextBlock(InputStream inputStream, long l2, boolean bl2) {
        FSDeltaConsumer fSDeltaConsumer = this.myCurrentRevisionBaton.getConsumer();
        try {
            Object object;
            if (bl2) {
                this.applyTextDelta();
            } else {
                this.setFullText();
            }
            String string = null;
            byte[] byArray = null;
            if (l2 == 0L) {
                this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, SVNFileUtil.DUMMY_IN, fSDeltaConsumer, false);
            } else if (!bl2) {
                object = new FixedSizeInputStream(inputStream, l2);
                string = this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, (InputStream)object, fSDeltaConsumer, true);
            } else {
                byArray = new byte[16384];
                object = null;
                try {
                    while (l2 > 0L) {
                        int n2;
                        int n3 = 0;
                        for (int i2 = l2 > 16384L ? 16384 : (int)l2; i2 > 0; i2 -= n2) {
                            n2 = inputStream.read(byArray, n3, i2);
                            if (n2 < 0) {
                                SVNAdminHelper.generateIncompleteDataError();
                            }
                            n3 += n2;
                        }
                        object = this.getDeltaReader();
                        ((SVNDeltaReader)object).nextWindow(byArray, 0, n3, this.myCurrentNodeBaton.myPath, fSDeltaConsumer);
                        l2 -= (long)n3;
                    }
                }
                catch (IOException iOException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                    SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
                }
                if (object != null) {
                    ((SVNDeltaReader)object).reset(this.myCurrentNodeBaton.myPath, fSDeltaConsumer);
                }
                fSDeltaConsumer.textDeltaEnd(this.myCurrentNodeBaton.myPath);
                string = fSDeltaConsumer.getChecksum();
            }
            if (string != null && this.myCurrentNodeBaton.myResultChecksum != null && !string.equals(this.myCurrentNodeBaton.myResultChecksum)) {
                object = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}'':\n   expected:  {1}\n     actual:  {2}\n", this.myCurrentNodeBaton.myPath, this.myCurrentNodeBaton.myResultChecksum, string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
        }
        catch (SVNException sVNException) {
            fSDeltaConsumer.abort();
            throw sVNException;
        }
    }

    @Override
    public void removeNodeProperties() {
        FSTransactionRoot fSTransactionRoot = this.myCurrentRevisionBaton.myTxnRoot;
        FSRevisionNode fSRevisionNode = fSTransactionRoot.getRevisionNode(this.myCurrentNodeBaton.myPath);
        SVNProperties sVNProperties = fSRevisionNode.getProperties(this.myFSFS);
        for (String string : sVNProperties.nameSet()) {
            this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, string, null);
        }
    }

    @Override
    public void setRevisionProperty(String string, SVNPropertyValue sVNPropertyValue) {
        long l2;
        if (this.myCurrentRevisionBaton.myRevision > 0L) {
            this.myFSFS.setTransactionProperty(this.myCurrentRevisionBaton.myTxn.getTxnId(), string, sVNPropertyValue);
            if ("svn:date".equals(string)) {
                this.myCurrentRevisionBaton.myDatestamp = sVNPropertyValue;
            }
        } else if (this.myCurrentRevisionBaton.myRevision == 0L && (l2 = this.myFSFS.getYoungestRevision()) == 0L) {
            this.myFSFS.setRevisionProperty(0L, string, sVNPropertyValue);
        }
    }

    public void setUsePreCommitHook(boolean bl2) {
        this.myIsUsePreCommitHook = bl2;
    }

    public void setUsePostCommitHook(boolean bl2) {
        this.myIsUsePostCommitHook = bl2;
    }

    public void setParentDir(String string) {
        this.myParentDir = string;
    }

    public void setUUIDAction(SVNUUIDAction sVNUUIDAction) {
        this.myUUIDAction = sVNUUIDAction;
    }

    @Override
    public void deleteNodeProperty(String string) {
        this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, string, null);
    }

    @Override
    public void setNodeProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if ("svn:mergeinfo".equals(string)) {
            Map map = this.renumberMergeInfoRevisions(sVNPropertyValue);
            if (this.myParentDir != null) {
                map = this.prefixMergeInfoPaths(map);
            }
            String string2 = SVNMergeInfoUtil.formatMergeInfoToString(map, null);
            sVNPropertyValue = SVNPropertyValue.create(string2);
        }
        this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, string, sVNPropertyValue);
    }

    private SVNDeltaReader getDeltaReader() {
        if (this.myDeltaReader == null) {
            this.myDeltaReader = new SVNDeltaReader();
        }
        return this.myDeltaReader;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private boolean maybeAddWithHistory(DefaultLoadHandler$NodeBaton defaultLoadHandler$NodeBaton) {
        FSRevisionNode fSRevisionNode;
        String string;
        Object object;
        if (defaultLoadHandler$NodeBaton.myCopyFromPath == null) {
            if (defaultLoadHandler$NodeBaton.myKind == SVNNodeKind.FILE) {
                this.myCurrentRevisionBaton.getCommitter().makeFile(defaultLoadHandler$NodeBaton.myPath);
            } else if (defaultLoadHandler$NodeBaton.myKind == SVNNodeKind.DIR) {
                this.myCurrentRevisionBaton.getCommitter().makeDir(defaultLoadHandler$NodeBaton.myPath);
            }
            return false;
        }
        long l2 = defaultLoadHandler$NodeBaton.myCopyFromRevision - this.myCurrentRevisionBaton.myRevisionOffset;
        Long l3 = defaultLoadHandler$NodeBaton.myCopyFromRevision;
        if (this.myRevisionsMap.containsKey(l3)) {
            object = (Long)this.myRevisionsMap.get(l3);
            l2 = (Long)object;
        }
        if (!SVNRevision.isValidRevisionNumber(l2)) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Relative source revision {0} is not available in current repository", (Object)l2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        object = this.myFSFS.createRevisionRoot(l2);
        if (defaultLoadHandler$NodeBaton.myCopySourceChecksum != null && (string = (fSRevisionNode = ((FSRoot)object).getRevisionNode(defaultLoadHandler$NodeBaton.myCopyFromPath)).getFileMD5Checksum()) != null && !string.equals(defaultLoadHandler$NodeBaton.myCopySourceChecksum)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Copy source checksum mismatch on copy from ''{0}''@{1}\n to ''{2}'' in rev based on r{3}:\n   expected:  {4}\n     actual:  {5}\n", defaultLoadHandler$NodeBaton.myCopyFromPath, String.valueOf(l2), defaultLoadHandler$NodeBaton.myPath, String.valueOf(this.myCurrentRevisionBaton.myRevision), defaultLoadHandler$NodeBaton.myCopySourceChecksum, string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        this.myCurrentRevisionBaton.getCommitter().makeCopy((FSRevisionRoot)object, defaultLoadHandler$NodeBaton.myCopyFromPath, defaultLoadHandler$NodeBaton.myPath, true);
        return true;
    }

    private DefaultLoadHandler$NodeBaton createNodeBaton(Map map) {
        String string;
        DefaultLoadHandler$NodeBaton defaultLoadHandler$NodeBaton = new DefaultLoadHandler$NodeBaton(this, null);
        defaultLoadHandler$NodeBaton.myKind = SVNNodeKind.UNKNOWN;
        if (map.containsKey("Node-path")) {
            string = (String)map.get("Node-path");
            defaultLoadHandler$NodeBaton.myPath = this.myParentDir != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myParentDir, string)) : SVNPathUtil.getAbsolutePath(SVNPathUtil.canonicalizePath(string));
        }
        if (map.containsKey("Node-kind")) {
            defaultLoadHandler$NodeBaton.myKind = SVNNodeKind.parseKind((String)map.get("Node-kind"));
        }
        defaultLoadHandler$NodeBaton.myAction = -1;
        if (map.containsKey("Node-action")) {
            string = (String)map.get("Node-action");
            if ("change".equals(string)) {
                defaultLoadHandler$NodeBaton.myAction = 0;
            } else if ("add".equals(string)) {
                defaultLoadHandler$NodeBaton.myAction = 1;
            } else if ("delete".equals(string)) {
                defaultLoadHandler$NodeBaton.myAction = 2;
            } else if ("replace".equals(string)) {
                defaultLoadHandler$NodeBaton.myAction = 3;
            }
        }
        defaultLoadHandler$NodeBaton.myCopyFromRevision = -1L;
        if (map.containsKey("Node-copyfrom-rev")) {
            try {
                defaultLoadHandler$NodeBaton.myCopyFromRevision = Long.parseLong((String)map.get("Node-copyfrom-rev"));
            }
            catch (NumberFormatException numberFormatException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", map.get("Node-copyfrom-rev"));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
        }
        if (map.containsKey("Node-copyfrom-path")) {
            string = (String)map.get("Node-copyfrom-path");
            defaultLoadHandler$NodeBaton.myCopyFromPath = this.myParentDir != null ? SVNPathUtil.append(this.myParentDir, string) : SVNPathUtil.canonicalizePath(string);
            defaultLoadHandler$NodeBaton.myCopyFromPath = SVNPathUtil.getAbsolutePath(defaultLoadHandler$NodeBaton.myCopyFromPath);
        }
        if (map.containsKey("Text-content-md5")) {
            defaultLoadHandler$NodeBaton.myResultChecksum = (String)map.get("Text-content-md5");
        }
        if (map.containsKey("Text-delta-base-md5")) {
            defaultLoadHandler$NodeBaton.myBaseChecksum = (String)map.get("Text-delta-base-md5");
        }
        if (map.containsKey("Text-copy-source-md5")) {
            defaultLoadHandler$NodeBaton.myCopySourceChecksum = (String)map.get("Text-copy-source-md5");
        }
        return defaultLoadHandler$NodeBaton;
    }

    private Map renumberMergeInfoRevisions(SVNPropertyValue sVNPropertyValue) {
        String string = SVNPropertyValue.getPropertyAsString(sVNPropertyValue);
        Map map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string), null);
        for (String string2 : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
            Object[] objectArray = sVNMergeRangeList.getRanges();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                Long l2 = (Long)this.myRevisionsMap.get(((SVNMergeRange)object).getStartRevision());
                if (l2 != null && SVNRevision.isValidRevisionNumber(l2)) {
                    ((SVNMergeRange)object).setStartRevision(l2);
                }
                if ((l2 = (Long)this.myRevisionsMap.get(((SVNMergeRange)object).getEndRevision())) == null || !SVNRevision.isValidRevisionNumber(l2)) continue;
                ((SVNMergeRange)object).setEndRevision(l2);
            }
            Arrays.sort(objectArray);
        }
        return map;
    }

    private Map prefixMergeInfoPaths(Map map) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        for (String string : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            string = string.startsWith("/") ? string.substring(1) : string;
            if ((string = SVNPathUtil.append(this.myParentDir, string)).charAt(0) != '/') {
                string = '/' + string;
            }
            treeMap.put(string, sVNMergeRangeList);
        }
        return treeMap;
    }

    static /* synthetic */ FSFS access$200(DefaultLoadHandler defaultLoadHandler) {
        return defaultLoadHandler.myFSFS;
    }
}

