/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler$NodeBaton;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler$RevisionBaton;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler$RevisionItem;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultDumpFilterHandler
implements ISVNLoadHandler {
    private boolean myIsDoRenumberRevisions;
    private boolean myIsDoExclude;
    private boolean myIsPreserveRevisionProps;
    private boolean myIsDropEmptyRevisions;
    private boolean myIsSkipMissingMergeSources;
    private long myDroppedRevisionsCount = 0L;
    private long myLastLiveRevision = -1L;
    private OutputStream myOutputStream;
    private Collection myPrefixes;
    private Map myDroppedNodes;
    private Map myRenumberHistory;
    private DefaultDumpFilterHandler$RevisionBaton myCurrentRevisionBaton;
    private DefaultDumpFilterHandler$NodeBaton myCurrentNodeBaton;
    private ISVNAdminEventHandler myEventHandler;

    public DefaultDumpFilterHandler(OutputStream outputStream, ISVNAdminEventHandler iSVNAdminEventHandler, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Collection collection, boolean bl6) {
        this.myOutputStream = outputStream;
        this.myEventHandler = iSVNAdminEventHandler;
        this.myIsDoExclude = bl2;
        this.myIsDoRenumberRevisions = bl3;
        this.myIsDropEmptyRevisions = bl4;
        this.myIsPreserveRevisionProps = bl5;
        this.myIsSkipMissingMergeSources = bl6;
        this.myPrefixes = collection;
        this.myDroppedNodes = new SVNHashMap();
        this.myRenumberHistory = new SVNHashMap();
    }

    public void reset(OutputStream outputStream, ISVNAdminEventHandler iSVNAdminEventHandler, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Collection collection, boolean bl6) {
        this.myDroppedRevisionsCount = 0L;
        this.myLastLiveRevision = -1L;
        this.myOutputStream = outputStream;
        this.myEventHandler = iSVNAdminEventHandler;
        this.myIsDoExclude = bl2;
        this.myIsDoRenumberRevisions = bl3;
        this.myIsDropEmptyRevisions = bl4;
        this.myIsPreserveRevisionProps = bl5;
        this.myIsSkipMissingMergeSources = bl6;
        this.myPrefixes = collection;
        this.myDroppedNodes.clear();
        this.myRenumberHistory.clear();
    }

    @Override
    public void closeNode() {
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            return;
        }
        if (!this.myCurrentNodeBaton.myHasWritingBegun) {
            this.outputNode(this.myCurrentNodeBaton);
        }
        this.writeDumpData(this.myOutputStream, "\n\n");
    }

    @Override
    public void closeRevision() {
        if (this.myCurrentRevisionBaton != null && !this.myCurrentRevisionBaton.myHasWritingBegun) {
            this.outputRevision(this.myCurrentRevisionBaton);
        }
    }

    @Override
    public void openNode(Map map) {
        this.myCurrentNodeBaton = new DefaultDumpFilterHandler$NodeBaton(this);
        String string = (String)map.get("Node-path");
        String string2 = (String)map.get("Node-copyfrom-path");
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string2 != null && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        this.myCurrentNodeBaton.myIsDoSkip = this.skipPath(string);
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            this.myDroppedNodes.put(string, string);
            this.myCurrentRevisionBaton.myHadDroppedNodes = true;
        } else {
            long l2 = this.getLongFromHeaders("Text-content-length", map);
            if (string2 != null && this.skipPath(string2)) {
                SVNNodeKind sVNNodeKind = this.getNodeKindFromHeaders("Node-kind", map);
                if (l2 >= 0L && sVNNodeKind == SVNNodeKind.FILE) {
                    map.remove("Node-copyfrom-path");
                    map.remove("Node-copyfrom-rev");
                    string2 = null;
                } else {
                    Object object = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Invalid copy source path ''{0}''", (Object)string2);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                }
            }
            this.myCurrentNodeBaton.myTextContentLength = l2 > 0L ? l2 : 0L;
            this.myCurrentRevisionBaton.myHasNodes = true;
            if (!this.myCurrentRevisionBaton.myHasWritingBegun) {
                this.outputRevision(this.myCurrentRevisionBaton);
            }
            for (Object object : map.keySet()) {
                if (((String)object).equals("Content-length") || ((String)object).equals("Prop-content-length") || ((String)object).equals("Text-content-length")) continue;
                String string3 = (String)map.get(object);
                if (this.myIsDoRenumberRevisions && ((String)object).equals("Node-copyfrom-rev")) {
                    long l3 = -1L;
                    try {
                        l3 = Long.parseLong(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, numberFormatException), SVNLogType.FSFS);
                    }
                    DefaultDumpFilterHandler$RevisionItem defaultDumpFilterHandler$RevisionItem = (DefaultDumpFilterHandler$RevisionItem)this.myRenumberHistory.get(l3);
                    if (defaultDumpFilterHandler$RevisionItem == null || !SVNRevision.isValidRevisionNumber(defaultDumpFilterHandler$RevisionItem.myRevision)) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid copyfrom revision in filtered stream");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                    this.writeDumpData(this.myOutputStream, "Node-copyfrom-rev: " + defaultDumpFilterHandler$RevisionItem.myRevision + "\n");
                    continue;
                }
                this.writeDumpData(this.myOutputStream, (String)object + ": " + string3 + "\n");
            }
        }
    }

    @Override
    public void openRevision(Map map) {
        DefaultDumpFilterHandler$RevisionBaton defaultDumpFilterHandler$RevisionBaton = new DefaultDumpFilterHandler$RevisionBaton(this);
        defaultDumpFilterHandler$RevisionBaton.myProperties = new SVNProperties();
        defaultDumpFilterHandler$RevisionBaton.myOriginalRevision = this.getLongFromHeaders("Revision-number", map);
        defaultDumpFilterHandler$RevisionBaton.myActualRevision = this.myIsDoRenumberRevisions ? defaultDumpFilterHandler$RevisionBaton.myOriginalRevision - this.myDroppedRevisionsCount : defaultDumpFilterHandler$RevisionBaton.myOriginalRevision;
        defaultDumpFilterHandler$RevisionBaton.writeToHeader("Revision-number: " + defaultDumpFilterHandler$RevisionBaton.myActualRevision + "\n");
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            if (string.equals("Content-length") || string.equals("Prop-content-length") || string.equals("Revision-number")) continue;
            defaultDumpFilterHandler$RevisionBaton.writeToHeader(string + ": " + string2 + "\n");
        }
        this.myCurrentRevisionBaton = defaultDumpFilterHandler$RevisionBaton;
    }

    @Override
    public void parseTextBlock(InputStream inputStream, long l2, boolean bl2) {
        if (bl2) {
            this.applyTextDelta();
        } else {
            this.setFullText();
        }
        byte[] byArray = null;
        if (l2 > 0L) {
            byArray = new byte[16384];
            while (l2 > 0L) {
                int n2;
                int n3 = 0;
                for (int i2 = l2 > 16384L ? 16384 : (int)l2; i2 > 0; i2 -= n2) {
                    n2 = -1;
                    try {
                        n2 = inputStream.read(byArray, n3, i2);
                    }
                    catch (IOException iOException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                        SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
                    }
                    if (n2 < 0) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                    n3 += n2;
                }
                if (!this.myCurrentNodeBaton.myIsDoSkip) {
                    try {
                        this.myOutputStream.write(byArray, 0, n3);
                    }
                    catch (IOException iOException) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Unexpected EOF writing contents");
                        SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
                    }
                }
                l2 -= (long)n3;
            }
        }
    }

    @Override
    public void parseUUID(String string) {
        this.writeDumpData(this.myOutputStream, "UUID: " + string + "\n\n");
    }

    @Override
    public void removeNodeProperties() {
        this.myCurrentNodeBaton.myHasProps = true;
    }

    @Override
    public void setFullText() {
        if (!this.myCurrentNodeBaton.myIsDoSkip) {
            this.myCurrentNodeBaton.myHasText = true;
            if (!this.myCurrentNodeBaton.myHasWritingBegun) {
                this.outputNode(this.myCurrentNodeBaton);
            }
        }
    }

    @Override
    public void setRevisionProperty(String string, SVNPropertyValue sVNPropertyValue) {
        this.myCurrentRevisionBaton.myHasProps = true;
        if (sVNPropertyValue == null) {
            this.myCurrentRevisionBaton.myProperties.remove(string);
        } else {
            this.myCurrentRevisionBaton.myProperties.put(string, sVNPropertyValue);
        }
    }

    @Override
    public void setNodeProperty(String string, SVNPropertyValue sVNPropertyValue) {
        Object object;
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            return;
        }
        if (!this.myCurrentNodeBaton.myHasProps) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Delta property block detected - not supported by svndumpfilter");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
        }
        if (string.equals("svn:mergeinfo")) {
            object = this.adjustMergeInfo(sVNPropertyValue);
            sVNPropertyValue = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString((Map)object, null));
        }
        this.myCurrentNodeBaton.writeProperty(string, sVNPropertyValue);
    }

    @Override
    public void deleteNodeProperty(String string) {
    }

    @Override
    public void applyTextDelta() {
    }

    public long getDroppedRevisionsCount() {
        return this.myDroppedRevisionsCount;
    }

    public Map getRenumberHistory() {
        return this.myRenumberHistory;
    }

    public Map getDroppedNodes() {
        return this.myDroppedNodes;
    }

    private void outputRevision(DefaultDumpFilterHandler$RevisionBaton defaultDumpFilterHandler$RevisionBaton) {
        Object object;
        Object object2;
        defaultDumpFilterHandler$RevisionBaton.myHasWritingBegun = true;
        if (!this.myIsPreserveRevisionProps && !defaultDumpFilterHandler$RevisionBaton.myHasNodes && defaultDumpFilterHandler$RevisionBaton.myHadDroppedNodes && !this.myIsDropEmptyRevisions) {
            object2 = defaultDumpFilterHandler$RevisionBaton.myProperties;
            defaultDumpFilterHandler$RevisionBaton.myHasProps = true;
            defaultDumpFilterHandler$RevisionBaton.myProperties = new SVNProperties();
            defaultDumpFilterHandler$RevisionBaton.myProperties.put("svn:date", ((SVNProperties)object2).getSVNPropertyValue("svn:date"));
            defaultDumpFilterHandler$RevisionBaton.myProperties.put("svn:log", "This is an empty revision for padding.");
        }
        object2 = new ByteArrayOutputStream();
        if (defaultDumpFilterHandler$RevisionBaton.myHasProps) {
            for (String string : defaultDumpFilterHandler$RevisionBaton.myProperties.nameSet()) {
                SVNPropertyValue sVNPropertyValue = defaultDumpFilterHandler$RevisionBaton.myProperties.getSVNPropertyValue(string);
                this.writeProperty((OutputStream)object2, string, sVNPropertyValue);
            }
            this.writeDumpData((OutputStream)object2, "PROPS-END\n");
            defaultDumpFilterHandler$RevisionBaton.writeToHeader("Prop-content-length: " + ((ByteArrayOutputStream)object2).size() + "\n");
        }
        defaultDumpFilterHandler$RevisionBaton.writeToHeader("Content-length: " + ((ByteArrayOutputStream)object2).size() + "\n\n");
        this.writeDumpData((OutputStream)object2, "\n");
        if (defaultDumpFilterHandler$RevisionBaton.myHasNodes || !this.myIsDropEmptyRevisions || !defaultDumpFilterHandler$RevisionBaton.myHadDroppedNodes) {
            this.writeDumpData(this.myOutputStream, defaultDumpFilterHandler$RevisionBaton.myHeaderBuffer.toByteArray());
            this.writeDumpData(this.myOutputStream, ((ByteArrayOutputStream)object2).toByteArray());
            if (this.myIsDoRenumberRevisions) {
                this.myRenumberHistory.put(defaultDumpFilterHandler$RevisionBaton.myOriginalRevision, new DefaultDumpFilterHandler$RevisionItem(this, defaultDumpFilterHandler$RevisionBaton.myActualRevision, false));
                this.myLastLiveRevision = defaultDumpFilterHandler$RevisionBaton.myActualRevision;
            }
            object = MessageFormat.format("Revision {0} committed as {1}.", String.valueOf(defaultDumpFilterHandler$RevisionBaton.myOriginalRevision), String.valueOf(defaultDumpFilterHandler$RevisionBaton.myActualRevision));
            this.dispatchEvent(new SVNAdminEvent(defaultDumpFilterHandler$RevisionBaton.myActualRevision, defaultDumpFilterHandler$RevisionBaton.myOriginalRevision, SVNAdminEventAction.DUMP_FILTER_REVISION_COMMITTED, (String)object));
        } else {
            ++this.myDroppedRevisionsCount;
            if (this.myIsDoRenumberRevisions) {
                this.myRenumberHistory.put(defaultDumpFilterHandler$RevisionBaton.myOriginalRevision, new DefaultDumpFilterHandler$RevisionItem(this, this.myLastLiveRevision, true));
            }
            object = MessageFormat.format("Revision {0} skipped.", String.valueOf(defaultDumpFilterHandler$RevisionBaton.myOriginalRevision));
            this.dispatchEvent(new SVNAdminEvent(defaultDumpFilterHandler$RevisionBaton.myOriginalRevision, SVNAdminEventAction.DUMP_FILTER_REVISION_SKIPPED, (String)object));
        }
    }

    private void outputNode(DefaultDumpFilterHandler$NodeBaton defaultDumpFilterHandler$NodeBaton) {
        defaultDumpFilterHandler$NodeBaton.myHasWritingBegun = true;
        if (defaultDumpFilterHandler$NodeBaton.myHasProps) {
            defaultDumpFilterHandler$NodeBaton.writeToPropertyBuffer("PROPS-END\n");
            defaultDumpFilterHandler$NodeBaton.writeToHeader("Prop-content-length: " + defaultDumpFilterHandler$NodeBaton.myPropertiesBuffer.size() + "\n");
        }
        if (defaultDumpFilterHandler$NodeBaton.myHasText) {
            defaultDumpFilterHandler$NodeBaton.writeToHeader("Text-content-length: " + defaultDumpFilterHandler$NodeBaton.myTextContentLength + "\n");
        }
        defaultDumpFilterHandler$NodeBaton.writeToHeader("Content-length: " + ((long)defaultDumpFilterHandler$NodeBaton.myPropertiesBuffer.size() + defaultDumpFilterHandler$NodeBaton.myTextContentLength) + "\n\n");
        this.writeDumpData(this.myOutputStream, defaultDumpFilterHandler$NodeBaton.myHeaderBuffer.toByteArray());
        this.writeDumpData(this.myOutputStream, defaultDumpFilterHandler$NodeBaton.myPropertiesBuffer.toByteArray());
    }

    private void writeProperty(OutputStream outputStream, String string, SVNPropertyValue sVNPropertyValue) {
        try {
            this.writeDumpData(outputStream, "K ");
            byte[] byArray = string.getBytes("UTF-8");
            this.writeDumpData(outputStream, String.valueOf(byArray.length));
            this.writeDumpData(outputStream, "\n");
            this.writeDumpData(outputStream, byArray);
            this.writeDumpData(outputStream, "\n");
            this.writeDumpData(outputStream, "V ");
            byte[] byArray2 = SVNPropertyValue.getPropertyAsBytes(sVNPropertyValue);
            this.writeDumpData(outputStream, String.valueOf(byArray2.length));
            this.writeDumpData(outputStream, "\n");
            this.writeDumpData(outputStream, byArray2);
            this.writeDumpData(outputStream, "\n");
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private Map adjustMergeInfo(SVNPropertyValue sVNPropertyValue) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        Map map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(sVNPropertyValue.getString()), null);
        for (String string : map.keySet()) {
            Object[] objectArray;
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            if (this.skipPath(string)) {
                if (this.myIsSkipMissingMergeSources) continue;
                objectArray = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Missing merge source path ''{0}''; try with --skip-missing-merge-sources", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)objectArray, SVNLogType.FSFS);
            }
            if (this.myIsDoRenumberRevisions) {
                objectArray = sVNMergeRangeList.getRanges();
                for (int i2 = 0; i2 < sVNMergeRangeList.getSize(); ++i2) {
                    Object object;
                    Object object2 = objectArray[i2];
                    DefaultDumpFilterHandler$RevisionItem defaultDumpFilterHandler$RevisionItem = (DefaultDumpFilterHandler$RevisionItem)this.myRenumberHistory.get(((SVNMergeRange)object2).getStartRevision());
                    if (defaultDumpFilterHandler$RevisionItem == null || !SVNRevision.isValidRevisionNumber(defaultDumpFilterHandler$RevisionItem.myRevision)) {
                        object = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid revision range 'start' in filtered stream");
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                    }
                    if ((object = (DefaultDumpFilterHandler$RevisionItem)this.myRenumberHistory.get(((SVNMergeRange)object2).getEndRevision())) == null || !SVNRevision.isValidRevisionNumber(((DefaultDumpFilterHandler$RevisionItem)object).myRevision)) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid revision range 'end' in filtered stream");
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                    ((SVNMergeRange)object2).setStartRevision(defaultDumpFilterHandler$RevisionItem.myRevision);
                    ((SVNMergeRange)object2).setEndRevision(((DefaultDumpFilterHandler$RevisionItem)object).myRevision);
                }
                Arrays.sort(objectArray);
            }
            treeMap.put(string, sVNMergeRangeList);
        }
        return treeMap;
    }

    private SVNNodeKind getNodeKindFromHeaders(String string, Map map) {
        return SVNNodeKind.parseKind((String)map.get(string));
    }

    private long getLongFromHeaders(String string, Map map) {
        String string2 = (String)map.get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private void writeDumpData(OutputStream outputStream, String string) {
        try {
            outputStream.write(string.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private void writeDumpData(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.FSFS);
        }
    }

    private boolean skipPath(String string) {
        for (String string2 : this.myPrefixes) {
            if (!string.startsWith(string2)) continue;
            return this.myIsDoExclude;
        }
        return !this.myIsDoExclude;
    }

    private void dispatchEvent(SVNAdminEvent sVNAdminEvent) {
        if (this.myEventHandler != null) {
            this.myEventHandler.handleAdminEvent(sVNAdminEvent, -1.0);
        }
    }

    static /* synthetic */ void access$100(DefaultDumpFilterHandler defaultDumpFilterHandler, OutputStream outputStream, String string) {
        defaultDumpFilterHandler.writeDumpData(outputStream, string);
    }

    static /* synthetic */ void access$200(DefaultDumpFilterHandler defaultDumpFilterHandler, OutputStream outputStream, String string, SVNPropertyValue sVNPropertyValue) {
        defaultDumpFilterHandler.writeProperty(outputStream, string, sVNPropertyValue);
    }
}

