/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class AbstractSVNMerger
implements ISVNMerger {
    private byte[] myStart;
    private byte[] mySeparator;
    private byte[] myEnd;
    private SVNDiffOptions myDiffOptions;

    protected AbstractSVNMerger(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.myStart = byArray;
        this.mySeparator = byArray2;
        this.myEnd = byArray3;
    }

    protected byte[] getConflictSeparatorMarker() {
        return this.mySeparator;
    }

    protected byte[] getConflictStartMarker() {
        return this.myStart;
    }

    protected byte[] getConflictEndMarker() {
        return this.myEnd;
    }

    protected SVNDiffOptions getDiffOptions() {
        return this.myDiffOptions;
    }

    @Override
    public SVNMergeResult mergeText(SVNMergeFileSet sVNMergeFileSet, boolean bl2, SVNDiffOptions sVNDiffOptions) {
        Object object;
        this.myDiffOptions = sVNDiffOptions;
        SVNStatusType sVNStatusType = sVNMergeFileSet.isBinary() ? this.mergeBinary(sVNMergeFileSet.getBaseFile(), sVNMergeFileSet.getLocalFile(), sVNMergeFileSet.getRepositoryFile(), sVNDiffOptions, sVNMergeFileSet.getResultFile()) : this.mergeText(sVNMergeFileSet.getBaseFile(), sVNMergeFileSet.getLocalFile(), sVNMergeFileSet.getRepositoryFile(), sVNDiffOptions, sVNMergeFileSet.getResultFile());
        if (!sVNMergeFileSet.isBinary() && sVNStatusType != SVNStatusType.CONFLICTED) {
            if (sVNMergeFileSet.getCopyFromFile() != null) {
                sVNStatusType = SVNStatusType.MERGED;
            } else {
                object = sVNMergeFileSet.getAdminArea();
                SVNVersionedProperties sVNVersionedProperties = ((SVNAdminArea)object).getProperties(sVNMergeFileSet.getWCPath());
                boolean bl3 = sVNVersionedProperties.getPropertyValue("svn:special") != null;
                boolean bl4 = SVNFileUtil.compareFiles(bl3 ? sVNMergeFileSet.getLocalFile() : sVNMergeFileSet.getWCFile(), sVNMergeFileSet.getResultFile(), null);
                sVNStatusType = bl4 ? SVNStatusType.UNCHANGED : sVNStatusType;
            }
        }
        object = SVNMergeResult.createMergeResult(sVNStatusType, null);
        if (bl2) {
            return object;
        }
        return this.processMergedFiles(sVNMergeFileSet, (SVNMergeResult)object);
    }

    protected abstract SVNMergeResult processMergedFiles(SVNMergeFileSet var1, SVNMergeResult var2);

    protected abstract SVNStatusType mergeText(File var1, File var2, File var3, SVNDiffOptions var4, File var5);

    protected abstract SVNStatusType mergeBinary(File var1, File var2, File var3, SVNDiffOptions var4, File var5);
}

