/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Set;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class AbstractDiffCallback {
    private SVNAdminArea myAdminArea;
    private File myBasePath;
    private Set myDeletedPaths;

    protected AbstractDiffCallback(SVNAdminArea sVNAdminArea) {
        this.myAdminArea = sVNAdminArea;
    }

    public void setBasePath(File file) {
        this.myBasePath = file;
    }

    public abstract boolean isDiffUnversioned();

    public abstract boolean isDiffCopiedAsAdded();

    public abstract File createTempDirectory();

    public abstract SVNStatusType propertiesChanged(String var1, SVNProperties var2, SVNProperties var3, boolean[] var4);

    public abstract SVNStatusType[] fileChanged(String var1, File var2, File var3, long var4, long var6, String var8, String var9, SVNProperties var10, SVNProperties var11, boolean[] var12);

    public abstract SVNStatusType[] fileAdded(String var1, File var2, File var3, long var4, long var6, String var8, String var9, SVNProperties var10, SVNProperties var11, boolean[] var12);

    public abstract SVNStatusType fileDeleted(String var1, File var2, File var3, String var4, String var5, SVNProperties var6, boolean[] var7);

    public abstract SVNStatusType directoryAdded(String var1, long var2, boolean[] var4);

    public abstract SVNStatusType directoryDeleted(String var1, boolean[] var2);

    public abstract void directoryOpened(String var1, long var2, boolean[] var4);

    public abstract SVNStatusType[] directoryClosed(String var1, boolean[] var2);

    protected String getDisplayPath(String string) {
        if (this.myAdminArea == null) {
            if (this.myBasePath != null) {
                return new File(this.myBasePath, string).getAbsolutePath().replace(File.separatorChar, '/');
            }
            return string.replace(File.separatorChar, '/');
        }
        return this.myAdminArea.getFile(string).getAbsolutePath().replace(File.separatorChar, '/');
    }

    protected void categorizeProperties(SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNProperties sVNProperties3, SVNProperties sVNProperties4) {
        if (sVNProperties == null) {
            return;
        }
        for (String string : sVNProperties.nameSet()) {
            if (sVNProperties2 != null && SVNProperty.isRegularProperty(string)) {
                sVNProperties2.put(string, sVNProperties.getSVNPropertyValue(string));
                continue;
            }
            if (sVNProperties3 != null && SVNProperty.isEntryProperty(string)) {
                sVNProperties3.put(string, sVNProperties.getSVNPropertyValue(string));
                continue;
            }
            if (sVNProperties4 == null || !SVNProperty.isWorkingCopyProperty(string)) continue;
            sVNProperties4.put(string, sVNProperties.getSVNPropertyValue(string));
        }
    }

    protected SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    protected SVNWCAccess getWCAccess() {
        return this.getAdminArea().getWCAccess();
    }

    protected void addDeletedPath(String string) {
        if (this.myDeletedPaths == null) {
            this.myDeletedPaths = new SVNHashSet();
        }
        this.myDeletedPaths.add(string);
    }

    protected boolean isPathDeleted(String string) {
        return this.myDeletedPaths != null && this.myDeletedPaths.contains(string);
    }

    protected void clearDeletedPaths() {
        this.myDeletedPaths = null;
    }

    protected void setIsConflicted(boolean[] blArray, boolean bl2) {
        if (blArray != null && blArray.length > 0) {
            blArray[0] = bl2;
        }
    }
}

