/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNKernel32Library;
import org.tmatesoft.svn.core.internal.util.jna.ISVNWin32Library;
import org.tmatesoft.svn.core.internal.util.jna.ISVNWin32Library$HRESULT;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

class SVNWin32Util {
    SVNWin32Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = JNALibraryLoader.getKernelLibrary();
        if (iSVNKernel32Library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library2 = iSVNKernel32Library;
        synchronized (iSVNKernel32Library2) {
            try {
                int n2 = iSVNKernel32Library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(128L));
                return n2 != 0;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setHidden(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = JNALibraryLoader.getKernelLibrary();
        if (iSVNKernel32Library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library2 = iSVNKernel32Library;
        synchronized (iSVNKernel32Library2) {
            try {
                int n2 = iSVNKernel32Library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(2L));
                return n2 != 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = JNALibraryLoader.getKernelLibrary();
        if (iSVNKernel32Library == null) {
            return false;
        }
        if (file2.isFile() && !file2.canWrite()) {
            SVNFileUtil.setReadonly(file2, false);
            SVNFileUtil.setReadonly(file, true);
        }
        ISVNKernel32Library iSVNKernel32Library2 = iSVNKernel32Library;
        synchronized (iSVNKernel32Library2) {
            int n2 = 0;
            int n3 = SVNFileUtil.FILE_CREATION_ATTEMPTS_COUNT;
            long l2 = 1L;
            do {
                int n4 = 0;
                try {
                    n4 = iSVNKernel32Library.MoveFileExW(new WString(file.getAbsoluteFile().getAbsolutePath()), new WString(file2.getAbsoluteFile().getAbsolutePath()), new NativeLong(3L));
                }
                catch (Throwable throwable) {
                    return false;
                }
                if (n4 != 0) {
                    return true;
                }
                n2 = iSVNKernel32Library.GetLastError();
                --n3;
                if (n2 != 5) continue;
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (l2 >= 128L) continue;
                l2 *= 2L;
            } while (n2 == 5 && n3 >= 0);
        }
        return false;
    }

    public static String getApplicationDataPath(boolean bl2) {
        char[] cArray;
        ISVNWin32Library iSVNWin32Library = JNALibraryLoader.getWin32Library();
        if (iSVNWin32Library == null) {
            return null;
        }
        int n2 = bl2 ? 35 : 26;
        ISVNWin32Library$HRESULT iSVNWin32Library$HRESULT = iSVNWin32Library.SHGetFolderPathW(Pointer.NULL, n2, Pointer.NULL, ISVNWin32Library.SHGFP_TYPE_CURRENT, cArray = new char[1024]);
        if (iSVNWin32Library$HRESULT == null || iSVNWin32Library$HRESULT.longValue() != 0L) {
            return null;
        }
        int n3 = cArray.length;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '\u0000') continue;
            n3 = i2;
            break;
        }
        String string = new String(cArray, 0, n3);
        string = string.replace(File.separatorChar, '/');
        return string;
    }
}

