/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsCFLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

class SVNMacOsKeychain {
    private static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

    SVNMacOsKeychain() {
    }

    public static boolean isEnabled() {
        boolean bl2 = Boolean.valueOf(System.getProperty("svnkit.library.osxkeychain.enabled", "true"));
        return bl2 && SVNFileUtil.isOSX && JNALibraryLoader.getMacOsSecurityLibrary() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean setPassword(String string, String string2, char[] cArray, boolean bl2) {
        block16: {
            boolean bl3;
            byte[] byArray;
            block15: {
                ISVNMacOsSecurityLibrary iSVNMacOsSecurityLibrary = JNALibraryLoader.getMacOsSecurityLibrary();
                if (iSVNMacOsSecurityLibrary == null) {
                    return false;
                }
                if (string == null) {
                    return false;
                }
                if (bl2) {
                    iSVNMacOsSecurityLibrary.SecKeychainSetUserInteractionAllowed(false);
                }
                byArray = null;
                try {
                    byte[] byArray2 = string.getBytes("UTF-8");
                    byte[] byArray3 = string2 == null ? null : string2.getBytes("UTF-8");
                    int n2 = string2 == null ? 0 : byArray3.length;
                    byArray = SVNEncodingUtil.getBytes(cArray, "UTF-8");
                    PointerByReference pointerByReference = new PointerByReference();
                    int n3 = iSVNMacOsSecurityLibrary.SecKeychainFindGenericPassword(null, byArray2.length, byArray2, n2, byArray3, null, null, pointerByReference);
                    if (n3 == -25300) {
                        n3 = iSVNMacOsSecurityLibrary.SecKeychainAddGenericPassword(null, byArray2.length, byArray2, n2, byArray3, byArray.length, byArray, null);
                    } else {
                        Pointer pointer = pointerByReference.getValue();
                        try {
                            n3 = iSVNMacOsSecurityLibrary.SecKeychainItemModifyAttributesAndData(pointer, null, byArray.length, byArray);
                        }
                        finally {
                            SVNMacOsKeychain.release(pointer);
                        }
                    }
                    boolean bl4 = bl3 = n3 == 0;
                    if (!bl2) break block15;
                    iSVNMacOsSecurityLibrary.SecKeychainSetUserInteractionAllowed(true);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, unsupportedEncodingException);
                    SVNErrorManager.error(sVNErrorMessage, unsupportedEncodingException, SVNLogType.DEFAULT);
                    break block16;
                }
                finally {
                    if (bl2) {
                        iSVNMacOsSecurityLibrary.SecKeychainSetUserInteractionAllowed(true);
                    }
                    SVNEncodingUtil.clearArray(byArray);
                }
            }
            SVNEncodingUtil.clearArray(byArray);
            return bl3;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized char[] getPassword(String string, String string2, boolean bl2) {
        SVNErrorMessage sVNErrorMessage;
        ISVNMacOsSecurityLibrary iSVNMacOsSecurityLibrary = JNALibraryLoader.getMacOsSecurityLibrary();
        if (iSVNMacOsSecurityLibrary == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (bl2) {
            iSVNMacOsSecurityLibrary.SecKeychainSetUserInteractionAllowed(false);
        }
        try {
            char[] cArray;
            byte[] byArray = string.getBytes("UTF-8");
            sVNErrorMessage = string2 == null ? null : string2.getBytes("UTF-8");
            int n2 = string2 == null ? 0 : ((SVNErrorMessage)sVNErrorMessage).length;
            IntByReference intByReference = new IntByReference();
            PointerByReference pointerByReference = new PointerByReference();
            int n3 = iSVNMacOsSecurityLibrary.SecKeychainFindGenericPassword(null, byArray.length, byArray, n2, (byte[])sVNErrorMessage, intByReference, pointerByReference, null);
            if (n3 != 0) {
                char[] cArray2 = null;
                return cArray2;
            }
            Pointer pointer = pointerByReference.getValue();
            if (pointer == null) {
                char[] cArray3 = null;
                return cArray3;
            }
            int n4 = intByReference.getValue();
            byte[] byArray2 = pointer.getByteArray(0L, n4);
            try {
                cArray = SVNEncodingUtil.getChars(byArray2, "UTF-8");
            }
            finally {
                iSVNMacOsSecurityLibrary.SecKeychainItemFreeContent(null, pointer);
                SVNEncodingUtil.clearArray(byArray2);
            }
            char[] cArray4 = cArray;
            return cArray4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, unsupportedEncodingException);
            SVNErrorManager.error(sVNErrorMessage, unsupportedEncodingException, SVNLogType.DEFAULT);
            char[] cArray = null;
            return cArray;
        }
        finally {
            if (bl2) {
                iSVNMacOsSecurityLibrary.SecKeychainSetUserInteractionAllowed(true);
            }
        }
    }

    private static void release(Pointer pointer) {
        ISVNMacOsCFLibrary iSVNMacOsCFLibrary;
        if (pointer != null && (iSVNMacOsCFLibrary = JNALibraryLoader.getMacOsCFLibrary()) != null) {
            iSVNMacOsCFLibrary.CFRelease(pointer);
        }
    }
}

