/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Memory;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNCLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLinuxUtil {
    private static final int LOCK_SH = 1;
    private static final int LOCK_EX = 2;
    private static final int LOCK_UN = 8;
    private static Memory ourSharedMemory;
    private static final boolean ourIsDashStat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNFileType getFileType(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n2 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._lstat(string, ourSharedMemory) : (SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.__lxstat(3, string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? iSVNCLibrary.lstat(string, ourSharedMemory) : iSVNCLibrary.__lxstat64(0, string, ourSharedMemory)));
                }
                if (n2 < 0) {
                    if (file.exists() || file.isDirectory() || file.isFile()) {
                        return null;
                    }
                    return SVNFileType.NONE;
                }
                int n3 = SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? ourSharedMemory.getShort(SVNLinuxUtil.getFileModeOffset()) : ourSharedMemory.getInt(SVNLinuxUtil.getFileModeOffset());
                int n4 = n3 & 0xF000;
                if (n4 == 40960) {
                    return SVNFileType.SYMLINK;
                }
                if (n4 == 16384) {
                    return SVNFileType.DIRECTORY;
                }
                if (n4 == 32768) {
                    return SVNFileType.FILE;
                }
                if (file.exists() || file.isDirectory() || file.isFile()) {
                    return null;
                }
                return SVNFileType.NONE;
            }
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isExecutable(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n2 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._lstat(string, ourSharedMemory) : (SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.__lxstat(3, string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? iSVNCLibrary.lstat(string, ourSharedMemory) : iSVNCLibrary.__lxstat64(0, string, ourSharedMemory)));
                }
                if (n2 < 0) {
                    return null;
                }
                int n3 = ourSharedMemory.getInt(SVNLinuxUtil.getFileModeOffset());
                int n4 = ourSharedMemory.getInt(SVNLinuxUtil.getFileUserIDOffset());
                int n5 = ourSharedMemory.getInt(SVNLinuxUtil.getFileGroupIDOffset());
                int n6 = n3 & 0x1FF;
                int n7 = 73;
                n7 = JNALibraryLoader.getUID() == n4 ? 64 : (JNALibraryLoader.getGID() == n5 ? 8 : 1);
                return (n6 & n7) != 0;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinkTarget(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                ourSharedMemory.clear();
                Object object = iSVNCLibrary;
                synchronized (object) {
                    n2 = iSVNCLibrary.readlink(string, ourSharedMemory, 1024);
                }
                if (n2 <= 0) {
                    return null;
                }
                object = new byte[n2];
                ourSharedMemory.read(0L, (byte[])object, 0, n2);
                return new String((byte[])object, 0, n2);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Long getSymlinkLastModified(File file) {
        return SVNLinuxUtil.getLastModifiedMicros(file) / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLastModifiedMicros(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n2 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._lstat(string, ourSharedMemory) : (SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.__lxstat(3, string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? iSVNCLibrary.lstat(string, ourSharedMemory) : iSVNCLibrary.__lxstat64(0, string, ourSharedMemory)));
                }
                if (n2 < 0) {
                    return null;
                }
                long l2 = SVNFileUtil.is32Bit ? (long)ourSharedMemory.getInt(SVNLinuxUtil.getFileLastModifiedOffset()) : ourSharedMemory.getLong(SVNLinuxUtil.getFileLastModifiedOffset());
                long l3 = SVNFileUtil.is32Bit ? (long)ourSharedMemory.getInt(SVNLinuxUtil.getFileLastModifiedOffsetNanos()) : ourSharedMemory.getLong(SVNLinuxUtil.getFileLastModifiedOffsetNanos());
                return l2 * 1000000L + l3 / 1000L;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setExecutable(File file, boolean bl2) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return false;
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Calling JNA.setExecutable");
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                int n3;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n3 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._lstat(string, ourSharedMemory) : (SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.__lxstat(3, string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? iSVNCLibrary.lstat(string, ourSharedMemory) : iSVNCLibrary.__lxstat64(0, string, ourSharedMemory)));
                }
                if (n3 < 0) {
                    return false;
                }
                int n4 = ourSharedMemory.getInt(SVNLinuxUtil.getFileModeOffset());
                int n5 = n2 = n4 & 0x1FF;
                if (bl2) {
                    if ((n2 & 0x100) != 0) {
                        n5 |= 0x40;
                    }
                    if ((n2 & 0x20) != 0) {
                        n5 |= 8;
                    }
                    if ((n2 & 4) != 0) {
                        n5 |= 1;
                    }
                } else {
                    if ((n2 & 0x100) != 0) {
                        n5 &= 0xFFFFFFBF;
                    }
                    if ((n2 & 0x20) != 0) {
                        n5 &= 0xFFFFFFF7;
                    }
                    if ((n2 & 4) != 0) {
                        n5 &= 0xFFFFFFFE;
                    }
                }
                ISVNCLibrary iSVNCLibrary3 = iSVNCLibrary;
                synchronized (iSVNCLibrary3) {
                    n3 = iSVNCLibrary.chmod(string, n5);
                }
                return n3 >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return false;
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Calling JNA.setWritable");
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n2 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._lstat(string, ourSharedMemory) : (SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.__lxstat(3, string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? iSVNCLibrary.lstat(string, ourSharedMemory) : iSVNCLibrary.__lxstat64(0, string, ourSharedMemory)));
                }
                if (n2 < 0) {
                    return false;
                }
                int n3 = ourSharedMemory.getInt(SVNLinuxUtil.getFileModeOffset());
                int n4 = n3 & 0x1FF;
                int n5 = 0;
                if ((n4 & 0x100) != 0) {
                    n5 |= 0x80;
                }
                if ((n4 & 0x20) != 0) {
                    n5 |= 0x10;
                }
                if ((n4 & 4) != 0) {
                    n5 |= 2;
                }
                if (n5 == 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary3 = iSVNCLibrary;
                synchronized (iSVNCLibrary3) {
                    n2 = iSVNCLibrary.chmod(string, n5 | n4);
                }
                return n2 >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setSGID(File file) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int n2;
                int n3;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
                synchronized (iSVNCLibrary2) {
                    n3 = ourIsDashStat && SVNFileUtil.isBSD ? iSVNCLibrary._stat(string, ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris || SVNFileUtil.isLinux && SVNFileUtil.is32Bit ? iSVNCLibrary.stat(string, ourSharedMemory) : iSVNCLibrary.__xstat64(0, string, ourSharedMemory));
                }
                if (n3 < 0) {
                    return false;
                }
                int n4 = ourSharedMemory.getInt(SVNLinuxUtil.getFileModeOffset());
                int n5 = n4 & 0xFFF;
                if ((n5 & (n2 = 1024)) != 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary3 = iSVNCLibrary;
                synchronized (iSVNCLibrary3) {
                    n3 = iSVNCLibrary.chmod(string, n2 | n5);
                }
                return n3 >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSymlink(File file, String string) {
        if (file == null || string == null || ourSharedMemory == null) {
            return false;
        }
        String string2 = file.getAbsolutePath();
        if (string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            int n2;
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return false;
            }
            ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
            synchronized (iSVNCLibrary2) {
                n2 = iSVNCLibrary.symlink(string, string2);
            }
            return n2 >= 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int flock(File file, boolean bl2) {
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return -1;
            }
            ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
            synchronized (iSVNCLibrary2) {
                int n2 = SVNLinuxUtil.getFileCreationConstant();
                int n3 = SVNLinuxUtil.getReadWriteConstant();
                int n4 = iSVNCLibrary.open(file.getAbsolutePath(), n3 | n2, 420);
                if (n4 < 0) {
                    return -1;
                }
                int n5 = iSVNCLibrary.flock(n4, bl2 ? 2 : 1);
                if (n5 != 0) {
                    iSVNCLibrary.close(n4);
                    return -1;
                }
                return n4;
            }
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unflock(int n2) {
        try {
            ISVNCLibrary iSVNCLibrary = JNALibraryLoader.getCLibrary();
            if (iSVNCLibrary == null) {
                return false;
            }
            ISVNCLibrary iSVNCLibrary2 = iSVNCLibrary;
            synchronized (iSVNCLibrary2) {
                int n3 = iSVNCLibrary.flock(n2, 8);
                if (n3 != 0) {
                    return false;
                }
                iSVNCLibrary.close(n2);
                return true;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static int getFileModeOffset() {
        if (SVNFileUtil.isLinux) {
            return SVNFileUtil.isAMD64 ? 24 : 16;
        }
        if (SVNFileUtil.isOSX) {
            if (SVNFileUtil.isAarchh64) {
                return 4;
            }
            return 8;
        }
        if (SVNFileUtil.isSolaris && SVNFileUtil.is64Bit) {
            return 16;
        }
        if (SVNFileUtil.isSolaris && SVNFileUtil.is32Bit) {
            return 20;
        }
        if (SVNFileUtil.isBSD) {
            return SVNFileUtil.isIno64 ? 24 : 8;
        }
        return 16;
    }

    private static int getFileUserIDOffset() {
        int n2 = SVNLinuxUtil.getFileModeOffset();
        if (SVNFileUtil.isLinux) {
            return n2 + (SVNFileUtil.isAMD64 ? 4 : 8);
        }
        if (SVNFileUtil.isOSX) {
            if (SVNFileUtil.isAarchh64) {
                return n2 + 12;
            }
            return n2 + 4;
        }
        if (SVNFileUtil.isSolaris) {
            return n2 + 8;
        }
        if (SVNFileUtil.isBSD) {
            return n2 + 4;
        }
        return n2 + 8;
    }

    private static int getFileGroupIDOffset() {
        return SVNLinuxUtil.getFileUserIDOffset() + 4;
    }

    private static int getFileLastModifiedOffset() {
        if (SVNFileUtil.isLinux && SVNFileUtil.is64Bit) {
            return 88;
        }
        if (SVNFileUtil.isLinux && SVNFileUtil.is32Bit) {
            return 64;
        }
        if (SVNFileUtil.isBSD && !SVNFileUtil.isIno64) {
            return 32;
        }
        if (SVNFileUtil.isBSD && SVNFileUtil.isIno64) {
            return 48;
        }
        if (SVNFileUtil.isSolaris) {
            return 64;
        }
        if (SVNFileUtil.isOSX) {
            if (SVNFileUtil.isAarchh64) {
                return 48;
            }
            return 40;
        }
        return 88;
    }

    private static int getFileLastModifiedOffsetNanos() {
        return SVNFileUtil.is32Bit ? SVNLinuxUtil.getFileLastModifiedOffset() + 4 : SVNLinuxUtil.getFileLastModifiedOffset() + 8;
    }

    private static int getReadWriteConstant() {
        return 2;
    }

    private static int getFileCreationConstant() {
        return SVNFileUtil.isOSX ? 512 : 64;
    }

    static {
        ourIsDashStat = Boolean.getBoolean("svnkit.jna.dash_stat");
        try {
            ourSharedMemory = new Memory(1024L);
        }
        catch (Throwable throwable) {
            ourSharedMemory = null;
        }
    }
}

