/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring;
import org.tmatesoft.svn.core.internal.util.jna.SVNLinuxUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNMacOsKeychain;
import org.tmatesoft.svn.core.internal.util.jna.SVNWin32Util;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinCrypt;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNJNAUtil {
    private static boolean ourIsJNAEnabled;
    private static boolean ourIsJNAPresent;
    private static final String JNA_CLASS_NAME = "com.sun.jna.Library";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJNAEnabled(boolean bl2) {
        Class<SVNJNAUtil> clazz = SVNJNAUtil.class;
        synchronized (SVNJNAUtil.class) {
            ourIsJNAEnabled = bl2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJNAPresent() {
        Class<SVNJNAUtil> clazz = SVNJNAUtil.class;
        synchronized (SVNJNAUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourIsJNAPresent && ourIsJNAEnabled;
        }
    }

    public static SVNFileType getFileType(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getFileType(file);
        }
        return null;
    }

    public static Boolean isExecutable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.isExecutable(file);
        }
        return null;
    }

    public static String getLinkTarget(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getLinkTarget(file);
        }
        return null;
    }

    public static boolean setExecutable(File file, boolean bl2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.setExecutable(file, bl2);
        }
        return false;
    }

    public static boolean setSGID(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.setSGID(file);
        }
        return false;
    }

    public static boolean createSymlink(File file, String string) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.createSymlink(file, string);
        }
        return false;
    }

    public static Long getSymlinkLastModified(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getSymlinkLastModified(file);
        }
        return null;
    }

    public static Long getLastModifiedMicros(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getLastModifiedMicros(file);
        }
        return null;
    }

    public static boolean setWritable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNFileUtil.isWindows ? SVNWin32Util.setWritable(file) : SVNLinuxUtil.setWritable(file);
        }
        return false;
    }

    public static boolean setHidden(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.setHidden(file);
        }
        return false;
    }

    public static boolean moveFile(File file, File file2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.moveFile(file, file2);
        }
        return false;
    }

    public static int flock(File file, boolean bl2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.flock(file, bl2);
        }
        return -1;
    }

    public static boolean unflock(int n2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.unflock(n2);
        }
        return false;
    }

    public static char[] decrypt(char[] cArray) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.decrypt(cArray);
        }
        return null;
    }

    public static char[] encrypt(char[] cArray) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.encrypt(cArray);
        }
        return null;
    }

    public static boolean addPasswordToMacOsKeychain(String string, String string2, char[] cArray, boolean bl2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNMacOsKeychain.setPassword(string, string2, cArray, bl2);
        }
        return false;
    }

    public static char[] getPasswordFromMacOsKeychain(String string, String string2, boolean bl2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNMacOsKeychain.getPassword(string, string2, bl2);
        }
        return null;
    }

    public static boolean addPasswordToGnomeKeyring(String string, String string2, char[] cArray, boolean bl2, ISVNGnomeKeyringPasswordProvider iSVNGnomeKeyringPasswordProvider) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNGnomeKeyring.setPassword(string, string2, cArray, bl2, iSVNGnomeKeyringPasswordProvider);
        }
        return false;
    }

    public static char[] getPasswordFromGnomeKeyring(String string, String string2, boolean bl2, ISVNGnomeKeyringPasswordProvider iSVNGnomeKeyringPasswordProvider) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNGnomeKeyring.getPassword(string, string2, bl2, iSVNGnomeKeyringPasswordProvider);
        }
        return null;
    }

    public static synchronized boolean isWinCryptEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNWinCrypt.isEnabled();
    }

    public static synchronized boolean isMacOsKeychainEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNMacOsKeychain.isEnabled();
    }

    public static synchronized boolean isGnomeKeyringEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNGnomeKeyring.isEnabled();
    }

    public static String getApplicationDataPath(boolean bl2) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.getApplicationDataPath(bl2);
        }
        return null;
    }

    static {
        Object object;
        try {
            object = SVNJNAUtil.class.getClassLoader();
            if (object == null) {
                object = ClassLoader.getSystemClassLoader();
            }
            if (object != null && ((ClassLoader)object).loadClass(JNA_CLASS_NAME) != null) {
                ourIsJNAPresent = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ourIsJNAPresent = false;
        }
        object = System.getProperty("svnkit.useJNA", "true");
        ourIsJNAEnabled = Boolean.valueOf((String)object);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "JNA present/enabled: " + ourIsJNAPresent + "/" + ourIsJNAEnabled);
    }
}

