/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Memory;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGLibrary$GList;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGnomeKeyringLibrary;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGnomeKeyringLibrary$GnomeKeyringOperationDoneCallback;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGnomeKeyringLibrary$GnomeKeyringOperationGetKeyringInfoCallback;
import org.tmatesoft.svn.core.internal.util.jna.ISVNGnomeKeyringLibrary$GnomeKeyringOperationGetStringCallback;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring$1;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring$2;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring$3;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring$GnomeKeyringContext;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGnomeKeyring {
    private static final Object keyringAccessMonitor = new Object();
    private static final ISVNGnomeKeyringLibrary$GnomeKeyringOperationDoneCallback DONE_CALLBACK = new SVNGnomeKeyring$1();
    private static final ISVNGnomeKeyringLibrary$GnomeKeyringOperationGetKeyringInfoCallback GET_KEYRING_INFO_CALLBACK = new SVNGnomeKeyring$2();
    private static final ISVNGnomeKeyringLibrary$GnomeKeyringOperationGetStringCallback DEFAULT_KEYRING_CALLBACK = new SVNGnomeKeyring$3();

    public static boolean isEnabled() {
        boolean bl2 = SVNFileUtil.isOSX || SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isSolaris;
        String string = System.getProperty("svnkit.library.gnome-keyring.enabled", "true");
        boolean bl3 = Boolean.TRUE.toString().equalsIgnoreCase(string);
        boolean bl4 = JNALibraryLoader.getGnomeKeyringLibrary() != null && JNALibraryLoader.getGLibrary() != null;
        boolean bl5 = bl2 && bl3 && bl4;
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, bl5 ? "Gnome Keyring enabled" : "Gnome Keyring disabled");
        return bl5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        ISVNGLibrary iSVNGLibrary = JNALibraryLoader.getGLibrary();
        if (iSVNGLibrary == null) {
            return;
        }
        Object object = keyringAccessMonitor;
        synchronized (object) {
            String string = iSVNGLibrary.g_get_application_name();
            if (string == null) {
                iSVNGLibrary.g_set_application_name("Subversion");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultKeyringName() {
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        ISVNGLibrary iSVNGLibrary = JNALibraryLoader.getGLibrary();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            SVNGnomeKeyring$GnomeKeyringContext sVNGnomeKeyring$GnomeKeyringContext = new SVNGnomeKeyring$GnomeKeyringContext();
            sVNGnomeKeyring$GnomeKeyringContext.keyringInfo = null;
            sVNGnomeKeyring$GnomeKeyringContext.keyringName = null;
            sVNGnomeKeyring$GnomeKeyringContext.loop = iSVNGLibrary.g_main_loop_new(null, false);
            sVNGnomeKeyring$GnomeKeyringContext.write();
            iSVNGnomeKeyringLibrary.gnome_keyring_get_default_keyring(DEFAULT_KEYRING_CALLBACK, sVNGnomeKeyring$GnomeKeyringContext.getPointer(), null);
            iSVNGLibrary.g_main_loop_run(sVNGnomeKeyring$GnomeKeyringContext.loop);
            sVNGnomeKeyring$GnomeKeyringContext.read();
            if (sVNGnomeKeyring$GnomeKeyringContext.keyringName == null) {
                SVNGnomeKeyring.destroyKeyringContext(sVNGnomeKeyring$GnomeKeyringContext);
                return null;
            }
            String string = sVNGnomeKeyring$GnomeKeyringContext.keyringName;
            SVNGnomeKeyring.destroyKeyringContext(sVNGnomeKeyring$GnomeKeyringContext);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkKeyringIsLocked(String string) {
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        ISVNGLibrary iSVNGLibrary = JNALibraryLoader.getGLibrary();
        SVNGnomeKeyring$GnomeKeyringContext sVNGnomeKeyring$GnomeKeyringContext = new SVNGnomeKeyring$GnomeKeyringContext();
        sVNGnomeKeyring$GnomeKeyringContext.keyringName = null;
        sVNGnomeKeyring$GnomeKeyringContext.keyringName = null;
        sVNGnomeKeyring$GnomeKeyringContext.loop = iSVNGLibrary.g_main_loop_new(null, false);
        sVNGnomeKeyring$GnomeKeyringContext.write();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            iSVNGnomeKeyringLibrary.gnome_keyring_get_info(string, GET_KEYRING_INFO_CALLBACK, sVNGnomeKeyring$GnomeKeyringContext.getPointer(), null);
            iSVNGLibrary.g_main_loop_run(sVNGnomeKeyring$GnomeKeyringContext.loop);
            sVNGnomeKeyring$GnomeKeyringContext.read();
            if (sVNGnomeKeyring$GnomeKeyringContext.keyringInfo == null) {
                SVNGnomeKeyring.destroyKeyringContext(sVNGnomeKeyring$GnomeKeyringContext);
                return false;
            }
            return iSVNGnomeKeyringLibrary.gnome_keyring_info_get_is_locked(sVNGnomeKeyring$GnomeKeyringContext.keyringInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlockKeyring(String string, char[] cArray) {
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        ISVNGLibrary iSVNGLibrary = JNALibraryLoader.getGLibrary();
        SVNGnomeKeyring$GnomeKeyringContext sVNGnomeKeyring$GnomeKeyringContext = new SVNGnomeKeyring$GnomeKeyringContext();
        sVNGnomeKeyring$GnomeKeyringContext.keyringInfo = null;
        sVNGnomeKeyring$GnomeKeyringContext.keyringName = null;
        sVNGnomeKeyring$GnomeKeyringContext.loop = iSVNGLibrary.g_main_loop_new(null, false);
        sVNGnomeKeyring$GnomeKeyringContext.write();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            iSVNGnomeKeyringLibrary.gnome_keyring_get_info(string, GET_KEYRING_INFO_CALLBACK, sVNGnomeKeyring$GnomeKeyringContext.getPointer(), null);
            iSVNGLibrary.g_main_loop_run(sVNGnomeKeyring$GnomeKeyringContext.loop);
            sVNGnomeKeyring$GnomeKeyringContext.read();
            if (sVNGnomeKeyring$GnomeKeyringContext.keyringInfo == null) {
                SVNGnomeKeyring.destroyKeyringContext(sVNGnomeKeyring$GnomeKeyringContext);
                return;
            }
            sVNGnomeKeyring$GnomeKeyringContext.loop = iSVNGLibrary.g_main_loop_new(null, false);
            sVNGnomeKeyring$GnomeKeyringContext.write();
            byte[] byArray = SVNEncodingUtil.getBytes(cArray, "UTF-8");
            Memory memory = null;
            try {
                memory = new Memory(byArray.length + 1);
                memory.write(0L, byArray, 0, byArray.length);
                memory.setByte(byArray.length, (byte)0);
                iSVNGnomeKeyringLibrary.gnome_keyring_unlock(string, memory, DONE_CALLBACK, sVNGnomeKeyring$GnomeKeyringContext.getPointer(), null);
                iSVNGLibrary.g_main_loop_run(sVNGnomeKeyring$GnomeKeyringContext.loop);
                sVNGnomeKeyring$GnomeKeyringContext.read();
            }
            finally {
                if (memory != null) {
                    memory.clear();
                }
                SVNEncodingUtil.clearArray(byArray);
            }
            SVNGnomeKeyring.destroyKeyringContext(sVNGnomeKeyring$GnomeKeyringContext);
        }
    }

    public static char[] getPassword(String string, String string2, boolean bl2, ISVNGnomeKeyringPasswordProvider iSVNGnomeKeyringPasswordProvider) {
        Object object;
        String string3 = SVNGnomeKeyring.getDefaultKeyringName();
        if (!bl2 && SVNGnomeKeyring.checkKeyringIsLocked(string3) && iSVNGnomeKeyringPasswordProvider != null) {
            object = iSVNGnomeKeyringPasswordProvider.getKeyringPassword(string3);
            SVNGnomeKeyring.unlockKeyring(string3, (char[])object);
        }
        if (SVNGnomeKeyring.checkKeyringIsLocked(string3)) {
            object = SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "GNOME Keyring is locked and we are non-interactive");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.CLIENT);
            return null;
        }
        return SVNGnomeKeyring.getPassword(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] getPassword(String string, String string2) {
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            Object object2;
            if (!iSVNGnomeKeyringLibrary.gnome_keyring_is_available()) {
                return null;
            }
            SVNGnomeKeyring.getDefaultKeyringName();
            PointerByReference pointerByReference = new PointerByReference();
            int n2 = iSVNGnomeKeyringLibrary.gnome_keyring_find_network_password_sync(string2, string, null, null, null, null, 0, pointerByReference);
            byte[] byArray = null;
            if (n2 == 0) {
                object2 = new ISVNGLibrary$GList(pointerByReference.getValue());
                ((Structure)object2).read();
                if (((ISVNGLibrary$GList)object2).data != null) {
                    ISVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData = new ISVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData(((ISVNGLibrary$GList)object2).data);
                    iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData.read();
                    if (iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData.password != null) {
                        int n3;
                        for (n3 = 0; iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData.password.getByte(n3) != 0 && n3 < iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData.size(); ++n3) {
                        }
                        byArray = iSVNGnomeKeyringLibrary$GnomeKeyringNetworkPasswordData.password.getByteArray(0L, n3);
                    }
                    iSVNGnomeKeyringLibrary.gnome_keyring_network_password_list_free((ISVNGLibrary$GList)object2);
                }
            }
            try {
                object2 = SVNEncodingUtil.getChars(byArray, "UTF-8");
            }
            catch (Throwable throwable) {
                SVNEncodingUtil.clearArray(byArray);
                throw throwable;
            }
            SVNEncodingUtil.clearArray(byArray);
            return object2;
        }
    }

    public static boolean setPassword(String string, String string2, char[] cArray, boolean bl2, ISVNGnomeKeyringPasswordProvider iSVNGnomeKeyringPasswordProvider) {
        Object object;
        String string3 = SVNGnomeKeyring.getDefaultKeyringName();
        if (!bl2 && SVNGnomeKeyring.checkKeyringIsLocked(string3) && iSVNGnomeKeyringPasswordProvider != null) {
            object = iSVNGnomeKeyringPasswordProvider.getKeyringPassword(string3);
            SVNGnomeKeyring.unlockKeyring(string3, (char[])object);
        }
        if (SVNGnomeKeyring.checkKeyringIsLocked(string3)) {
            object = SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "GNOME Keyring is locked and we are non-interactive");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.CLIENT);
            return false;
        }
        return SVNGnomeKeyring.setPassword(string, string2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setPassword(String string, String string2, char[] cArray) {
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            int n2;
            if (!iSVNGnomeKeyringLibrary.gnome_keyring_is_available()) {
                return false;
            }
            SVNGnomeKeyring.getDefaultKeyringName();
            IntByReference intByReference = new IntByReference();
            byte[] byArray = SVNEncodingUtil.getBytes(cArray, "UTF-8");
            Memory memory = null;
            try {
                memory = new Memory(byArray.length + 1);
                memory.write(0L, byArray, 0, byArray.length);
                memory.setByte(byArray.length, (byte)0);
                n2 = iSVNGnomeKeyringLibrary.gnome_keyring_set_network_password_sync(null, string2, string, null, null, null, null, 0, memory, intByReference);
            }
            finally {
                if (memory != null) {
                    memory.clear();
                }
                SVNEncodingUtil.clearArray(byArray);
            }
            return n2 == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyKeyringContext(SVNGnomeKeyring$GnomeKeyringContext sVNGnomeKeyring$GnomeKeyringContext) {
        if (sVNGnomeKeyring$GnomeKeyringContext == null) {
            return;
        }
        ISVNGnomeKeyringLibrary iSVNGnomeKeyringLibrary = JNALibraryLoader.getGnomeKeyringLibrary();
        Object object = keyringAccessMonitor;
        synchronized (object) {
            sVNGnomeKeyring$GnomeKeyringContext.keyringName = null;
            sVNGnomeKeyring$GnomeKeyringContext.write();
            if (sVNGnomeKeyring$GnomeKeyringContext.keyringInfo != null) {
                iSVNGnomeKeyringLibrary.gnome_keyring_info_free(sVNGnomeKeyring$GnomeKeyringContext.keyringInfo);
                sVNGnomeKeyring$GnomeKeyringContext.keyringInfo = null;
            }
        }
    }

    static /* synthetic */ Object access$000() {
        return keyringAccessMonitor;
    }
}

