/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNXMLUtil {
    public static final Map PREFIX_MAP = new SVNHashMap();
    public static final String DAV_NAMESPACE_PREFIX = "D";
    public static final String SVN_NAMESPACE_PREFIX = "S";
    public static final String SVN_DAV_PROPERTY_PREFIX = "SD";
    public static final String SVN_CUSTOM_PROPERTY_PREFIX = "SC";
    public static final String SVN_SVN_PROPERTY_PREFIX = "SS";
    public static final String SVN_APACHE_PROPERTY_PREFIX = "SA";
    private static final String FULL_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String DEFAULT_XML_HEADER = "<?xml version=\"1.0\"?>\n";
    public static final int XML_STYLE_NORMAL = 1;
    public static final int XML_STYLE_PROTECT_CDATA = 2;
    public static final int XML_STYLE_SELF_CLOSING = 4;
    public static final int XML_STYLE_ATTRIBUTE_BREAKS_LINE = 8;

    public static StringBuffer addXMLHeader(StringBuffer stringBuffer, boolean bl2) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer.append(bl2 ? FULL_XML_HEADER : DEFAULT_XML_HEADER);
        return stringBuffer;
    }

    public static StringBuffer addXMLHeader(StringBuffer stringBuffer) {
        return SVNXMLUtil.addXMLHeader(stringBuffer, true);
    }

    public static StringBuffer openNamespaceDeclarationTag(String string, String string2, Collection collection, Map map, Map map2, StringBuffer stringBuffer, boolean bl2) {
        String string3;
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer.append("<");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(string2);
        if (collection != null && !collection.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (Object object : collection) {
                string3 = null;
                if (object instanceof DAVElement) {
                    DAVElement dAVElement = (DAVElement)object;
                    string3 = dAVElement.getNamespace();
                } else if (object instanceof String) {
                    string3 = (String)object;
                }
                if (string3 == null || string3.length() <= 0 || arrayList.contains(string3)) continue;
                arrayList.add(string3);
                stringBuffer.append(" xmlns");
                if (map != null) {
                    stringBuffer.append(":");
                    stringBuffer.append(map.get(string3));
                }
                stringBuffer.append("=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\"");
            }
            arrayList.clear();
        }
        if (map2 != null && !map2.isEmpty()) {
            for (Map.Entry entry : map2.entrySet()) {
                Object object;
                object = (String)entry.getKey();
                string3 = (String)entry.getValue();
                stringBuffer.append(" ");
                stringBuffer.append((String)object);
                stringBuffer.append("=\"");
                stringBuffer.append(SVNEncodingUtil.xmlEncodeAttr(string3));
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        if (bl2) {
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    public static StringBuffer openNamespaceDeclarationTag(String string, String string2, Collection collection, Map map, StringBuffer stringBuffer) {
        return SVNXMLUtil.openNamespaceDeclarationTag(string, string2, collection, map, null, stringBuffer, true);
    }

    public static StringBuffer addXMLFooter(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer.append("</");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(string2);
        stringBuffer.append(">");
        return stringBuffer;
    }

    public static StringBuffer openCDataTag(String string, String string2, String string3, StringBuffer stringBuffer) {
        return SVNXMLUtil.openCDataTag(string, string2, string3, null, stringBuffer);
    }

    public static StringBuffer openCDataTag(String string, String string2, StringBuffer stringBuffer) {
        return SVNXMLUtil.openCDataTag(null, string, string2, stringBuffer);
    }

    public static StringBuffer openCDataTag(String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put(string4, string5);
        return SVNXMLUtil.openCDataTag(string, string2, string3, sVNHashMap, stringBuffer);
    }

    public static StringBuffer openCDataTag(String string, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put(string4, string5);
        return SVNXMLUtil.openCDataTag(string, string2, string3, sVNHashMap, bl2, bl3, stringBuffer);
    }

    public static StringBuffer openCDataTag(String string, String string2, String string3, Map map, StringBuffer stringBuffer) {
        return SVNXMLUtil.openCDataTag(string, string2, string3, map, false, true, stringBuffer);
    }

    public static StringBuffer openCDataTag(String string, String string2, String string3, Map map, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        if (string3 == null) {
            return stringBuffer;
        }
        stringBuffer = SVNXMLUtil.openXMLTag(string, string2, 2, map, stringBuffer);
        if (bl3) {
            stringBuffer.append(SVNEncodingUtil.xmlEncodeCDATA(string3, bl2));
        } else {
            stringBuffer.append(string3);
        }
        stringBuffer = SVNXMLUtil.closeXMLTag(string, string2, stringBuffer);
        return stringBuffer;
    }

    public static StringBuffer openXMLTag(String string, String string2, int n2, String string3, String string4, StringBuffer stringBuffer) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put(string3, string4);
        return SVNXMLUtil.openXMLTag(string, string2, n2, sVNHashMap, stringBuffer);
    }

    public static StringBuffer openXMLTag(String string, String string2, int n2, Map map, StringBuffer stringBuffer) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer.append("<");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(string2);
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if ((n2 & 8) != 0) {
                    stringBuffer.append("\n  ");
                }
                stringBuffer.append(" ");
                stringBuffer.append(string3);
                stringBuffer.append("=\"");
                stringBuffer.append(SVNEncodingUtil.xmlEncodeAttr(string4));
                stringBuffer.append("\"");
            }
            map.clear();
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        if ((n2 & 2) == 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public static StringBuffer closeXMLTag(String string, String string2, StringBuffer stringBuffer) {
        return SVNXMLUtil.closeXMLTag(string, string2, stringBuffer, true);
    }

    public static StringBuffer closeXMLTag(String string, String string2, StringBuffer stringBuffer, boolean bl2) {
        stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer.append("</");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(string2);
        stringBuffer.append(">");
        if (bl2) {
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    static {
        PREFIX_MAP.put("DAV:", DAV_NAMESPACE_PREFIX);
        PREFIX_MAP.put("svn:", SVN_NAMESPACE_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/dav/", SVN_DAV_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/svn/", SVN_SVN_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://subversion.tigris.org/xmlns/custom/", SVN_CUSTOM_PROPERTY_PREFIX);
        PREFIX_MAP.put("http://apache.org/dav/xmlns", SVN_APACHE_PROPERTY_PREFIX);
    }
}

