/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

public class SVNVersion
implements Comparable {
    private final int major;
    private final int minor;
    private final int micro;
    private final String build;

    public static SVNVersion parse(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n2;
            int n3;
            int n4;
            String[] stringArray = string.split("\\.", 3);
            String[] stringArray2 = stringArray[stringArray.length - 1].split("-", 2);
            if (stringArray.length == 1) {
                n4 = Integer.parseInt(stringArray2[0]);
                n3 = -1;
                n2 = -1;
            } else if (stringArray.length == 2) {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray2[0]);
                n2 = -1;
            } else if (stringArray.length == 3) {
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray2[0]);
            } else {
                return null;
            }
            return new SVNVersion(n4, n3, n2, stringArray2.length >= 2 ? stringArray2[1] : null);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public SVNVersion(int n2, int n3, int n4, String string) {
        this.major = n2;
        this.minor = n3;
        this.micro = n4;
        this.build = string;
    }

    public SVNVersion removeBuild() {
        return new SVNVersion(this.major, this.minor, this.micro, null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        if (this.minor >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.minor);
        }
        if (this.micro >= 0) {
            stringBuilder.append(".");
            stringBuilder.append(this.micro);
        }
        if (this.build != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.build);
        }
        return stringBuilder.toString();
    }

    public int compareNumericParts(SVNVersion sVNVersion) {
        if (sVNVersion == null) {
            return 1;
        }
        if (sVNVersion == this) {
            return 0;
        }
        int n2 = this.major - sVNVersion.major;
        if (n2 != 0) {
            return n2;
        }
        n2 = this.minor - sVNVersion.minor;
        if (n2 != 0) {
            return n2;
        }
        return this.micro - sVNVersion.micro;
    }

    public int compareTo(SVNVersion sVNVersion) {
        int n2 = this.compareNumericParts(sVNVersion);
        if (n2 != 0) {
            return n2;
        }
        if (this.build == null) {
            return sVNVersion.build == null ? 0 : -1;
        }
        if (sVNVersion.build == null) {
            return 1;
        }
        return this.build.compareTo(sVNVersion.build);
    }
}

