/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SVNURLUtil {
    public static String getRelativeURL(SVNURL sVNURL, SVNURL sVNURL2, boolean bl2) {
        String string = bl2 ? sVNURL.toString() : sVNURL.toDecodedString();
        String string2 = bl2 ? sVNURL2.toString() : sVNURL2.toDecodedString();
        String string3 = SVNPathUtil.getPathAsChild(string, string2);
        return string3 == null ? "" : string3;
    }

    public static boolean isAncestor(SVNURL sVNURL, SVNURL sVNURL2) {
        if (sVNURL == null || sVNURL2 == null) {
            return false;
        }
        String string = sVNURL.toString();
        String string2 = sVNURL2.toString();
        if (string.length() > string2.length()) {
            return false;
        }
        if (string2.startsWith(string)) {
            if (string.length() == string2.length()) {
                return true;
            }
            return string2.charAt(string.length()) == '/';
        }
        return false;
    }

    public static SVNURL getCommonURLAncestor(SVNURL sVNURL, SVNURL sVNURL2) {
        if (sVNURL == null || sVNURL2 == null) {
            return null;
        }
        if (!sVNURL.getProtocol().equals(sVNURL2.getProtocol()) || !sVNURL.getHost().equals(sVNURL2.getHost()) || sVNURL.getPort() != sVNURL2.getPort()) {
            return null;
        }
        if (sVNURL.getUserInfo() != null ? !sVNURL.getUserInfo().equals(sVNURL2.getUserInfo()) : sVNURL2.getUserInfo() != null) {
            return null;
        }
        String string = sVNURL.getPath();
        String string2 = sVNURL2.getPath();
        String string3 = SVNPathUtil.getCommonPathAncestor(string, string2);
        try {
            return sVNURL.setPath(string3, false);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public static SVNURL condenceURLs(SVNURL[] sVNURLArray, Collection collection, boolean bl2) {
        SVNURL sVNURL;
        int n2;
        if (sVNURLArray == null || sVNURLArray.length == 0) {
            return null;
        }
        if (sVNURLArray.length == 1) {
            return sVNURLArray[0];
        }
        SVNURL sVNURL2 = sVNURLArray[0];
        for (n2 = 0; n2 < sVNURLArray.length; ++n2) {
            sVNURL2 = SVNURLUtil.getCommonURLAncestor(sVNURL2, sVNURLArray[n2]);
        }
        if (collection != null && bl2) {
            for (n2 = 0; n2 < sVNURLArray.length; ++n2) {
                sVNURL = sVNURLArray[n2];
                if (sVNURL == null) continue;
                for (int i2 = 0; i2 < sVNURLArray.length; ++i2) {
                    SVNURL sVNURL3;
                    SVNURL sVNURL4;
                    if (n2 == i2 || (sVNURL4 = sVNURLArray[i2]) == null || (sVNURL3 = SVNURLUtil.getCommonURLAncestor(sVNURL, sVNURL4)) == null) continue;
                    if (sVNURL3.equals(sVNURL)) {
                        sVNURLArray[i2] = null;
                        continue;
                    }
                    if (!sVNURL3.equals(sVNURL4)) continue;
                    sVNURLArray[n2] = null;
                }
            }
            for (n2 = 0; n2 < sVNURLArray.length; ++n2) {
                sVNURL = sVNURLArray[n2];
                if (sVNURL == null || !sVNURL.equals(sVNURL2)) continue;
                sVNURLArray[n2] = null;
            }
        }
        if (collection != null) {
            for (n2 = 0; n2 < sVNURLArray.length; ++n2) {
                sVNURL = sVNURLArray[n2];
                if (sVNURL == null) continue;
                String string = sVNURL.toString();
                if (sVNURL2 != null && (string = string.substring(sVNURL2.toString().length())).startsWith("/")) {
                    string = string.substring(1);
                }
                collection.add(string);
            }
        }
        return sVNURL2;
    }
}

