/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tmatesoft.svn.core.internal.util.ISVNTask;
import org.tmatesoft.svn.core.internal.util.ISVNThreadPool;
import org.tmatesoft.svn.core.internal.util.SVNEmptyThreadPool;
import org.tmatesoft.svn.core.internal.util.SVNTask;
import org.tmatesoft.svn.core.internal.util.SVNThreadPool$CustomThreadFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNThreadPool
implements ISVNThreadPool {
    private ThreadPoolExecutor myThreadPool;
    private SVNThreadPool$CustomThreadFactory myThreadFactory;
    private ISVNThreadPool myFailSafePool;

    @Override
    public ISVNTask run(Runnable runnable, boolean bl2) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPool(bl2);
        try {
            Future<?> future = threadPoolExecutor.submit(runnable);
            return new SVNTask(future);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Could not submit task: " + rejectedExecutionException.getMessage());
            ISVNThreadPool iSVNThreadPool = this.getFailSafePool();
            return iSVNThreadPool.run(runnable, bl2);
        }
    }

    private synchronized ISVNThreadPool getFailSafePool() {
        if (this.myFailSafePool == null) {
            this.myFailSafePool = new SVNEmptyThreadPool();
        }
        return this.myFailSafePool;
    }

    private synchronized ThreadPoolExecutor getThreadPool(boolean bl2) {
        SVNThreadPool$CustomThreadFactory sVNThreadPool$CustomThreadFactory = this.getThreadFactory(bl2);
        if (this.myThreadPool == null) {
            this.myThreadPool = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), sVNThreadPool$CustomThreadFactory);
        }
        return this.myThreadPool;
    }

    private synchronized SVNThreadPool$CustomThreadFactory getThreadFactory(boolean bl2) {
        if (this.myThreadFactory == null) {
            this.myThreadFactory = new SVNThreadPool$CustomThreadFactory(bl2);
        } else {
            this.myThreadFactory.setIsDaemon(bl2);
        }
        return this.myThreadFactory;
    }
}

