/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.Closeable;
import java.io.IOException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer$MemoryBlock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSpillBufferReader
implements Closeable {
    private final SVNSpillBuffer buffer;
    private byte[] saveBuffer;
    private int savePointer;
    private int savePosition;
    private int saveLength;
    private byte[] sbBuffer;
    private int sbPointer;
    private int sbLength;

    public SVNSpillBufferReader(SVNSpillBuffer sVNSpillBuffer) {
        this.buffer = sVNSpillBuffer;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            if (this.saveLength > 0) {
                n5 = n3 < this.saveLength ? n3 : this.saveLength;
                System.arraycopy(this.saveBuffer, this.savePointer + this.savePosition, byArray, n2, n5);
                this.savePointer += n5;
                this.saveLength -= n5;
            } else {
                if (this.sbLength == 0) {
                    SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = this.buffer.read();
                    if (sVNSpillBuffer$MemoryBlock == null) {
                        this.sbBuffer = null;
                        this.sbPointer = 0;
                        this.sbLength = 0;
                        this.sbLength = 0;
                        return n4 == 0 ? -1 : n4;
                    }
                    this.sbBuffer = sVNSpillBuffer$MemoryBlock.data;
                    this.sbPointer = 0;
                    this.sbLength = sVNSpillBuffer$MemoryBlock.length;
                }
                n5 = n3 < this.sbLength ? n3 : this.sbLength;
                System.arraycopy(this.sbBuffer, this.sbPointer, byArray, n2, n5);
                this.sbPointer += n5;
                this.sbLength -= n5;
            }
            n2 += n5;
            n3 -= n5;
            n4 += n5;
        }
        return n4 == 0 ? -1 : n4;
    }

    public char readChar() {
        byte[] byArray = new byte[1];
        try {
            int n2 = this.read(byArray, 0, 1);
            if (n2 < 0) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            }
            return (char)byArray[0];
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            return '\uffff';
        }
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (this.sbLength > 0) {
            if (this.saveBuffer == null) {
                this.saveBuffer = new byte[this.buffer.getBlockSize()];
                this.savePointer = 0;
            }
            System.arraycopy(this.sbBuffer, this.sbPointer, this.saveBuffer, this.savePointer, this.sbLength);
            this.saveLength = this.sbLength;
            this.savePosition = 0;
            this.sbLength = 0;
        }
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

