/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNSpillBuffer$MemoryBlock;
import org.tmatesoft.svn.core.internal.util.SVNSpillBufferInputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSpillBuffer
implements Closeable {
    private final int blockSize;
    private final long maxSize;
    private final boolean deleteOnClose;
    private final boolean spillAllContents;
    private final File dirPath;
    private long memorySize;
    private long spillSize;
    private File fileName;
    private RandomAccessFile spill;
    private SVNSpillBuffer$MemoryBlock head;
    private SVNSpillBuffer$MemoryBlock tail;
    private SVNSpillBuffer$MemoryBlock outForReading;
    private SVNSpillBuffer$MemoryBlock available;
    private long spillStart;

    public SVNSpillBuffer(int n2, long l2) {
        this(n2, l2, true, false, null);
    }

    public SVNSpillBuffer(int n2, long l2, boolean bl2, boolean bl3, File file) {
        this.blockSize = n2;
        this.maxSize = l2;
        this.deleteOnClose = bl2;
        this.spillAllContents = bl3;
        this.dirPath = file;
    }

    public long getSize() {
        return this.memorySize + this.spillSize;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public File getFileName() {
        return this.fileName;
    }

    public RandomAccessFile getSpill() {
        return this.spill;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public SVNSpillBufferInputStream createInputStream() {
        return new SVNSpillBufferInputStream(this);
    }

    public void write(byte[] byArray, int n2, int n3) {
        try {
            SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = null;
            if (this.spill == null && this.memorySize + (long)n3 > this.maxSize) {
                File file = this.dirPath;
                if (file == null) {
                    file = SVNFileUtil.createFilePath(System.getProperty("java.io.tmpdir"));
                }
                this.fileName = SVNFileUtil.createUniqueFile(file, "svn", ".tmp", false);
                this.spill = SVNFileUtil.openRAFileForWriting(this.fileName, false);
                assert (this.spill != null);
                if (this.spillAllContents) {
                    sVNSpillBuffer$MemoryBlock = this.head;
                    while (sVNSpillBuffer$MemoryBlock != null) {
                        this.spill.write(sVNSpillBuffer$MemoryBlock.data, 0, sVNSpillBuffer$MemoryBlock.length);
                        sVNSpillBuffer$MemoryBlock = sVNSpillBuffer$MemoryBlock.next;
                    }
                    this.spillStart = this.memorySize;
                }
            }
            if (this.spill != null) {
                this.spill.seek(this.spill.length());
                this.spill.write(byArray, n2, n3);
                this.spillSize += (long)n3;
                return;
            }
            while (n3 > 0) {
                if (this.tail == null || this.tail.length == this.blockSize) {
                    sVNSpillBuffer$MemoryBlock = this.getBuffer();
                    sVNSpillBuffer$MemoryBlock.length = 0;
                    sVNSpillBuffer$MemoryBlock.next = null;
                } else {
                    sVNSpillBuffer$MemoryBlock = this.tail;
                }
                int n4 = this.blockSize - sVNSpillBuffer$MemoryBlock.length;
                if (n4 > n3) {
                    n4 = n3;
                }
                System.arraycopy(byArray, n2, sVNSpillBuffer$MemoryBlock.data, sVNSpillBuffer$MemoryBlock.length, n4);
                sVNSpillBuffer$MemoryBlock.length += n4;
                n2 += n4;
                n3 -= n4;
                this.memorySize += (long)n4;
                if (this.tail == null) {
                    this.head = sVNSpillBuffer$MemoryBlock;
                    this.tail = sVNSpillBuffer$MemoryBlock;
                    continue;
                }
                if (sVNSpillBuffer$MemoryBlock == this.tail) continue;
                this.tail.next = sVNSpillBuffer$MemoryBlock;
                this.tail = sVNSpillBuffer$MemoryBlock;
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    @Override
    public void close() {
        SVNFileUtil.closeFile(this.spill);
        this.spill = null;
        if (this.deleteOnClose) {
            try {
                if (this.fileName != null) {
                    SVNFileUtil.deleteFile(this.fileName);
                    this.fileName = null;
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
    }

    public SVNSpillBuffer$MemoryBlock read() {
        this.maybeSeek();
        SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = this.readData();
        if (sVNSpillBuffer$MemoryBlock == null) {
            return null;
        }
        if (this.outForReading != null) {
            this.returnBuffer(this.outForReading);
        }
        this.outForReading = sVNSpillBuffer$MemoryBlock;
        return sVNSpillBuffer$MemoryBlock;
    }

    private boolean maybeSeek() {
        if (this.head == null && this.spill != null) {
            this.spill.seek(this.spillStart);
            return true;
        }
        return false;
    }

    private SVNSpillBuffer$MemoryBlock readData() {
        if (this.head != null) {
            SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = this.head;
            if (this.tail == sVNSpillBuffer$MemoryBlock) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = sVNSpillBuffer$MemoryBlock.next;
            }
            this.memorySize -= (long)sVNSpillBuffer$MemoryBlock.length;
            return sVNSpillBuffer$MemoryBlock;
        }
        if (this.spill == null) {
            SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = null;
            return sVNSpillBuffer$MemoryBlock;
        }
        SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = this.getBuffer();
        sVNSpillBuffer$MemoryBlock.length = this.spillSize < (long)this.blockSize ? (int)this.spillSize : this.blockSize;
        sVNSpillBuffer$MemoryBlock.next = null;
        try {
            this.spill.read(sVNSpillBuffer$MemoryBlock.data, 0, sVNSpillBuffer$MemoryBlock.length);
        }
        catch (IOException iOException) {
            this.returnBuffer(sVNSpillBuffer$MemoryBlock);
            throw iOException;
        }
        this.spillStart += (long)sVNSpillBuffer$MemoryBlock.length;
        if ((this.spillSize -= (long)sVNSpillBuffer$MemoryBlock.length) == 0L) {
            this.close();
            this.spillStart = 0L;
        }
        return sVNSpillBuffer$MemoryBlock;
    }

    private SVNSpillBuffer$MemoryBlock getBuffer() {
        SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock = this.outForReading;
        if (sVNSpillBuffer$MemoryBlock != null) {
            this.outForReading = null;
            return sVNSpillBuffer$MemoryBlock;
        }
        if (this.available == null) {
            sVNSpillBuffer$MemoryBlock = new SVNSpillBuffer$MemoryBlock(new byte[this.blockSize], this.blockSize);
            return sVNSpillBuffer$MemoryBlock;
        }
        sVNSpillBuffer$MemoryBlock = this.available;
        this.available = sVNSpillBuffer$MemoryBlock.next;
        return sVNSpillBuffer$MemoryBlock;
    }

    private void returnBuffer(SVNSpillBuffer$MemoryBlock sVNSpillBuffer$MemoryBlock) {
        sVNSpillBuffer$MemoryBlock.next = this.available;
        this.available = sVNSpillBuffer$MemoryBlock;
    }
}

