/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.ISVNTask;
import org.tmatesoft.svn.core.internal.util.ISVNThreadPool;
import org.tmatesoft.svn.core.internal.util.SVNSocketConnection;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory$1;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory$SocketConfigurator;
import org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSocketFactory {
    private static final String EMPTY_JAVA7_TRUST_MANAGER_CLASSNAME = "org.tmatesoft.svn.core.internal.util.Java7EmptyTrustManager";
    private static boolean ourIsSocketStaleCheck = false;
    private static int ourSocketReceiveBufferSize = 0;
    private static ISVNThreadPool ourThreadPool = SVNClassLoader.getThreadPool();
    private static String ourSSLProtocols = System.getProperty("svnkit.http.sslProtocols");
    private static volatile SVNSocketFactory$SocketConfigurator configurator;
    private static X509TrustManager EMPTY_TRUST_MANAGER;
    private static KeyManager[] EMPTY_KEY_MANAGERS;

    public static Socket createPlainSocket(String string, int n2, int n3, int n4, ISVNCanceller iSVNCanceller) {
        InetAddress inetAddress = SVNSocketFactory.createAddress(string);
        Socket socket = new Socket();
        int n5 = SVNSocketFactory.getSocketReceiveBufferSize();
        if (n5 > 0) {
            socket.setReceiveBufferSize(n5);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setSoLinger(true, 0);
        socket.setSoTimeout(n4);
        SVNSocketFactory.configureSocket(socket);
        SVNSocketFactory.connect(socket, inetSocketAddress, n3, iSVNCanceller);
        return socket;
    }

    private static void configureSocket(Socket socket) {
        SVNSocketFactory$SocketConfigurator sVNSocketFactory$SocketConfigurator = configurator;
        if (sVNSocketFactory$SocketConfigurator != null) {
            try {
                sVNSocketFactory$SocketConfigurator.configureSocket(socket);
            }
            catch (Throwable throwable) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, throwable);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, throwable), throwable);
            }
        }
    }

    public static void setConfigurator(SVNSocketFactory$SocketConfigurator sVNSocketFactory$SocketConfigurator) {
        configurator = sVNSocketFactory$SocketConfigurator;
    }

    public static SVNSocketFactory$SocketConfigurator getConfigurator() {
        return configurator;
    }

    public static synchronized void setSSLProtocols(String string) {
        ourSSLProtocols = string;
    }

    public static synchronized String getSSLProtocols() {
        return ourSSLProtocols;
    }

    public static Socket createSSLSocket(KeyManager[] keyManagerArray, TrustManager trustManager, String string, int n2, int n3, int n4, ISVNCanceller iSVNCanceller) {
        try {
            SSLSocket sSLSocket = (SSLSocket)SVNSocketFactory._createSSLSocket(keyManagerArray, trustManager, string, n2, n3, n4, iSVNCanceller, true);
            sSLSocket.startHandshake();
            return sSLSocket;
        }
        catch (SSLProtocolException sSLProtocolException) {
            if (sSLProtocolException.getMessage() != null && sSLProtocolException.getMessage().contains("handshake alert:  unrecognized_name")) {
                return SVNSocketFactory._createSSLSocket(keyManagerArray, trustManager, string, n2, n3, n4, iSVNCanceller, false);
            }
            throw sSLProtocolException;
        }
    }

    private static Socket _createSSLSocket(KeyManager[] keyManagerArray, TrustManager trustManager, String string, int n2, int n3, int n4, ISVNCanceller iSVNCanceller, boolean bl2) {
        InetAddress inetAddress = SVNSocketFactory.createAddress(string);
        Socket socket = SVNSocketFactory.createSSLContext(keyManagerArray, trustManager).getSocketFactory().createSocket();
        int n5 = SVNSocketFactory.getSocketReceiveBufferSize();
        if (n5 > 0) {
            socket.setReceiveBufferSize(n5);
        }
        if (bl2 && socket instanceof SSLSocket && SVNFileUtil.getJavaVersion() < 8) {
            socket = SVNSocketFactory.setSSLSocketHost(socket, string);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setSoLinger(true, 0);
        socket.setSoTimeout(n4);
        socket = SVNSocketFactory.configureSSLSocket(socket);
        SVNSocketFactory.connect(socket, inetSocketAddress, n3, iSVNCanceller);
        return socket;
    }

    public static Socket createSSLSocket(KeyManager[] keyManagerArray, TrustManager trustManager, String string, int n2, Socket socket, int n3) {
        Socket socket2 = SVNSocketFactory.createSSLContext(keyManagerArray, trustManager).getSocketFactory().createSocket(socket, string, n2, true);
        socket2 = SVNSocketFactory.setSSLSocketHost(socket2, string);
        socket2.setReuseAddress(true);
        socket2.setTcpNoDelay(true);
        socket2.setKeepAlive(true);
        socket2.setSoLinger(true, 0);
        socket2.setSoTimeout(n3);
        socket2 = SVNSocketFactory.configureSSLSocket(socket2);
        return socket2;
    }

    private static Socket setSSLSocketHost(Socket socket, String string) {
        try {
            Method method = socket.getClass().getMethod("setHost", String.class);
            if (method != null) {
                method.invoke((Object)socket, string);
                SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "Host set on an SSL socket");
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return socket;
    }

    public static ISVNThreadPool getThreadPool() {
        return ourThreadPool;
    }

    public static void connect(Socket socket, InetSocketAddress inetSocketAddress, int n2, ISVNCanceller iSVNCanceller) {
        if (iSVNCanceller == null || iSVNCanceller == ISVNCanceller.NULL) {
            socket.connect(inetSocketAddress, n2);
            return;
        }
        SVNSocketConnection sVNSocketConnection = new SVNSocketConnection(socket, inetSocketAddress, n2);
        ISVNTask iSVNTask = ourThreadPool.run(sVNSocketConnection, true);
        while (!sVNSocketConnection.isSocketConnected()) {
            try {
                iSVNCanceller.checkCancelled();
            }
            catch (SVNCancelException sVNCancelException) {
                iSVNTask.cancel(true);
                throw sVNCancelException;
            }
        }
        if (sVNSocketConnection.getError() != null) {
            throw sVNSocketConnection.getError();
        }
    }

    private static InetAddress createAddress(String string) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                byte by = (byte)Integer.parseInt(string2);
                if (n2 < byArray.length) {
                    byArray[n2] = by;
                    ++n2;
                    continue;
                }
                byArray = null;
            }
            catch (NumberFormatException numberFormatException) {
                byArray = null;
            }
            break;
        }
        if (byArray != null && n2 == 4) {
            return InetAddress.getByAddress(string, byArray);
        }
        return InetAddress.getByName(string);
    }

    public static synchronized void setSocketReceiveBufferSize(int n2) {
        ourSocketReceiveBufferSize = n2;
    }

    public static synchronized int getSocketReceiveBufferSize() {
        return ourSocketReceiveBufferSize;
    }

    public static void setSocketStaleCheckEnabled(boolean bl2) {
        ourIsSocketStaleCheck = bl2;
    }

    public static boolean isSocketStaleCheckEnabled() {
        return ourIsSocketStaleCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSocketStale(Socket socket) {
        boolean bl2;
        block11: {
            if (!SVNSocketFactory.isSocketStaleCheckEnabled()) {
                return socket == null || socket.isClosed() || !socket.isConnected();
            }
            bl2 = true;
            if (socket != null) {
                bl2 = false;
                try {
                    if (socket.getInputStream().available() != 0) break block11;
                    int n2 = socket.getSoTimeout();
                    try {
                        socket.setSoTimeout(1);
                        socket.getInputStream().mark(1);
                        int n3 = socket.getInputStream().read();
                        if (n3 == -1) {
                            bl2 = true;
                        } else {
                            socket.getInputStream().reset();
                        }
                    }
                    finally {
                        socket.setSoTimeout(n2);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!SocketTimeoutException.class.isInstance(interruptedIOException)) {
                        throw interruptedIOException;
                    }
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private static X509TrustManager getEmptyTrustManager() {
        block8: {
            String string = System.getProperty("java.runtime.version", "1.6.0");
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                try {
                    int n2 = Integer.parseInt(stringArray[1]);
                    if (n2 < 7) break block8;
                    try {
                        Class<?> clazz = SVNSocketFactory.class.getClassLoader().loadClass(EMPTY_JAVA7_TRUST_MANAGER_CLASSNAME);
                        Object obj = clazz.newInstance();
                        if (obj instanceof X509TrustManager) {
                            return (X509TrustManager)obj;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return EMPTY_TRUST_MANAGER;
    }

    public static SSLContext createSSLContext(KeyManager[] keyManagerArray, TrustManager trustManager) {
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager != null ? trustManager : SVNSocketFactory.getEmptyTrustManager()};
        keyManagerArray = keyManagerArray != null ? keyManagerArray : EMPTY_KEY_MANAGERS;
        try {
            return SVNSocketFactory.createSSLContext(keyManagerArray, trustManagerArray, SVNSocketFactory.getEnabledSSLProtocols(true));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                return SVNSocketFactory.createSSLContext(keyManagerArray, trustManagerArray, SVNSocketFactory.getEnabledSSLProtocols(false));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new IOException(noSuchAlgorithmException2.getMessage());
            }
        }
    }

    private static SSLContext createSSLContext(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, List list) {
        SSLContext sSLContext = null;
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (String string : list) {
            try {
                sSLContext = SSLContext.getInstance(string);
                if (sSLContext == null) continue;
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                return sSLContext;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
            catch (KeyManagementException keyManagementException) {
                throw new IOException(keyManagementException.getMessage());
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getEnabledSSLProtocols(boolean bl2) {
        Object object = SVNSocketFactory.class;
        synchronized (SVNSocketFactory.class) {
            String string = ourSSLProtocols;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = new ArrayList();
            if (bl2 && string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if ("".equals(string2)) continue;
                    object.add(string2);
                }
            }
            if (object.isEmpty()) {
                object.add("TLS");
                object.add("SSLv3");
            }
            return object;
        }
    }

    public static Socket configureSSLSocket(Socket socket) {
        if (socket == null || !(socket instanceof SSLSocket)) {
            return null;
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        List list = SVNSocketFactory.getEnabledSSLProtocols(true);
        List<String> list2 = Arrays.asList(sSLSocket.getEnabledProtocols());
        List<String> list3 = Arrays.asList(sSLSocket.getSupportedProtocols());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (String string2 : list3) {
                if (!string2.startsWith(string)) continue;
                arrayList.add(string2);
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(list2);
        }
        sSLSocket.setEnabledProtocols(arrayList.toArray(new String[arrayList.size()]));
        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSL protocols explicitly enabled: " + arrayList);
        SVNSocketFactory.configureSocket(sSLSocket);
        return sSLSocket;
    }

    static {
        EMPTY_TRUST_MANAGER = new SVNSocketFactory$1();
        EMPTY_KEY_MANAGERS = new KeyManager[0];
    }
}

