/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$InheritedProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSkel {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final char TYPE_NOTHING = '\u0000';
    public static final char TYPE_SPACE = '\u0001';
    public static final char TYPE_DIGIT = '\u0002';
    public static final char TYPE_PAREN = '\u0003';
    public static final char TYPE_NAME = '\u0004';
    private static final char[] TYPES_TABLE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0003', '\u0000', '\u0003', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private final byte[] myRawData;
    private final List myList;
    private SVNSkel myNext;

    public static char getType(byte by) {
        return TYPES_TABLE[by & 0xFF];
    }

    public static SVNSkel parse(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SVNSkel.parse(byArray, 0, byArray.length);
    }

    public static SVNSkel parse(byte[] byArray, int n2, int n3) {
        if (byArray == null || n3 == 0 || n2 + n3 > byArray.length) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        return SVNSkel.parse(byteBuffer);
    }

    public static SVNSkel parse(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        byte by = byteBuffer.get(byteBuffer.position());
        if (by == 40) {
            return SVNSkel.parseList(byteBuffer);
        }
        if (SVNSkel.getType(by) == '\u0004') {
            return SVNSkel.parseImplicitAtom(byteBuffer);
        }
        return SVNSkel.parseExplicitAtom(byteBuffer);
    }

    public static SVNSkel parseList(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        if (byteBuffer.get() != 40) {
            return null;
        }
        if (!byteBuffer.hasRemaining()) {
            return null;
        }
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        while (true) {
            byte by = 0;
            while (byteBuffer.hasRemaining() && SVNSkel.getType(by = byteBuffer.get()) == '\u0001') {
            }
            if (by == 41) break;
            if (!byteBuffer.hasRemaining()) {
                return null;
            }
            SVNSkel sVNSkel2 = SVNSkel.parse(byteBuffer = SVNSkel.unread(byteBuffer, 1));
            if (sVNSkel2 == null) {
                return null;
            }
            sVNSkel.appendChild(sVNSkel2);
        }
        return sVNSkel;
    }

    public static SVNSkel parseImplicitAtom(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        if (SVNSkel.getType(byteBuffer.get(byteBuffer.position())) != '\u0004') {
            return null;
        }
        int n2 = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (SVNSkel.getType(by) != '\u0001' && SVNSkel.getType(by) != '\u0003') continue;
            byteBuffer = SVNSkel.unread(byteBuffer, 1);
            break;
        }
        return SVNSkel.createAtom(byteBuffer.array(), byteBuffer.arrayOffset() + n2, byteBuffer.position() - n2);
    }

    public static SVNSkel parseExplicitAtom(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        int n2 = SVNSkel.parseSize(byteBuffer, byteBuffer.remaining());
        if (n2 < 0) {
            return null;
        }
        if (!byteBuffer.hasRemaining() || SVNSkel.getType(byteBuffer.get()) != '\u0001') {
            return null;
        }
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        byteBuffer.position(byteBuffer.position() + n2);
        return SVNSkel.createAtom(byteBuffer.array(), n3, n2);
    }

    private static SVNSkel createAtom(SVNPropertyValue sVNPropertyValue) {
        if (sVNPropertyValue != null && sVNPropertyValue.getString() != null) {
            return SVNSkel.createAtom(sVNPropertyValue.getString());
        }
        if (sVNPropertyValue != null && sVNPropertyValue.getBytes() != null) {
            return SVNSkel.createAtom(sVNPropertyValue.getBytes());
        }
        return SVNSkel.createAtom("");
    }

    public static SVNSkel createAtom(String string) {
        byte[] byArray;
        if (string == null) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return new SVNSkel(byArray);
    }

    public static SVNSkel createAtom(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SVNSkel.createAtom(byArray, 0, byArray.length);
    }

    public static SVNSkel createAtom(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new SVNSkel(byArray2);
    }

    public static SVNSkel createEmptyList() {
        return new SVNSkel();
    }

    public static SVNSkel createPropList(Map map) {
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        if (map == null) {
            return sVNSkel;
        }
        for (String string : map.keySet()) {
            SVNSkel sVNSkel2 = SVNSkel.createAtom(string);
            SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(string);
            SVNSkel sVNSkel3 = SVNSkel.createAtom(sVNPropertyValue);
            sVNSkel.prepend(sVNSkel3);
            sVNSkel.prepend(sVNSkel2);
        }
        if (!sVNSkel.isValidPropList()) {
            SVNSkel.error("proplist");
        }
        return sVNSkel;
    }

    protected SVNSkel(byte[] byArray) {
        this.myRawData = byArray;
        this.myList = null;
        this.myNext = null;
    }

    protected SVNSkel() {
        this.myRawData = null;
        this.myList = new ArrayList();
    }

    public boolean isAtom() {
        return this.myList == null;
    }

    public byte[] getData() {
        return this.myRawData;
    }

    public List getList() {
        return Collections.unmodifiableList(this.myList);
    }

    public SVNSkel first() {
        if (this.myList != null && !this.myList.isEmpty()) {
            return (SVNSkel)this.myList.get(0);
        }
        return null;
    }

    public SVNSkel next() {
        return this.myNext;
    }

    public SVNSkel getChild(int n2) {
        if (this.isAtom()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to get a child from atom");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return (SVNSkel)this.myList.get(n2);
    }

    public void appendChild(SVNSkel sVNSkel) {
        if (this.isAtom()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to add a child to atom");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (!this.myList.isEmpty()) {
            ((SVNSkel)this.myList.get((int)(this.myList.size() - 1))).myNext = sVNSkel;
        }
        this.myList.add(sVNSkel);
    }

    public void prepend(SVNSkel sVNSkel) {
        if (this.isAtom()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to add a child to atom");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (!this.myList.isEmpty()) {
            sVNSkel.myNext = (SVNSkel)this.myList.get(0);
        }
        this.myList.add(0, sVNSkel);
    }

    public void prependString(String string) {
        SVNSkel sVNSkel = SVNSkel.createAtom(string);
        this.prepend(sVNSkel);
    }

    public void prependPropertyValue(SVNPropertyValue sVNPropertyValue) {
        SVNSkel sVNSkel = SVNSkel.createAtom(sVNPropertyValue);
        this.prepend(sVNSkel);
    }

    public void prependPath(File file) {
        String string = file != null ? SVNFileUtil.getFilePath(file) : "";
        this.prependString(string);
    }

    public int getListSize() {
        if (this.isAtom()) {
            return -1;
        }
        return this.myList.size();
    }

    public String getValue() {
        if (this.isAtom()) {
            String string;
            try {
                string = new String(this.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(this.getData());
            }
            return string;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAtom()) {
            stringBuffer.append("[");
            stringBuffer.append(this.getValue());
            stringBuffer.append("]");
        } else {
            stringBuffer.append("(");
            for (SVNSkel sVNSkel : this.myList) {
                stringBuffer.append(sVNSkel.toString());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean contentEquals(String string) {
        if (!this.isAtom()) {
            return false;
        }
        String string2 = this.getValue();
        return string2.equals(string);
    }

    public boolean containsAtomsOnly() {
        if (this.isAtom()) {
            return false;
        }
        for (SVNSkel sVNSkel : this.myList) {
            if (sVNSkel.isAtom()) continue;
            return false;
        }
        return true;
    }

    public boolean isValidPropList() {
        int n2 = this.getListSize();
        if (n2 >= 0 && (n2 & 1) == 0) {
            return this.containsAtomsOnly();
        }
        return false;
    }

    public Map parsePropList() {
        if (!this.isValidPropList()) {
            SVNSkel.error("proplist");
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        Iterator iterator = this.myList.iterator();
        while (iterator.hasNext()) {
            SVNSkel sVNSkel = (SVNSkel)iterator.next();
            SVNSkel sVNSkel2 = (SVNSkel)iterator.next();
            String string = sVNSkel.getValue();
            byte[] byArray = sVNSkel2.isAtom() ? sVNSkel2.getData() : null;
            sVNHashMap.put(string, byArray);
        }
        return sVNHashMap;
    }

    public boolean isValidInheritedProperties() {
        int n2 = this.getListSize();
        if (n2 >= 0 && (n2 & 1) == 0) {
            for (SVNSkel sVNSkel = this.first(); sVNSkel != null; sVNSkel = sVNSkel.next()) {
                if (!sVNSkel.isAtom()) {
                    return false;
                }
                if (sVNSkel.next() == null) {
                    return false;
                }
                if ((sVNSkel = sVNSkel.next()).isValidPropList()) continue;
                return false;
            }
        }
        return true;
    }

    public static SVNSkel createInheritedProperties(Map map) {
        SVNSkel sVNSkel = SVNSkel.createEmptyList();
        for (String string : map.keySet()) {
            SVNSkel sVNSkel2 = SVNSkel.createAtom(string);
            SVNSkel sVNSkel3 = SVNSkel.createPropList(((SVNProperties)map.get(string)).asMap());
            sVNSkel.appendChild(sVNSkel2);
            sVNSkel.appendChild(sVNSkel3);
        }
        return sVNSkel;
    }

    public List parseInheritedProperties() {
        if (!this.isValidInheritedProperties()) {
            SVNSkel.error("iprops");
        }
        ArrayList<Structure> arrayList = new ArrayList<Structure>();
        for (SVNSkel sVNSkel = this.first(); sVNSkel != null; sVNSkel = sVNSkel.next()) {
            String string = sVNSkel.getValue();
            sVNSkel = sVNSkel.next();
            SVNProperties sVNProperties = SVNProperties.wrap(sVNSkel.parsePropList());
            Structure structure = Structure.obtain(StructureFields$InheritedProperties.class);
            structure.set((Enum)StructureFields$InheritedProperties.pathOrURL, string);
            structure.set((Enum)StructureFields$InheritedProperties.properties, sVNProperties);
            arrayList.add(structure);
        }
        return arrayList;
    }

    public byte[] unparse() {
        int n2 = this.estimateUnparsedSize();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer = this.writeTo(byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.arrayOffset()];
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray, 0, byteBuffer.limit());
        return byArray;
    }

    public ByteBuffer writeTo(ByteBuffer byteBuffer) {
        if (this.isAtom()) {
            byte[] byArray = this.getData();
            if (this.useImplicit()) {
                byteBuffer = SVNSkel.allocate(byteBuffer, byArray.length);
                byteBuffer = byteBuffer.put(byArray);
            } else {
                byte[] byArray2 = SVNSkel.getSizeBytes(byArray.length);
                if (byArray2 == null) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Unable to write size bytes to buffer");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
                }
                byteBuffer = SVNSkel.allocate(byteBuffer, byArray2.length + 1 + byArray.length);
                byteBuffer.put(byArray2);
                try {
                    byteBuffer.put(" ".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byteBuffer.put(" ".getBytes());
                }
                byteBuffer.put(byArray);
            }
        } else {
            byteBuffer = SVNSkel.allocate(byteBuffer, 1);
            try {
                byteBuffer.put("(".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byteBuffer.put("(".getBytes());
            }
            Iterator iterator = this.myList.iterator();
            while (iterator.hasNext()) {
                SVNSkel sVNSkel = (SVNSkel)iterator.next();
                byteBuffer = sVNSkel.writeTo(byteBuffer);
                if (!iterator.hasNext()) continue;
                byteBuffer = SVNSkel.allocate(byteBuffer, 1);
                try {
                    byteBuffer.put(" ".getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byteBuffer.put(" ".getBytes());
                }
            }
            byteBuffer = SVNSkel.allocate(byteBuffer, 1);
            try {
                byteBuffer.put(")".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byteBuffer.put(")".getBytes());
            }
        }
        return byteBuffer;
    }

    private int estimateUnparsedSize() {
        if (this.isAtom()) {
            byte[] byArray = this.getData();
            if (byArray.length < 100) {
                return byArray.length + 3;
            }
            return byArray.length + 30;
        }
        int n2 = 2;
        for (SVNSkel sVNSkel : this.myList) {
            n2 += sVNSkel.estimateUnparsedSize();
            ++n2;
        }
        return n2;
    }

    private boolean useImplicit() {
        byte[] byArray = this.getData();
        if (byArray.length == 0 || byArray.length >= 100) {
            return false;
        }
        if (SVNSkel.getType(byArray[0]) != '\u0004') {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            if (SVNSkel.getType(by) != '\u0001' && SVNSkel.getType(by) != '\u0003') continue;
            return false;
        }
        return true;
    }

    private static ByteBuffer allocate(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            n2 = Math.max(n2 * 3 / 2, 1024);
            return ByteBuffer.allocate(n2);
        }
        if (n2 > byteBuffer.remaining()) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((byteBuffer.position() + n2) * 3 / 2);
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    private static ByteBuffer unread(ByteBuffer byteBuffer, int n2) {
        byteBuffer.position(byteBuffer.position() - n2);
        return byteBuffer;
    }

    private static int parseSize(ByteBuffer byteBuffer, int n2) {
        n2 = n2 < 0 ? Integer.MAX_VALUE : n2;
        int n3 = n2 / 10;
        int n4 = n2 % 10;
        int n5 = 0;
        int n6 = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (48 <= by && by <= 57) {
                int n7 = by - 48;
                if (n5 > n3 || n5 == n3 && n7 > n4) {
                    return -1;
                }
                n5 = n5 * 10 + n7;
                continue;
            }
            byteBuffer = SVNSkel.unread(byteBuffer, 1);
            break;
        }
        if (n6 == byteBuffer.position()) {
            return -1;
        }
        return n5;
    }

    private static int writeSizeBytes(int n2, byte[] byArray) {
        int n3 = 0;
        do {
            if (n3 >= byArray.length) {
                return -1;
            }
            byArray[n3] = (byte)(n2 % 10 + 48);
            ++n3;
        } while ((n2 /= 10) > 0);
        int n4 = 0;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            byte by = byArray[n4];
            byArray[n4] = byArray[i2];
            byArray[i2] = by;
        }
        return n3;
    }

    private static byte[] getSizeBytes(int n2) {
        int n3 = n2;
        int n4 = 0;
        do {
            ++n4;
        } while ((n3 /= 10) > 0);
        byte[] byArray = new byte[n4];
        int n5 = SVNSkel.writeSizeBytes(n2, byArray);
        if (n5 < 0) {
            return null;
        }
        if (n5 < byArray.length) {
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n5);
            return byArray2;
        }
        return byArray;
    }

    private static void error(String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "Malformed{0}{1} skeleton", string == null ? "" : " ", string == null ? "" : string);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
    }

    public void removeChildren(Collection collection) {
        for (SVNSkel sVNSkel : collection) {
            this.myList.remove(sVNSkel);
        }
        for (int i2 = 0; i2 < this.myList.size(); ++i2) {
            SVNSkel sVNSkel;
            sVNSkel = (SVNSkel)this.myList.get(i2);
            sVNSkel.myNext = i2 < this.myList.size() - 1 ? (SVNSkel)this.myList.get(i2 + 1) : null;
        }
    }

    public void removeAllChildren() {
        this.myList.clear();
    }
}

