/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.security.MessageDigest;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.tmatesoft.svn.core.internal.util.SVNCertificateFailureKind;

public class SVNSSLUtil {
    public static StringBuffer getServerCertificatePrompt(X509Certificate x509Certificate, String string, String string2) {
        return SVNSSLUtil.getServerCertificatePrompt(x509Certificate, string, string2, EnumSet.noneOf(SVNCertificateFailureKind.class));
    }

    public static StringBuffer getServerCertificatePrompt(X509Certificate x509Certificate, String string, String string2, EnumSet enumSet) {
        int n2 = SVNSSLUtil.getServerCertificateFailures(x509Certificate, string2);
        int n3 = SVNCertificateFailureKind.createMask(enumSet);
        n2 &= ~n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error validating server certificate for '");
        stringBuffer.append(string);
        stringBuffer.append("':\n");
        if ((n2 & SVNCertificateFailureKind.UNKNOWN_CA.getCode()) != 0) {
            stringBuffer.append(" - The certificate is not issued by a trusted authority. Use the\n   fingerprint to validate the certificate manually!\n");
        }
        if ((n2 & SVNCertificateFailureKind.CN_MISMATCH.getCode()) != 0) {
            stringBuffer.append(" - The certificate hostname does not match.\n");
        }
        if ((n2 & SVNCertificateFailureKind.EXPIRED.getCode()) != 0) {
            stringBuffer.append(" - The certificate has expired.\n");
        }
        if ((n2 & SVNCertificateFailureKind.NOT_YET_VALID.getCode()) != 0) {
            stringBuffer.append(" - The certificate is not yet valid.\n");
        }
        SVNSSLUtil.getServerCertificateInfo(x509Certificate, stringBuffer);
        return stringBuffer;
    }

    private static String getFingerprint(X509Certificate x509Certificate) {
        try {
            return SVNSSLUtil.getFingerprint(x509Certificate.getEncoded(), "SHA1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFingerprint(byte[] byArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string != null ? string : "SHA1");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                int n2;
                String string2;
                if (i2 != 0) {
                    stringBuffer.append(':');
                }
                if ((string2 = Integer.toHexString(n2 = byArray2[i2] & 0xFF)).length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static void getServerCertificateInfo(X509Certificate x509Certificate, StringBuffer stringBuffer) {
        stringBuffer.append("Certificate information:");
        stringBuffer.append('\n');
        stringBuffer.append(" - Subject: ");
        stringBuffer.append(x509Certificate.getSubjectDN().getName());
        stringBuffer.append('\n');
        stringBuffer.append(" - Valid: ");
        stringBuffer.append("from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
        stringBuffer.append('\n');
        stringBuffer.append(" - Issuer: ");
        stringBuffer.append(x509Certificate.getIssuerDN().getName());
        stringBuffer.append('\n');
        stringBuffer.append(" - Fingerprint: ");
        stringBuffer.append(SVNSSLUtil.getFingerprint(x509Certificate));
    }

    public static int getServerCertificateFailures(X509Certificate x509Certificate, String string) {
        String string2;
        int n2;
        int n3 = 8;
        Date date = new Date(System.currentTimeMillis());
        if (date.before(x509Certificate.getNotBefore())) {
            n3 |= 1;
        }
        if (date.after(x509Certificate.getNotAfter())) {
            n3 |= 2;
        }
        if ((n2 = (string2 = x509Certificate.getSubjectDN().getName()).indexOf("CN=")) >= 0) {
            if ((string2 = string2.substring(n2 += 3)).indexOf(32) >= 0) {
                string2 = string2.substring(0, string2.indexOf(32));
            }
            if (string2.indexOf(44) >= 0) {
                string2 = string2.substring(0, string2.indexOf(44));
            }
        }
        if (!string.equals(string2)) {
            try {
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection != null) {
                    for (List<?> list : collection) {
                        if (!(list instanceof Collection) || ((Collection)list).size() < 2) continue;
                        Object[] objectArray = ((Collection)list).toArray();
                        Object object = objectArray[0];
                        Object object2 = objectArray[1];
                        if (!(object instanceof Integer) || !(object2 instanceof String) || (Integer)object != 2 || !object2.equals(string)) continue;
                        return n3;
                    }
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            n3 |= 4;
        }
        return n3;
    }
}

