/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil$1;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPathUtil {
    public static final Comparator PATH_COMPARATOR = new SVNPathUtil$1();

    public static boolean isCanonical(String string) {
        return string != null && string.equals(SVNPathUtil.canonicalizePath(string));
    }

    public static void checkPathIsValid(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!SVNEncodingUtil.isASCIIControlChar(c2)) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character ''{0}'' in path ''{1}''", "0x" + SVNFormatUtil.getHexNumberFromByte((byte)c2), string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public static String getAbsolutePath(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || "/".equals(string)) {
            return "/";
        }
        if (SVNPathUtil.isURL(string)) {
            return string;
        }
        string = string.endsWith("/") ? string.substring(0, string.length() - "/".length()) : string;
        return string.startsWith("/") ? string : "/" + string;
    }

    public static String validateFilePath(String string) {
        String string2;
        string = string.replace(File.separatorChar, '/');
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object = new StringTokenizer(string, "/", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if ("..".equals(string2)) {
                if (!linkedList.isEmpty()) {
                    linkedList.remove(linkedList.size() - 1);
                    continue;
                }
                File file = new File(System.getProperty("user.dir"));
                while (file.getParentFile() != null) {
                    linkedList.add(0, file.getParentFile().getName());
                    file = file.getParentFile();
                }
                continue;
            }
            if (".".equals(string2) || string2.length() == 0) continue;
            linkedList.add(string2);
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            stringBuffer.append("/");
        }
        if (string.length() > 1 && string.charAt(1) == '/') {
            stringBuffer.append("/");
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            stringBuffer.append(string2);
            if (!object.hasNext()) continue;
            stringBuffer.append('/');
        }
        if (stringBuffer.length() == 2 && stringBuffer.charAt(stringBuffer.length() - 1) == ':') {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    public static String canonicalizePath(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        boolean bl2 = SVNPathUtil.isURL(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < string.length() && string.charAt(n2) != '/' && string.charAt(n2) != ':'; ++n2) {
        }
        String string2 = null;
        int n3 = 0;
        if (n2 > 0 && n2 + 2 < string.length() && string.charAt(n2) == ':' && string.charAt(n2 + 1) == '/' && string.charAt(n2 + 2) == '/') {
            string2 = string.substring(0, n2 + 3);
            stringBuffer.append(string2);
            n3 = n2 + 3;
        }
        if (n3 < string.length() && string.charAt(n3) == '/') {
            stringBuffer.append('/');
            if (SVNFileUtil.isWindows && string2 == null && ++n3 < string.length() && string.charAt(n3) == '/') {
                stringBuffer.append('/');
                ++n3;
            }
        }
        int n4 = 0;
        while (n3 < string.length()) {
            int n5;
            int n6;
            for (n6 = n3; !(n6 >= string.length() || string.charAt(n6) == '/' || bl2 && n6 + 2 < string.length() && string.charAt(n6) == '%' && string.charAt(n6 + 1) == '2' && Character.toUpperCase(string.charAt(n6 + 2)) == 'F'); ++n6) {
            }
            int n7 = 0;
            if (n6 < string.length()) {
                if (string.charAt(n6) == '/') {
                    n7 = 1;
                } else if (string.charAt(n6) == '%') {
                    n7 = 3;
                }
            }
            if (!((n5 = n6 - n3) == 0 || n5 == 1 && string.charAt(n3) == '.' || bl2 && n5 == 3 && string.charAt(n3) == '%' && string.charAt(n3 + 1) == '2' && Character.toUpperCase(string.charAt(n3 + 2)) == 'E')) {
                stringBuffer.append(string.substring(n3, n3 + n5));
                if (n7 > 0) {
                    stringBuffer.append('/');
                }
                ++n4;
            }
            if ((n3 = n6) >= string.length()) continue;
            n3 += n7;
        }
        if ((n4 > 0 || string2 != null) && stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer = stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        if (SVNFileUtil.isWindows && n4 < 2 && stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '/' && stringBuffer.charAt(1) == '/') {
            stringBuffer = stringBuffer.delete(0, 1);
        }
        return stringBuffer.toString();
    }

    public static String canonicalizeAbsolutePath(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                if (bl2) continue;
                bl2 = true;
            } else if (bl2) {
                bl2 = false;
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() > 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String append(String string, String string2) {
        char c2;
        int n2;
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        int n3 = string.length();
        int n4 = string2.length();
        char[] cArray = new char[n3 + n4 + 2];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string.charAt(n2);
            if (n2 + 1 == n3 && c2 == '/') break;
            cArray[n5++] = c2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            c2 = string2.charAt(n2);
            if (n2 == 0 && c2 != '/' && n5 > 0) {
                cArray[n5++] = 47;
            }
            if (n2 + 1 == n4 && c2 == '/') break;
            cArray[n5++] = c2;
        }
        return new String(cArray, 0, n5);
    }

    public static boolean isSinglePathComponent(String string) {
        if (string == null || "".equals(string) || "..".equals(string)) {
            return true;
        }
        return string.indexOf(47) == -1;
    }

    public static String head(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '/') continue;
            return string.substring(0, i2);
        }
        return string;
    }

    public static String removeHead(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            if (string.charAt(i2) != '/') continue;
            for (n2 = i2; n2 < string.length() && string.charAt(n2) == '/'; ++n2) {
            }
            return string.substring(n2);
        }
        return "";
    }

    public static String tail(String string) {
        int n2 = string.length() - 1;
        if (n2 >= 0 && n2 < string.length() && string.charAt(n2) == '/') {
            --n2;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (string.charAt(i2) != '/') continue;
            return string.substring(i2 + 1, n2 + 1);
        }
        return string;
    }

    public static String removeTail(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) != '/') continue;
            return string.substring(0, i2);
        }
        return "";
    }

    public static String getCommonPathAncestor(String string, String string2) {
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        string = string.replace(File.separatorChar, '/');
        string2 = string2.replace(File.separatorChar, '/');
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && n2 < string2.length() && string.charAt(n2) == string2.charAt(n2); ++n2) {
            if (string.charAt(n2) != '/') continue;
            n3 = n2;
        }
        if (n2 == string.length() && n2 == string2.length()) {
            return string;
        }
        if (n2 == string.length() && string2.charAt(n2) == '/') {
            return string;
        }
        if (n2 == string2.length() && string.charAt(n2) == '/') {
            return string2;
        }
        return string.substring(0, n3);
    }

    public static String condencePaths(String[] stringArray, Collection collection, boolean bl2) {
        String string;
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string2 = stringArray[0];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string = stringArray[n2];
            string2 = SVNPathUtil.getCommonPathAncestor(string2, string);
        }
        if (collection != null && bl2) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string == null) continue;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string3;
                    String string4;
                    if (n2 == i2 || (string4 = stringArray[i2]) == null || "".equals(string3 = SVNPathUtil.getCommonPathAncestor(string, string4)) || string3 == null) continue;
                    if (string3.equals(string)) {
                        stringArray[i2] = null;
                        continue;
                    }
                    if (!string3.equals(string4)) continue;
                    stringArray[n2] = null;
                }
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string == null || !string.equals(string2)) continue;
                stringArray[n2] = null;
            }
        }
        if (collection != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = stringArray[n2];
                if (string == null) continue;
                if (string2 != null && !"".equals(string2) && (string = string.substring(string2.length())).startsWith("/")) {
                    string = string.substring(1);
                }
                collection.add(string);
            }
        }
        return string2;
    }

    public static int getSegmentsCount(String string) {
        int n2 = string.length() > 0 ? 1 : 0;
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '/') continue;
            ++n2;
        }
        return n2;
    }

    public static boolean isAncestor(String string, String string2) {
        string = string == null ? "" : string;
        String string3 = string2 = string2 == null ? "" : string2;
        if (string.length() == 0) {
            return !string2.startsWith("/");
        }
        if (string2.startsWith(string)) {
            if (string.length() != string2.length() && !string.endsWith("/") && string2.charAt(string.length()) != '/') {
                if (string.startsWith("file://") && string2.startsWith("file://")) {
                    String string4 = SVNEncodingUtil.uriEncode("\\");
                    return string.endsWith(string4) || string2.substring(string.length()).startsWith(string4);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getPathAsChild(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string2.compareTo(string) == 0) {
            return null;
        }
        if (string.length() == 0 && !string2.startsWith("/")) {
            return string2;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return null;
    }

    public static String getRelativePath(String string, String string2) {
        String string3 = SVNPathUtil.getPathAsChild(string = string.replace(File.separatorChar, '/'), string2 = string2.replace(File.separatorChar, '/'));
        return string3 == null ? "" : string3;
    }

    public static boolean isURL(String string) {
        string = string != null ? string.toLowerCase() : null;
        return string != null && (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("svn://") || string.startsWith("svn+") && string.indexOf("://") > 4 || string.startsWith("file://"));
    }

    public static boolean isWithinBasePath(String string, String string2) {
        return "".equals(string) || string2.startsWith(string) && (string2.length() == string.length() || string2.charAt(string.length()) == '/');
    }

    public static boolean isAbsolute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '/') {
            return true;
        }
        if (SVNFileUtil.isWindows && string.length() > 1) {
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            if ((c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') && c3 == ':') {
                return true;
            }
        }
        return false;
    }
}

