/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil$ElideMergeInfoCatalogHandler;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil$ElideMergeInfoEditor;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoUtil {
    public static void mergeCatalog(Map map, Map map2) {
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        Object[] objectArray = map.keySet().toArray();
        Object[] objectArray2 = map2.keySet().toArray();
        while (n2 < map.size() && n3 < map2.size()) {
            Map map3;
            object2 = (Comparable)objectArray[n2];
            object = (Comparable)objectArray2[n3];
            int n4 = object2.compareTo(object);
            if (n4 == 0) {
                map3 = (Map)map.get(object2);
                Map map4 = (Map)map2.get(object);
                Map map5 = SVNMergeInfoUtil.mergeMergeInfos(map3, map4);
                map.put(object2, map5);
                ++n2;
                ++n3;
                continue;
            }
            if (n4 < 0) {
                ++n2;
                continue;
            }
            map3 = (Map)map2.get(object);
            map3 = SVNMergeInfoUtil.dupMergeInfo(map3, null);
            map.put(object, map3);
            ++n3;
        }
        while (n3 < map2.size()) {
            object2 = objectArray2[n3];
            object = (Map)map2.get(object2);
            object = SVNMergeInfoUtil.dupMergeInfo((Map)object, null);
            map.put(object2, object);
            ++n3;
        }
    }

    public static Map filterCatalogByRanges(Map map, long l2, long l3) {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            Map map3 = SVNMergeInfoUtil.filterMergeInfoByRanges(map2, l2, l3);
            if (map3.isEmpty()) continue;
            treeMap.put(string, map3);
        }
        return treeMap;
    }

    public static Map filterMergeInfoByRanges(Map map, long l2, long l3) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        if (map != null) {
            SVNMergeRange sVNMergeRange = new SVNMergeRange(l3, l2, true);
            SVNMergeRangeList sVNMergeRangeList = new SVNMergeRangeList(sVNMergeRange);
            for (String string : map.keySet()) {
                SVNMergeRangeList sVNMergeRangeList2;
                SVNMergeRangeList sVNMergeRangeList3 = (SVNMergeRangeList)map.get(string);
                if (sVNMergeRangeList3.isEmpty() || (sVNMergeRangeList2 = sVNMergeRangeList.intersect(sVNMergeRangeList3, false)).isEmpty()) continue;
                treeMap.put(string, sVNMergeRangeList2);
            }
        }
        return treeMap;
    }

    public static long[] getRangeEndPoints(Map map) {
        long[] lArray = new long[]{-1L, -1L};
        if (map != null) {
            for (Object k2 : map.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(k2);
                if (sVNMergeRangeList.isEmpty()) continue;
                SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                SVNMergeRange sVNMergeRange = sVNMergeRangeArray[sVNMergeRangeArray.length - 1];
                if (!SVNRevision.isValidRevisionNumber(lArray[0]) || sVNMergeRange.getEndRevision() > lArray[0]) {
                    lArray[0] = sVNMergeRange.getEndRevision();
                }
                sVNMergeRange = sVNMergeRangeArray[0];
                if (SVNRevision.isValidRevisionNumber(lArray[1]) && lArray[1] <= sVNMergeRange.getStartRevision()) continue;
                lArray[1] = sVNMergeRange.getStartRevision();
            }
        }
        return lArray;
    }

    public static Map elideMergeInfoCatalog(Map treeMap) {
        String string;
        Object object;
        Object object2;
        TreeMap treeMap2 = new TreeMap();
        Object object3 = treeMap.keySet().iterator();
        while (object3.hasNext()) {
            object = object2 = (String)object3.next();
            if (((String)object2).startsWith("/")) {
                object = ((String)object2).substring(1);
            }
            treeMap2.put((String)object, treeMap.get(object2));
        }
        treeMap = treeMap2;
        object3 = new SVNMergeInfoUtil$ElideMergeInfoCatalogHandler(treeMap);
        object2 = new SVNMergeInfoUtil$ElideMergeInfoEditor(treeMap);
        SVNCommitUtil.driveCommitEditor((ISVNCommitPathHandler)object3, treeMap.keySet(), (ISVNEditor)object2, -1L);
        object = ((SVNMergeInfoUtil$ElideMergeInfoCatalogHandler)object3).getElidablePaths();
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            treeMap.remove(string);
        }
        treeMap2 = new TreeMap();
        iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = string = (String)iterator.next();
            if (!string.startsWith("/")) {
                string2 = "/" + string2;
            }
            treeMap2.put(string2, treeMap.get(string));
        }
        return treeMap2;
    }

    public static Map adjustMergeInfoSourcePaths(Map map, String string, Map map2) {
        map = map == null ? new TreeMap() : map;
        for (String string2 : map2.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map2.get(string2);
            map.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, string)), sVNMergeRangeList);
        }
        return map;
    }

    public static boolean removeEmptyRangeLists(Map map) {
        boolean bl2 = false;
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)entry.getValue();
                if (!sVNMergeRangeList.isEmpty()) continue;
                iterator.remove();
                bl2 = true;
            }
        }
        return bl2;
    }

    public static Map mergeMergeInfos(Map map, Map map2) {
        String string;
        map = map == null ? new TreeMap() : map;
        map2 = map2 == null ? Collections.EMPTY_MAP : map2;
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        String[] stringArray2 = map2.keySet().toArray(new String[map2.size()]);
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length && n3 < stringArray2.length) {
            string = stringArray[n2];
            String string2 = stringArray2[n3];
            int n4 = string.compareTo(string2);
            if (n4 == 0) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
                SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map2.get(string2);
                sVNMergeRangeList = sVNMergeRangeList.merge(sVNMergeRangeList2);
                map.put(string, sVNMergeRangeList);
                ++n2;
                ++n3;
                continue;
            }
            if (n4 < 0) {
                ++n2;
                continue;
            }
            map.put(string2, map2.get(string2));
            ++n3;
        }
        while (n3 < stringArray2.length) {
            string = stringArray2[n3];
            map.put(string, map2.get(string));
            ++n3;
        }
        return map;
    }

    public static String combineMergeInfoProperties(String string, String string2) {
        Map map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string), null);
        Map map2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
        map = SVNMergeInfoUtil.mergeMergeInfos(map, map2);
        return SVNMergeInfoUtil.formatMergeInfoToString(map, null);
    }

    public static String combineForkedMergeInfoProperties(String string, String string2, String string3) {
        Map map = new TreeMap();
        Map map2 = new TreeMap();
        Map map3 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string), null);
        SVNMergeInfoUtil.diffMergeInfoProperties(map, map2, null, map3, string2, null);
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfoProperties(treeMap, treeMap2, string, null, string3, null);
        map = SVNMergeInfoUtil.mergeMergeInfos(map, treeMap);
        map2 = SVNMergeInfoUtil.mergeMergeInfos(map2, treeMap2);
        map3 = SVNMergeInfoUtil.mergeMergeInfos(map3, map2);
        Map map4 = SVNMergeInfoUtil.removeMergeInfo(map, map3);
        return SVNMergeInfoUtil.formatMergeInfoToString(map4, null);
    }

    public static void diffMergeInfoProperties(Map map, Map map2, String string, Map map3, String string2, Map map4) {
        if (string != null && string.equals(string2)) {
            return;
        }
        map3 = map3 == null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string), null) : map3;
        map4 = map4 == null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null) : map4;
        SVNMergeInfoUtil.diffMergeInfo(map, map2, map3, map4, true);
    }

    public static void diffMergeInfo(Map map, Map map2, Map map3, Map map4, boolean bl2) {
        map3 = map3 == null ? Collections.EMPTY_MAP : map3;
        Map map5 = map4 = map4 == null ? Collections.EMPTY_MAP : map4;
        if (!map3.isEmpty() && map4.isEmpty()) {
            SVNMergeInfoUtil.dupMergeInfo(map3, map);
        } else if (map3.isEmpty() && !map4.isEmpty()) {
            SVNMergeInfoUtil.dupMergeInfo(map4, map2);
        } else if (!map3.isEmpty() && !map4.isEmpty()) {
            SVNMergeInfoUtil.walkMergeInfoHashForDiff(map, map2, map3, map4, bl2);
        }
    }

    public static Map dupCatalog(Map map) {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            Map map3 = SVNMergeInfoUtil.dupMergeInfo(map2, null);
            treeMap.put(string, map3);
        }
        return treeMap;
    }

    public static Map dupMergeInfo(Map map, Map map2) {
        if (map == null) {
            return null;
        }
        map2 = map2 == null ? new TreeMap() : map2;
        for (String string : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            map2.put(string, sVNMergeRangeList.dup());
        }
        return map2;
    }

    public static boolean isNonInheritable(Map map) {
        if (map != null) {
            for (String string : map.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
                SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                for (int i2 = 0; sVNMergeRangeArray != null && i2 < sVNMergeRangeArray.length; ++i2) {
                    if (sVNMergeRangeArray[i2] == null || sVNMergeRangeArray[i2].isInheritable()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Map parseMergeInfo(StringBuffer stringBuffer, Map map) {
        Map map2 = map = map == null ? new TreeMap() : map;
        if (stringBuffer.length() == 0) {
            return map;
        }
        try {
            while (stringBuffer.length() > 0) {
                Object object;
                Object[] objectArray;
                Object object2;
                int n2 = stringBuffer.indexOf("\n");
                n2 = n2 < 0 ? stringBuffer.length() - 1 : n2;
                int n3 = stringBuffer.lastIndexOf(":", n2);
                if (n3 == -1) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Pathname not terminated by ':'");
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
                }
                if (n3 == 0) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "No pathname preceding ':'");
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.DEFAULT);
                }
                object2 = null;
                if (stringBuffer.charAt(0) == '/') {
                    object2 = stringBuffer.substring(0, n3);
                } else {
                    objectArray = stringBuffer.substring(0, n3);
                    object2 = "/" + (String)objectArray;
                }
                stringBuffer = stringBuffer.delete(0, n3 + 1);
                objectArray = SVNMergeInfoUtil.parseRevisionList(stringBuffer, (String)object2);
                if (stringBuffer.length() != 0 && stringBuffer.charAt(0) != '\n') {
                    object = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Could not find end of line in range list line in ''{0}''", (Object)stringBuffer);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.deleteCharAt(0);
                }
                if (objectArray.length > 1) {
                    Arrays.sort(objectArray);
                    object = objectArray[0];
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                    for (int i2 = 1; i2 < objectArray.length; ++i2) {
                        Object object3 = objectArray[i2];
                        if (((SVNMergeRange)object).getStartRevision() <= ((SVNMergeRange)object3).getEndRevision() && ((SVNMergeRange)object3).getStartRevision() <= ((SVNMergeRange)object).getEndRevision()) {
                            if (((SVNMergeRange)object3).getStartRevision() < ((SVNMergeRange)object).getEndRevision() && ((SVNMergeRange)object3).isInheritable() != ((SVNMergeRange)object).isInheritable()) {
                                String string = ((SVNMergeRange)object).toString();
                                String string2 = ((SVNMergeRange)object3).toString();
                                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Unable to parse overlapping revision ranges ''{0}'' and ''{1}'' with different inheritance types", string, string2);
                                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                            }
                            if (((SVNMergeRange)object).isInheritable() == ((SVNMergeRange)object3).isInheritable()) {
                                ((SVNMergeRange)object).setEndRevision(Math.max(((SVNMergeRange)object3).getEndRevision(), ((SVNMergeRange)object).getEndRevision()));
                                continue;
                            }
                        }
                        arrayList.add(objectArray[i2]);
                        object = objectArray[i2];
                    }
                    objectArray = arrayList.toArray(new SVNMergeRange[arrayList.size()]);
                }
                if ((object = (SVNMergeRangeList)map.get(object2)) != null) {
                    objectArray = ((SVNMergeRangeList)object).merge(new SVNMergeRangeList((SVNMergeRange[])objectArray)).getRanges();
                }
                map.put(object2, new SVNMergeRangeList((SVNMergeRange[])objectArray));
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Could not parse mergeinfo string ''{0}''", (Object)stringBuffer.toString());
                SVNErrorManager.error(sVNErrorMessage, sVNException, SVNLogType.DEFAULT);
            }
            throw sVNException;
        }
        return map;
    }

    public static String formatMergeInfoCatalogToString(Map map, String string, String string2) {
        StringBuffer stringBuffer = null;
        if (map != null && !map.isEmpty()) {
            stringBuffer = new StringBuffer();
            for (String string3 : map.keySet()) {
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                Map map2 = (Map)map.get(string3);
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string3);
                stringBuffer.append('\n');
                stringBuffer.append(SVNMergeInfoUtil.formatMergeInfoToString(map2, string2 != null ? string2 : ""));
                stringBuffer.append('\n');
            }
        }
        return stringBuffer != null ? stringBuffer.toString() : "\n";
    }

    public static String formatMergeInfoCatalogToString2(Map map, String string, String string2) {
        StringBuffer stringBuffer = null;
        if (map != null && !map.isEmpty()) {
            stringBuffer = new StringBuffer();
            for (File file : map.keySet()) {
                String string3 = SVNFileUtil.getFilePath(file);
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                Map map2 = (Map)map.get(file);
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string3);
                stringBuffer.append('\n');
                stringBuffer.append(SVNMergeInfoUtil.formatMergeInfoToString(map2, string2 != null ? string2 : ""));
                stringBuffer.append('\n');
            }
        }
        return stringBuffer != null ? stringBuffer.toString() : "\n";
    }

    public static String[] formatMergeInfoToArray(Map map, String string) {
        map = map == null ? Collections.EMPTY_MAP : map;
        String[] stringArray = new String[map.size()];
        int n2 = 0;
        for (String string2 : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
            String string3 = (string != null ? string : "") + (string2.startsWith("/") ? "" : "/") + string2 + ':' + sVNMergeRangeList;
            stringArray[n2++] = string3;
        }
        return stringArray;
    }

    public static String formatMergeInfoToString(Map map, String string) {
        String[] stringArray = SVNMergeInfoUtil.formatMergeInfoToArray(map, string);
        String string2 = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = string2 + stringArray[i2];
            if (i2 >= stringArray.length - 1) continue;
            string2 = string2 + '\n';
        }
        return string2;
    }

    public static boolean shouldElideMergeInfo(Map treeMap, Map map, String string) {
        boolean bl2 = false;
        if (map != null) {
            if (map.isEmpty()) {
                if (treeMap == null || treeMap.isEmpty()) {
                    bl2 = true;
                }
            } else if (treeMap != null && !treeMap.isEmpty()) {
                TreeMap treeMap2 = treeMap;
                if (string != null) {
                    treeMap2 = new TreeMap();
                    for (String string2 : treeMap.keySet()) {
                        treeMap2.put(SVNPathUtil.getAbsolutePath(SVNPathUtil.append(string2, string)), treeMap.get(string2));
                    }
                }
                bl2 = SVNMergeInfoUtil.mergeInfoEquals(treeMap2, map, true);
            }
        }
        return bl2;
    }

    public static void elideMergeInfo(Map map, Map map2, File file, String string, SVNWCAccess sVNWCAccess) {
        boolean bl2 = SVNMergeInfoUtil.shouldElideMergeInfo(map, map2, string);
        if (bl2) {
            SVNPropertiesManager.setProperty(sVNWCAccess, file, "svn:mergeinfo", null, true);
        }
    }

    public static boolean mergeInfoEquals(Map map, Map map2, boolean bl2) {
        map = map == null ? Collections.EMPTY_MAP : map;
        Map map3 = map2 = map2 == null ? Collections.EMPTY_MAP : map2;
        if (map.size() == map2.size()) {
            SVNHashMap sVNHashMap = new SVNHashMap();
            SVNHashMap sVNHashMap2 = new SVNHashMap();
            SVNMergeInfoUtil.diffMergeInfo(sVNHashMap, sVNHashMap2, map, map2, bl2);
            return sVNHashMap.isEmpty() && sVNHashMap2.isEmpty();
        }
        return false;
    }

    public static String[] findMergeSources(long l2, Map map) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            if (!sVNMergeRangeList.includes(l2)) continue;
            linkedList.add(string);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static Map getInheritableMergeInfo(Map map, String string, long l2, long l3) {
        return SVNMergeInfoUtil.getInheritableMergeInfo(map, string, l2, l3, true);
    }

    public static Map getInheritableMergeInfo(Map map, String string, long l2, long l3, boolean bl2) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        if (map != null) {
            for (String string2 : map.keySet()) {
                SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string2);
                SVNMergeRangeList sVNMergeRangeList2 = null;
                sVNMergeRangeList2 = string == null || string.equals(string2) ? sVNMergeRangeList.getInheritableRangeList(l2, l3, bl2) : sVNMergeRangeList.dup();
                if (sVNMergeRangeList2.isEmpty()) continue;
                treeMap.put(string2, sVNMergeRangeList2);
            }
        }
        return treeMap;
    }

    public static Map removeMergeInfo(Map map, Map map2) {
        return SVNMergeInfoUtil.removeMergeInfo(map, map2, true);
    }

    public static Map removeMergeInfo(Map map, Map map2, boolean bl2) {
        TreeMap treeMap = new TreeMap();
        SVNMergeInfoUtil.walkMergeInfoHashForDiff(treeMap, null, map2, map, bl2);
        return treeMap;
    }

    public static Map intersectMergeInfo(Map map, Map map2) {
        return SVNMergeInfoUtil.intersectMergeInfo(map, map2, true);
    }

    public static Map intersectMergeInfo(Map map, Map map2, boolean bl2) {
        TreeMap<String, SVNMergeRangeList> treeMap = new TreeMap<String, SVNMergeRangeList>();
        for (String string : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map2.get(string);
            if (sVNMergeRangeList2 == null || (sVNMergeRangeList2 = sVNMergeRangeList2.intersect(sVNMergeRangeList, bl2)).isEmpty()) continue;
            treeMap.put(string, sVNMergeRangeList2.dup());
        }
        return treeMap;
    }

    public static SVNMergeRange[] parseRevisionList(StringBuffer stringBuffer, String string) {
        SVNErrorMessage sVNErrorMessage;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '\n' && Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer = stringBuffer.deleteCharAt(0);
        }
        if (stringBuffer.length() == 0 || stringBuffer.charAt(0) == '\n') {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Mergeinfo for ''{0}'' maps to an empty revision range", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        while (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '\n') {
            Object object;
            long l2 = SVNMergeInfoUtil.parseRevision(stringBuffer);
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '\n' && stringBuffer.charAt(0) != '-' && stringBuffer.charAt(0) != ',' && stringBuffer.charAt(0) != '*') {
                object = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in revision list", (Object)Character.valueOf(stringBuffer.charAt(0)));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
            }
            object = new SVNMergeRange(l2 - 1L, l2, true);
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '-') {
                SVNErrorMessage sVNErrorMessage2;
                long l3 = SVNMergeInfoUtil.parseRevision(stringBuffer = stringBuffer.deleteCharAt(0));
                if (l2 > l3) {
                    sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Unable to parse reversed revision range ''{0}-{1}''", l2, l3);
                    SVNErrorManager.error(sVNErrorMessage2, SVNLogType.DEFAULT);
                } else if (l2 == l3) {
                    sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Unable to parse revision range ''{0}-{1}'' with same start and end revisions", l2, l3);
                    SVNErrorManager.error(sVNErrorMessage2, SVNLogType.DEFAULT);
                }
                ((SVNMergeRange)object).setEndRevision(l3);
            }
            if (stringBuffer.length() == 0 || stringBuffer.charAt(0) == '\n') {
                linkedList.add(object);
                return linkedList.toArray(new SVNMergeRange[linkedList.size()]);
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ',') {
                linkedList.add(object);
                stringBuffer = stringBuffer.deleteCharAt(0);
                continue;
            }
            if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '*') {
                ((SVNMergeRange)object).setInheritable(false);
                stringBuffer = stringBuffer.deleteCharAt(0);
                if (stringBuffer.length() == 0 || stringBuffer.charAt(0) == ',' || stringBuffer.charAt(0) == '\n') {
                    linkedList.add(object);
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ',') {
                        stringBuffer = stringBuffer.deleteCharAt(0);
                        continue;
                    }
                    return linkedList.toArray(new SVNMergeRange[linkedList.size()]);
                }
                SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in range list", (Object)(stringBuffer.length() > 0 ? stringBuffer.charAt(0) + "" : ""));
                SVNErrorManager.error(sVNErrorMessage3, SVNLogType.DEFAULT);
                continue;
            }
            SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Invalid character ''{0}'' found in range list", (Object)(stringBuffer.length() > 0 ? stringBuffer.charAt(0) + "" : ""));
            SVNErrorManager.error(sVNErrorMessage4, SVNLogType.DEFAULT);
        }
        if (stringBuffer.length() == 0 || stringBuffer.charAt(0) != '\n') {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.MERGE_INFO_PARSE_ERROR, "Range list parsing ended before hitting newline");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return linkedList.toArray(new SVNMergeRange[linkedList.size()]);
    }

    public static Map appendSuffix(Map map, String string) {
        TreeMap treeMap = new TreeMap();
        for (String string2 : map.keySet()) {
            String string3 = SVNPathUtil.append(string2, string);
            treeMap.put(string3, map.get(string2));
        }
        return treeMap;
    }

    public static SVNMergeRangeList[] diffMergeRangeLists(SVNMergeRangeList sVNMergeRangeList, SVNMergeRangeList sVNMergeRangeList2, boolean bl2) {
        SVNMergeRangeList sVNMergeRangeList3 = sVNMergeRangeList.diff(sVNMergeRangeList2, bl2);
        SVNMergeRangeList sVNMergeRangeList4 = sVNMergeRangeList2.diff(sVNMergeRangeList, bl2);
        return new SVNMergeRangeList[]{sVNMergeRangeList3, sVNMergeRangeList4};
    }

    private static long parseRevision(StringBuffer stringBuffer) {
        Object object;
        int n2;
        for (n2 = 0; n2 < stringBuffer.length() && Character.isDigit(stringBuffer.charAt(n2)); ++n2) {
        }
        if (n2 == 0) {
            object = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Invalid revision number found parsing ''{0}''", (Object)stringBuffer.toString());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.DEFAULT);
        }
        object = stringBuffer.substring(0, n2);
        long l2 = -1L;
        try {
            l2 = Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Invalid revision number found parsing ''{0}''", (Object)stringBuffer.toString());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (l2 < 0L) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.REVISION_NUMBER_PARSE_ERROR, "Negative revision number found parsing ''{0}''", (Object)stringBuffer.toString());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        stringBuffer = stringBuffer.delete(0, n2);
        return l2;
    }

    private static void walkMergeInfoHashForDiff(Map map, Map map2, Map map3, Map map4, boolean bl2) {
        SVNMergeRangeList sVNMergeRangeList;
        for (String string : map3.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)map3.get(string);
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map4.get(string);
            if (sVNMergeRangeList2 != null) {
                SVNMergeRangeList[] sVNMergeRangeListArray = SVNMergeInfoUtil.diffMergeRangeLists(sVNMergeRangeList, sVNMergeRangeList2, bl2);
                SVNMergeRangeList sVNMergeRangeList3 = sVNMergeRangeListArray[0];
                SVNMergeRangeList sVNMergeRangeList4 = sVNMergeRangeListArray[1];
                if (map != null && sVNMergeRangeList3.getSize() > 0) {
                    map.put(string, sVNMergeRangeList3);
                }
                if (map2 == null || sVNMergeRangeList4.getSize() <= 0) continue;
                map2.put(string, sVNMergeRangeList4);
                continue;
            }
            if (map == null) continue;
            map.put(string, sVNMergeRangeList.dup());
        }
        if (map2 == null) {
            return;
        }
        for (String string : map4.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)map4.get(string);
            if (map3.containsKey(string)) continue;
            map2.put(string, sVNMergeRangeList.dup());
        }
    }
}

