/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogStream
extends OutputStream {
    private ISVNDebugLog myLog;
    private ByteArrayOutputStream myBuffer;
    private String myPrefix;

    public SVNLogStream(ISVNDebugLog iSVNDebugLog, boolean bl2) {
        this.myLog = iSVNDebugLog;
        this.myBuffer = new ByteArrayOutputStream(2048);
        this.myPrefix = bl2 ? "SENT" : "READ";
    }

    @Override
    public void write(int n2) {
        this.myBuffer.write(n2);
        this.flushBuffer(false);
    }

    @Override
    public void close() {
        this.flushBuffer(true);
    }

    @Override
    public void flush() {
        this.flushBuffer(true);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.myBuffer.write(byArray, n2, n3);
        this.flushBuffer(false);
    }

    public void flushBuffer(boolean bl2) {
        if (!bl2 && this.myBuffer.size() < 1024) {
            return;
        }
        if (this.myLog != null && this.myBuffer.size() > 0) {
            this.myLog.log(SVNLogType.NETWORK, this.myPrefix, this.myBuffer.toByteArray());
        }
        this.myBuffer.reset();
    }
}

