/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.util.Arrays;

public class SVNIntMap {
    public static final int INITIAL_CAPACITY = 8192;
    public static final int CACHE_SIZE = 8192;
    public static final int CACHE_SIZE_MASK = 8191;
    private int[] keys = new int[this.capacity];
    private Object[] values = new Object[this.capacity];
    private int[] nextIndices = new int[this.capacity];
    private int[] hashToIndex = new int[8192];
    private int size = 0;
    private int capacity = 8192;

    public SVNIntMap() {
        Arrays.fill(this.keys, -1);
        Arrays.fill(this.nextIndices, -1);
        Arrays.fill(this.hashToIndex, -1);
    }

    public boolean containsKey(int n2) {
        int n3 = this.fitTableSize(this.hash(n2));
        return this.hashToIndex[n3] != -1;
    }

    public Object get(int n2) {
        int n3 = this.fitTableSize(this.hash(n2));
        int n4 = this.hashToIndex[n3];
        while (n4 != -1) {
            if (this.keys[n4] == n2) {
                return this.values[n4];
            }
            n4 = this.nextIndices[n4];
        }
        return null;
    }

    public void put(int n2, Object object) {
        this.maybeGrowCapacity();
        int n3 = this.fitTableSize(this.hash(n2));
        int n4 = this.hashToIndex[n3];
        int n5 = -1;
        while (n4 != -1) {
            if (this.keys[n4] == n2) {
                this.values[n4] = object;
                return;
            }
            n5 = n4;
            n4 = this.nextIndices[n4];
        }
        int n6 = this.size++;
        if (n5 != -1) {
            this.nextIndices[n5] = n6;
        }
        if (this.hashToIndex[n3] == -1) {
            this.hashToIndex[n3] = n6;
        }
        this.keys[n6] = n2;
        this.values[n6] = object;
    }

    private void maybeGrowCapacity() {
        if (this.size < this.capacity) {
            return;
        }
        int n2 = this.capacity * 2;
        int[] nArray = new int[n2];
        Object[] objectArray = new Object[n2];
        int[] nArray2 = new int[n2];
        System.arraycopy(this.keys, 0, nArray, 0, this.size);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        System.arraycopy(this.nextIndices, 0, nArray2, 0, this.size);
        Arrays.fill(nArray, this.size, nArray.length, -1);
        Arrays.fill(nArray2, this.size, nArray2.length, -1);
        this.keys = nArray;
        this.values = objectArray;
        this.nextIndices = nArray2;
        this.capacity = n2;
    }

    private int fitTableSize(int n2) {
        return n2 & 0x1FFF;
    }

    private int hash(int n2) {
        return n2;
    }
}

