/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.internal.util.SVNHashMap$EntrySet;
import org.tmatesoft.svn.core.internal.util.SVNHashMap$KeySet;
import org.tmatesoft.svn.core.internal.util.SVNHashMap$TableEntry;
import org.tmatesoft.svn.core.internal.util.SVNHashMap$ValueCollection;

public class SVNHashMap
implements Serializable,
Cloneable,
Map {
    private static final long serialVersionUID = 1L;
    private static final Object NULL_KEY = new Object();
    private static final int INITIAL_CAPACITY = 16;
    private static boolean ourIsCompatibilityMode = Boolean.getBoolean("svnkit.compatibleHash");
    private transient SVNHashMap$TableEntry[] myTable;
    private transient int myEntryCount;
    private transient int myModCount;
    private volatile transient Set myKeySet;
    private volatile transient Set myEntrySet;
    private volatile transient Collection myValueCollection;

    public SVNHashMap() {
        this(null);
    }

    public SVNHashMap(Map map) {
        this.init();
        this.putAll(map);
    }

    protected void init() {
        this.myTable = new SVNHashMap$TableEntry[16];
        this.myEntryCount = 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.myTable, null);
        this.myEntryCount = 0;
        ++this.myModCount;
    }

    @Override
    public boolean isEmpty() {
        return this.myEntryCount == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.isEmpty()) {
            return false;
        }
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMap.hashCode(object);
        int n3 = this.indexForHash(n2);
        SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[n3];
        while (sVNHashMap$TableEntry != null) {
            if (SVNHashMap$TableEntry.access$000(sVNHashMap$TableEntry) == n2 && SVNHashMap.eq(object, SVNHashMap$TableEntry.access$100(sVNHashMap$TableEntry))) {
                return true;
            }
            sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.isEmpty()) {
            return false;
        }
        if (object == null) {
            return this.containsNullValue();
        }
        for (int i2 = 0; i2 < this.myTable.length; ++i2) {
            SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[i2];
            while (sVNHashMap$TableEntry != null) {
                if (object.equals(sVNHashMap$TableEntry.getValue())) {
                    return true;
                }
                sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        for (int i2 = 0; i2 < this.myTable.length; ++i2) {
            SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[i2];
            while (sVNHashMap$TableEntry != null) {
                if (sVNHashMap$TableEntry.getValue() == null) {
                    return true;
                }
                sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
            }
        }
        return false;
    }

    public Object get(Object object) {
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMap.hashCode(object);
        int n3 = this.indexForHash(n2);
        SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[n3];
        while (sVNHashMap$TableEntry != null) {
            if (n2 == SVNHashMap$TableEntry.access$000(sVNHashMap$TableEntry) && SVNHashMap.eq(object, SVNHashMap$TableEntry.access$100(sVNHashMap$TableEntry))) {
                return sVNHashMap$TableEntry.getValue();
            }
            sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
        }
        return null;
    }

    @Override
    public int size() {
        return this.myEntryCount;
    }

    public Object put(Object object, Object object2) {
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMap.hashCode(object);
        int n3 = this.indexForHash(n2);
        SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[n3];
        SVNHashMap$TableEntry sVNHashMap$TableEntry2 = null;
        while (sVNHashMap$TableEntry != null) {
            if (SVNHashMap$TableEntry.access$000(sVNHashMap$TableEntry) == n2 && SVNHashMap$TableEntry.access$100(sVNHashMap$TableEntry).equals(object)) {
                ++this.myModCount;
                return sVNHashMap$TableEntry.setValue(object2);
            }
            sVNHashMap$TableEntry2 = sVNHashMap$TableEntry;
            sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
        }
        SVNHashMap$TableEntry sVNHashMap$TableEntry3 = this.createTableEntry(object, object2, n2);
        if (sVNHashMap$TableEntry2 != null) {
            SVNHashMap$TableEntry.access$202(sVNHashMap$TableEntry2, sVNHashMap$TableEntry3);
        } else {
            this.myTable[n3] = sVNHashMap$TableEntry3;
        }
        ++this.myEntryCount;
        ++this.myModCount;
        if (this.myEntryCount >= this.myTable.length) {
            this.resize(this.myTable.length * 2);
        }
        return null;
    }

    protected SVNHashMap$TableEntry createTableEntry(Object object, Object object2, int n2) {
        return new SVNHashMap$TableEntry(object, object2, n2);
    }

    public Object remove(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMap.hashCode(object);
        int n3 = this.indexForHash(n2);
        SVNHashMap$TableEntry sVNHashMap$TableEntry = this.myTable[n3];
        SVNHashMap$TableEntry sVNHashMap$TableEntry2 = null;
        while (sVNHashMap$TableEntry != null) {
            if (SVNHashMap$TableEntry.access$000(sVNHashMap$TableEntry) == n2 && SVNHashMap$TableEntry.access$100(sVNHashMap$TableEntry).equals(object)) {
                if (sVNHashMap$TableEntry2 != null) {
                    SVNHashMap$TableEntry.access$202(sVNHashMap$TableEntry2, SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry));
                } else {
                    this.myTable[n3] = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
                }
                --this.myEntryCount;
                ++this.myModCount;
                return sVNHashMap$TableEntry.getValue();
            }
            sVNHashMap$TableEntry2 = sVNHashMap$TableEntry;
            sVNHashMap$TableEntry = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
        }
        return null;
    }

    public void putAll(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.myEntryCount + map.size() >= this.myTable.length) {
            this.resize((this.myEntryCount + map.size()) * 2);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        if (this.myKeySet == null) {
            this.myKeySet = new SVNHashMap$KeySet(this, null);
        }
        return this.myKeySet;
    }

    public Set entrySet() {
        if (this.myEntrySet == null) {
            this.myEntrySet = new SVNHashMap$EntrySet(this, null);
        }
        return this.myEntrySet;
    }

    public Collection values() {
        if (this.myValueCollection == null) {
            this.myValueCollection = new SVNHashMap$ValueCollection(this, null);
        }
        return this.myValueCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry entry : this.entrySet()) {
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.myTable = new SVNHashMap$TableEntry[this.myTable.length];
        sVNHashMap.myEntryCount = this.myEntryCount;
        sVNHashMap.myModCount = this.myModCount;
        sVNHashMap.putAll((Map)this);
        return sVNHashMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        Iterator iterator = this.myEntryCount > 0 ? this.entrySet().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.myTable.length);
        objectOutputStream.writeInt(this.myEntryCount);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.myTable = new SVNHashMap$TableEntry[n2];
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.entrySet().iterator();
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            stringBuffer.append((Object)(k2 == this ? "(this Map)" : k2));
            stringBuffer.append("=");
            stringBuffer.append((Object)(v2 == this ? "(this Map)" : v2));
            bl2 = iterator.hasNext();
            if (!bl2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private int indexForHash(int n2) {
        return this.myTable.length - 1 & n2;
    }

    private static int hashCode(Object object) {
        if (ourIsCompatibilityMode && String.class == object.getClass()) {
            int n2 = 0;
            String string = (String)object;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                n2 = n2 * 33 + string.charAt(i2);
            }
            return n2;
        }
        if (object.getClass() == File.class) {
            return SVNHashMap.hashCode(((File)object).getPath());
        }
        return object.hashCode();
    }

    private void resize(int n2) {
        SVNHashMap$TableEntry[] sVNHashMap$TableEntryArray = this.myTable;
        this.myTable = new SVNHashMap$TableEntry[n2];
        for (int i2 = 0; i2 < sVNHashMap$TableEntryArray.length; ++i2) {
            SVNHashMap$TableEntry sVNHashMap$TableEntry = sVNHashMap$TableEntryArray[i2];
            while (sVNHashMap$TableEntry != null) {
                int n3 = this.indexForHash(SVNHashMap$TableEntry.access$000(sVNHashMap$TableEntry));
                SVNHashMap$TableEntry sVNHashMap$TableEntry2 = this.myTable[n3];
                if (sVNHashMap$TableEntry2 == null) {
                    this.myTable[n3] = sVNHashMap$TableEntry;
                } else {
                    while (SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry2) != null) {
                        sVNHashMap$TableEntry2 = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry2);
                    }
                    SVNHashMap$TableEntry.access$202(sVNHashMap$TableEntry2, sVNHashMap$TableEntry);
                }
                SVNHashMap$TableEntry sVNHashMap$TableEntry3 = SVNHashMap$TableEntry.access$200(sVNHashMap$TableEntry);
                SVNHashMap$TableEntry.access$202(sVNHashMap$TableEntry, null);
                sVNHashMap$TableEntry = sVNHashMap$TableEntry3;
            }
        }
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static /* synthetic */ int access$700(SVNHashMap sVNHashMap) {
        return sVNHashMap.myEntryCount;
    }

    static /* synthetic */ int access$900(SVNHashMap sVNHashMap) {
        return sVNHashMap.myModCount;
    }

    static /* synthetic */ SVNHashMap$TableEntry[] access$1000(SVNHashMap sVNHashMap) {
        return sVNHashMap.myTable;
    }

    static /* synthetic */ Object access$1100() {
        return NULL_KEY;
    }
}

