/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNFLock {
    private final File file;
    private final boolean exclusive;
    private int fd;
    private Process flockProcess;

    public static SVNFLock obtain(File file, boolean bl2) {
        if (!(SVNFileUtil.isLinux || SVNFileUtil.isBSD || SVNFileUtil.isOSX)) {
            return null;
        }
        int n2 = SVNJNAUtil.flock(file, bl2);
        if (n2 >= 0) {
            return new SVNFLock(file, bl2, n2, null);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(SVNFLock.shouldUsePerlCommand() ? SVNFLock.getPerlCommand(file, bl2) : SVNFLock.getFlockCommand(file, bl2));
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            int n3 = inputStream.read();
            if (n3 == 120) {
                return new SVNFLock(file, bl2, -1, process);
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Unable to lock ''{0}'', exclusive={1}", file, bl2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return null;
    }

    private SVNFLock(File file, boolean bl2, int n2, Process process) {
        this.file = file;
        this.exclusive = bl2;
        this.fd = n2;
        this.flockProcess = process;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isValid() {
        return this.fd >= 0 || this.flockProcess != null;
    }

    public void release() {
        if (this.isJNALock()) {
            if (SVNJNAUtil.unflock(this.fd)) {
                this.fd = -1;
            }
        } else if (this.flockProcess != null) {
            OutputStream outputStream = this.flockProcess.getOutputStream();
            try {
                outputStream.write(10);
                outputStream.close();
                int n2 = this.flockProcess.waitFor();
                if (n2 != 0) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, "Couldn't unlock \"" + this.file.getAbsolutePath() + "\", rc=" + n2, Level.FINEST);
                }
                this.flockProcess = null;
            }
            catch (IOException iOException) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, iOException, Level.FINEST);
            }
            catch (InterruptedException interruptedException) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, interruptedException, Level.FINEST);
            }
        }
    }

    public String toString() {
        return "SVNFLock{file=" + this.file + ", exclusive=" + this.exclusive + ", valid=" + this.isValid() + ", using " + (this.isJNALock() ? "JNA" : (SVNFLock.shouldUsePerlCommand() ? "'perl' command" : "'flock' utility")) + '}';
    }

    private boolean isJNALock() {
        return this.fd >= 0;
    }

    private static boolean shouldUsePerlCommand() {
        return SVNFileUtil.isOSX;
    }

    private static List getFlockCommand(File file, boolean bl2) {
        return Arrays.asList("flock", bl2 ? "--exclusive" : "--shared", file.getAbsolutePath(), "--command", "echo x && read -N 1");
    }

    private static List getPerlCommand(File file, boolean bl2) {
        return Arrays.asList("perl", "-MFcntl=:flock", "-e", "$|=1;$f=shift;open(FH, \"+>>\",$f)||die($!);" + String.format("flock(FH,%s);", bl2 ? "LOCK_EX" : "LOCK_SH") + "print \"x\";readline(STDIN);flock(FH,LOCK_UN);", file.getAbsolutePath());
    }
}

