/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNEncodingUtil {
    private static final Map XML_UNESCAPE_MAP = new SVNHashMap();
    private static final byte[] uri_char_validity;

    public static String uriEncode(String string) {
        byte[] byArray;
        StringBuffer stringBuffer = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (uri_char_validity[n2] > 0) {
                if (stringBuffer == null) continue;
                stringBuffer.append((char)byArray[i2]);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(new String(byArray, 0, i2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    stringBuffer.append(new String(byArray, 0, i2));
                }
            }
            stringBuffer.append("%");
            stringBuffer.append(Character.toUpperCase(Character.forDigit((n2 & 0xF0) >> 4, 16)));
            stringBuffer.append(Character.toUpperCase(Character.forDigit(n2 & 0xF, 16)));
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String autoURIEncode(String string) {
        byte[] byArray;
        StringBuffer stringBuffer = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (uri_char_validity[n2] > 0) {
                if (stringBuffer == null) continue;
                stringBuffer.append((char)byArray[i2]);
                continue;
            }
            if (n2 == 37 && i2 + 2 < byArray.length && SVNEncodingUtil.isHexDigit((char)byArray[i2 + 1]) && SVNEncodingUtil.isHexDigit((char)byArray[i2 + 2])) {
                if (stringBuffer == null) continue;
                stringBuffer.append((char)byArray[i2]);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(new String(byArray, 0, i2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    stringBuffer.append(new String(byArray, 0, i2));
                }
            }
            stringBuffer.append("%");
            stringBuffer.append(Character.toUpperCase(Character.forDigit((n2 & 0xF0) >> 4, 16)));
            stringBuffer.append(Character.toUpperCase(Character.forDigit(n2 & 0xF, 16)));
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static void assertURISafe(String string) {
        byte[] byArray;
        string = string == null ? "" : string;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' could not be encoded as UTF-8", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
            return;
        }
        if (byArray == null || byArray.length != string.length()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (uri_char_validity[byArray[i2]] > 0 || byArray[i2] == 37) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "path ''{0}'' doesn not look like URI-encoded path; character ''{1}'' is URI unsafe", string, (char)byArray[i2] + "");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
    }

    public static String uriDecode(String string) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = string.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.charAt(i2);
            if (n3 == 63) {
                bl2 = true;
            } else if (n3 == 43 && bl2) {
                n3 = 32;
            } else if (n3 == 37 && i2 + 2 < n2 && SVNEncodingUtil.isHexDigit(string.charAt(i2 + 1)) && SVNEncodingUtil.isHexDigit(string.charAt(i2 + 2))) {
                n3 = (byte)(SVNEncodingUtil.hexValue(string.charAt(i2 + 1)) * 16 + SVNEncodingUtil.hexValue(string.charAt(i2 + 2)));
                bl3 = true;
                i2 += 2;
            }
            byteArrayOutputStream.write(n3);
        }
        if (!bl3) {
            return string;
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String xmlEncodeCDATA(String string) {
        return SVNEncodingUtil.xmlEncodeCDATA(string, false);
    }

    public static String xmlEncodeCDATA(String string, boolean bl2) {
        StringBuffer stringBuffer = null;
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '&': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\r': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&#13;");
                    continue block7;
                }
                case '\"': {
                    if (bl2) {
                        if (stringBuffer == null) {
                            stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                        }
                        stringBuffer.append("&quot;");
                        continue block7;
                    }
                }
                default: {
                    if (stringBuffer == null) continue block7;
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public static String xmlEncodeAttr(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block10: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '&': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '<': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '\'': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&quot;");
                    continue block10;
                }
                case '\r': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&#13;");
                    continue block10;
                }
                case '\n': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&#10;");
                    continue block10;
                }
                case '\t': {
                    if (stringBuffer == null) {
                        stringBuffer = SVNEncodingUtil.createStringBuffer(string, i2);
                    }
                    stringBuffer.append("&#9;");
                    continue block10;
                }
                default: {
                    if (stringBuffer == null) continue block10;
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public static boolean isXMLSafe(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\b') continue;
            return false;
        }
        return true;
    }

    public static String xmlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                String string2 = null;
                for (int i3 = i2 + 1; i3 < i2 + 6 && i3 < n2; ++i3) {
                    if (string.charAt(i3) != ';' || i3 - i2 <= 1) continue;
                    String string3 = string.substring(i2, i3 + 1);
                    string2 = (String)XML_UNESCAPE_MAP.get(string3);
                    if (string2 == null) break;
                    stringBuffer.append(string2);
                    i2 = i3;
                    break;
                }
                if (string2 != null) continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String fuzzyEscape(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = SVNEncodingUtil.createStringBuffer(string, 0);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!SVNEncodingUtil.isASCIIControlChar(cArray[i2]) || cArray[i2] == '\r' || cArray[i2] == '\n' || cArray[i2] == '\t') {
                stringBuffer.append(cArray[i2]);
                continue;
            }
            stringBuffer.append("?\\");
            int n2 = cArray[i2] & 0xFF;
            if (n2 < 100) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public static boolean isHexDigit(char c2) {
        return Character.isDigit(c2) || Character.toUpperCase(c2) >= 'A' && Character.toUpperCase(c2) <= 'F';
    }

    public static boolean isASCIIControlChar(char c2) {
        return c2 >= '\u0000' && c2 <= '\u001f' || c2 == '\u007f';
    }

    private static int hexValue(char c2) {
        if (Character.isDigit(c2)) {
            return c2 - 48;
        }
        c2 = Character.toUpperCase(c2);
        return c2 - 65 + 10;
    }

    private static StringBuffer createStringBuffer(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string.toCharArray(), 0, n2);
        return stringBuffer;
    }

    public static byte[] getBytes(char[] cArray, String string) {
        Charset charset;
        if (cArray == null) {
            return new byte[0];
        }
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            charset = Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            charset = Charset.defaultCharset();
        }
        try {
            ByteBuffer byteBuffer = charset.newEncoder().encode(charBuffer);
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            if (byteBuffer.hasArray()) {
                SVNEncodingUtil.clearArray(byteBuffer.array());
            }
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            byte[] byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)(cArray[i2] & 0xFF);
            }
            return byArray;
        }
    }

    public static char[] copyOf(char[] cArray) {
        char[] cArray2;
        char[] cArray3 = cArray2 = cArray != null ? new char[cArray.length] : null;
        if (cArray2 != null) {
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        }
        return cArray2;
    }

    public static char[] getChars(byte[] byArray, String string) {
        return SVNEncodingUtil.getChars(byArray, 0, byArray != null ? byArray.length : 0, string);
    }

    public static char[] getChars(byte[] byArray, int n2, int n3, String string) {
        Charset charset;
        if (byArray == null) {
            return new char[0];
        }
        try {
            charset = Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            charset = Charset.defaultCharset();
        }
        try {
            CharBuffer charBuffer = charset.newDecoder().decode(ByteBuffer.wrap(byArray, n2, n3));
            char[] cArray = new char[charBuffer.limit()];
            charBuffer.get(cArray);
            return cArray;
        }
        catch (CharacterCodingException characterCodingException) {
            char[] cArray = new char[byArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = (char)byArray[i2];
            }
            return cArray;
        }
    }

    public static void clearArray(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = 0;
        }
        Arrays.fill(byArray, (byte)-1);
    }

    public static void clearArray(char[] cArray) {
        if (cArray == null) {
            return;
        }
        Arrays.fill(cArray, '\u0000');
    }

    static {
        XML_UNESCAPE_MAP.put("&amp;", "&");
        XML_UNESCAPE_MAP.put("&lt;", "<");
        XML_UNESCAPE_MAP.put("&gt;", ">");
        XML_UNESCAPE_MAP.put("&quot;", "\"");
        XML_UNESCAPE_MAP.put("&apos;", "'");
        XML_UNESCAPE_MAP.put("&#13;", "\r");
        XML_UNESCAPE_MAP.put("&#10;", "\n");
        XML_UNESCAPE_MAP.put("&#9;", "\t");
        uri_char_validity = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

