/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.util.SVNFLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDoubleLock {
    private static boolean ourUseDoubleLock = Boolean.valueOf(System.getProperty("svnkit.useDoubleLock", Boolean.valueOf(SVNFileUtil.isLinux).toString()));
    private SVNFLock flock;
    private RandomAccessFile randomAccessFile;
    private FileLock posixLock;
    private final File file;
    private final boolean exclusive;
    private boolean valid;

    public static SVNDoubleLock obtain(File file, boolean bl2) {
        SVNFLock sVNFLock = ourUseDoubleLock ? SVNDoubleLock.obtainFlockIfNeeded(file, bl2) : null;
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = randomAccessFile.getChannel().lock(0L, Long.MAX_VALUE, !bl2);
        }
        catch (IOException iOException) {
            if (sVNFLock != null) {
                sVNFLock.release();
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        return new SVNDoubleLock(sVNFLock, randomAccessFile, fileLock, file, bl2);
    }

    private SVNDoubleLock(SVNFLock sVNFLock, RandomAccessFile randomAccessFile, FileLock fileLock, File file, boolean bl2) {
        this.flock = sVNFLock;
        this.randomAccessFile = randomAccessFile;
        this.posixLock = fileLock;
        this.file = file;
        this.exclusive = bl2;
        this.valid = true;
    }

    public void release() {
        try {
            if (this.posixLock != null) {
                this.posixLock.release();
                this.posixLock = null;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            if (this.flock != null) {
                this.flock.release();
                this.flock = null;
            }
            this.valid = false;
        }
        catch (IOException iOException) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, iOException, Level.INFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNFLock obtainFlockIfNeeded(File file, boolean bl2) {
        File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), file.getName(), ".trylock", true);
        try {
            boolean bl3 = SVNDoubleLock.isDoubleLockingNeeded(file2, bl2);
            SVNFLock sVNFLock = bl3 ? SVNFLock.obtain(file, bl2) : null;
            return sVNFLock;
        }
        finally {
            SVNFileUtil.deleteFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDoubleLockingNeeded(File file, boolean bl2) {
        SVNFLock sVNFLock = SVNFLock.obtain(file, bl2);
        if (sVNFLock == null) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            boolean bl3;
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileLock fileLock = randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, !bl2);
            boolean bl4 = bl3 = fileLock != null;
            if (fileLock != null) {
                fileLock.release();
            }
            boolean bl5 = bl3;
            return bl5;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
            boolean bl6 = false;
            return bl6;
        }
        finally {
            if (randomAccessFile != null) {
                SVNFileUtil.closeFile(randomAccessFile);
            }
            sVNFLock.release();
        }
    }

    public String toString() {
        if (!this.valid) {
            return "SVNDoubleLock{file=" + this.file + ", valid = false, exclusive=" + this.exclusive + "}";
        }
        return "SVNDoubleLock{" + (this.flock != null ? "flock=" + this.flock : "flock is not supported") + ", posixLock=" + this.posixLock + '}';
    }
}

