/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDate
extends Date {
    private static final long serialVersionUID = 4845L;
    public static final SVNDate NULL = new SVNDate(0L, 0);
    private static final Calendar CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("GMT"), new Locale("en", "US"));
    static final DateFormat SVN_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");
    private static final DateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private static final DateFormat CUSTOM_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z (EE, d MMM yyyy)", Locale.getDefault());
    private static final DateFormat HUMAN_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");
    private static final DateFormat SHORT_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'");
    private static final DateFormat CONSOLE_DIFF_DATE_FORMAT = new SimpleDateFormat("EEE' 'MMM' 'dd' 'HH:mm:ss' 'yyyy");
    private static final DateFormat CONSOLE_LONG_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'yyyy");
    private static final DateFormat CONSOLE_SHORT_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'HH:mm");
    public static final char[] DATE_SEPARATORS = new char[]{'-', '-', 'T', ':', ':', '.', 'Z'};
    private int myMicroSeconds;

    public SVNDate(long l2, int n2) {
        super((1000L * l2 + (long)n2) / 1000L);
        this.myMicroSeconds = n2 >= 0 ? n2 % 1000 : 1000 + n2 % 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format() {
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = SVN_FORMAT;
        synchronized (dateFormat) {
            SVN_FORMAT.format(this, stringBuffer, new FieldPosition(0));
        }
        int n2 = this.myMicroSeconds % 10;
        int n3 = this.myMicroSeconds / 10 % 10;
        int n4 = this.myMicroSeconds / 100;
        stringBuffer.append(n4);
        stringBuffer.append(n3);
        stringBuffer.append(n2);
        stringBuffer.append('Z');
        return stringBuffer.toString();
    }

    public static String formatDate(Date date) {
        return SVNDate.formatDate(date, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, boolean bl2) {
        if (date == null) {
            return null;
        }
        if (!bl2 && date.getTime() == 0L) {
            return null;
        }
        if (date instanceof SVNDate) {
            SVNDate sVNDate = (SVNDate)date;
            return sVNDate.format();
        }
        DateFormat dateFormat = ISO8601_FORMAT;
        synchronized (dateFormat) {
            return ISO8601_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatRFC1123Date(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = RFC1123_FORMAT;
        synchronized (dateFormat) {
            return RFC1123_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHumanDate(Date date, ISVNOptions iSVNOptions) {
        DateFormat dateFormat = HUMAN_FORMAT;
        if (iSVNOptions != null && iSVNOptions.getKeywordDateFormat() != null) {
            dateFormat = iSVNOptions.getKeywordDateFormat();
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            return dateFormat.format(date != null ? date : NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatShortDate(Date date) {
        DateFormat dateFormat = SHORT_FORMAT;
        synchronized (dateFormat) {
            return SHORT_FORMAT.format(date != null ? date : NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatCustomDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CUSTOM_FORMAT;
        synchronized (dateFormat) {
            return CUSTOM_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleDiffDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_DIFF_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_DIFF_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleLongDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_LONG_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_LONG_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatConsoleShortDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = CONSOLE_SHORT_DATE_FORMAT;
        synchronized (dateFormat) {
            return CONSOLE_SHORT_DATE_FORMAT.format(date);
        }
    }

    public static SVNDate parseDate(String string) {
        if (string == null) {
            return NULL;
        }
        try {
            return SVNDate.parseDatestamp(string);
        }
        catch (Throwable throwable) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, throwable);
            return NULL;
        }
    }

    public static Date parseDateString(String string) {
        try {
            return SVNDate.parseDatestamp(string);
        }
        catch (SVNException sVNException) {
            throw sVNException;
        }
        catch (Throwable throwable) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error(sVNErrorMessage, throwable, SVNLogType.DEFAULT);
            return NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVNDate parseDatestamp(String string) {
        String string2;
        if (string == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_DATE);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[7];
        int n4 = 0;
        int n5 = -1;
        for (int i2 = 0; n2 < DATE_SEPARATORS.length && i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '-') {
                if (n2 > 1) {
                    n5 = i2;
                }
            } else if (string.charAt(i2) == '+') {
                n5 = i2;
            }
            if (string.charAt(i2) != DATE_SEPARATORS[n2] && (n2 != 5 || string.charAt(i2) != DATE_SEPARATORS[n2 + 1])) continue;
            if (n2 == 5 && string.charAt(i2) == DATE_SEPARATORS[n2 + 1]) {
                ++n2;
            }
            if ((string2 = string.substring(n3, i2)).length() == 0) {
                nArray[n2] = 0;
            } else if (n2 + 1 < DATE_SEPARATORS.length) {
                nArray[n2] = Integer.parseInt(string2);
            } else {
                nArray[n2] = Integer.parseInt(string2.substring(0, Math.min(3, string2.length())));
                if (string2.length() > 3) {
                    n4 = Integer.parseInt(string2.substring(3));
                }
            }
            n3 = i2 + 1;
            ++n2;
        }
        if (n2 < DATE_SEPARATORS.length) {
            string2 = string.substring(n3);
            nArray[n2] = string2.length() == 0 ? 0 : Integer.parseInt(string2);
        }
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = nArray[2];
        int n9 = nArray[3];
        int n10 = nArray[4];
        int n11 = nArray[5];
        int n12 = nArray[6];
        String string3 = null;
        if (n5 != -1 && n5 < string.length() - 1 && string.indexOf(90) == -1 && string.indexOf(122) == -1) {
            string3 = "GMT" + string.substring(n5);
        }
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            TimeZone timeZone = null;
            if (string3 != null) {
                timeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getTimeZone(string3));
            } else if (string.indexOf(90) == -1 && string.indexOf(122) == -1) {
                timeZone = CALENDAR.getTimeZone();
                CALENDAR.setTimeZone(TimeZone.getDefault());
            }
            CALENDAR.set(n6, n7 - 1, n8, n9, n10, n11);
            CALENDAR.set(14, n12);
            SVNDate sVNDate = new SVNDate(CALENDAR.getTimeInMillis(), n4);
            if (timeZone != null) {
                CALENDAR.setTimeZone(timeZone);
            }
            return sVNDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDateAsMilliseconds(String string) {
        if (string == null) {
            return -1L;
        }
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[7];
        for (int i2 = 0; n2 < DATE_SEPARATORS.length && i2 < string.length(); ++i2) {
            if (string.charAt(i2) != DATE_SEPARATORS[n2]) continue;
            String string2 = string.substring(n3, i2);
            if (string2.length() == 0) {
                nArray[n2] = 0;
            } else {
                if (n2 + 1 < DATE_SEPARATORS.length) {
                    try {
                        nArray[n2] = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return -1L;
                    }
                }
                try {
                    nArray[n2] = Integer.parseInt(string2.substring(0, Math.min(3, string2.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    return -1L;
                }
            }
            n3 = i2 + 1;
            ++n2;
        }
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = nArray[4];
        int n9 = nArray[5];
        int n10 = nArray[6];
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.clear();
            CALENDAR.set(n4, n5 - 1, n6, n7, n8, n9);
            CALENDAR.set(14, n10);
            return CALENDAR.getTimeInMillis();
        }
    }

    public static SVNDate fromDate(Date date) {
        if (date == null) {
            return NULL;
        }
        if (date instanceof SVNDate) {
            return (SVNDate)date;
        }
        return new SVNDate(date.getTime(), 0);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myMicroSeconds;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SVNDate) {
            SVNDate sVNDate = (SVNDate)object;
            return this.getTime() == sVNDate.getTime() && this.myMicroSeconds == sVNDate.myMicroSeconds;
        }
        return super.equals(object);
    }

    @Override
    public boolean before(Date date) {
        if (super.equals(date) && date instanceof SVNDate) {
            return this.myMicroSeconds < ((SVNDate)date).myMicroSeconds;
        }
        return super.before(date);
    }

    @Override
    public boolean after(Date date) {
        if (super.equals(date) && date instanceof SVNDate) {
            return this.myMicroSeconds > ((SVNDate)date).myMicroSeconds;
        }
        return super.after(date);
    }

    @Override
    public int compareTo(Date date) {
        int n2 = super.compareTo(date);
        if (n2 == 0 && date instanceof SVNDate) {
            SVNDate sVNDate = (SVNDate)date;
            return this.myMicroSeconds < sVNDate.myMicroSeconds ? -1 : (this.myMicroSeconds == sVNDate.myMicroSeconds ? 0 : 1);
        }
        return n2;
    }

    public long getTimeInMicros() {
        return 1000L * this.getTime() + (long)this.myMicroSeconds;
    }

    static {
        SVN_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        ISO8601_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        RFC1123_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HUMAN_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        SHORT_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        CUSTOM_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

