/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNCharsetConvertor;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;

public class SVNCharsetOutputStream
extends FilterOutputStream {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private SVNCharsetConvertor myCharsetConvertor;
    private ByteBuffer myOutputBuffer;
    private boolean myFlushed;

    public SVNCharsetOutputStream(OutputStream outputStream, Charset charset, Charset charset2, CodingErrorAction codingErrorAction, CodingErrorAction codingErrorAction2) {
        super(outputStream);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(codingErrorAction);
        charsetDecoder.onUnmappableCharacter(codingErrorAction2);
        CharsetEncoder charsetEncoder = charset2.newEncoder();
        charsetEncoder.onMalformedInput(codingErrorAction);
        charsetEncoder.onUnmappableCharacter(codingErrorAction2);
        this.myCharsetConvertor = new SVNCharsetConvertor(charsetDecoder, charsetEncoder);
        this.myFlushed = false;
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)(n2 & 0xFF)});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        try {
            this.myOutputBuffer = this.myCharsetConvertor.convertChunk(byArray, n2, n3, this.myOutputBuffer, false);
            this.myOutputBuffer.flip();
            this.out.write(this.myOutputBuffer.array(), this.myOutputBuffer.arrayOffset(), this.myOutputBuffer.limit());
        }
        catch (SVNException sVNException) {
            throw new IOExceptionWrapper(sVNException);
        }
    }

    @Override
    public void flush() {
        if (!this.myFlushed) {
            try {
                this.myOutputBuffer = this.myCharsetConvertor.convertChunk(EMPTY_ARRAY, 0, 0, this.myOutputBuffer, true);
                this.myOutputBuffer = this.myCharsetConvertor.flush(this.myOutputBuffer);
                this.myOutputBuffer.flip();
                this.out.write(this.myOutputBuffer.array(), this.myOutputBuffer.arrayOffset(), this.myOutputBuffer.limit());
            }
            catch (SVNException sVNException) {
                throw new IOExceptionWrapper(sVNException);
            }
            finally {
                this.myFlushed = true;
            }
        }
        super.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.out.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SVNCharsetOutputStream");
        stringBuffer.append("[").append(this.myCharsetConvertor);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

