/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNCharsetConvertor;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;

public class SVNCharsetInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private SVNCharsetConvertor myCharsetConvertor;
    private byte[] mySourceBuffer;
    private ByteBuffer myConvertedBuffer;
    private boolean myEndOfStream;

    public SVNCharsetInputStream(InputStream inputStream, Charset charset, Charset charset2, CodingErrorAction codingErrorAction, CodingErrorAction codingErrorAction2) {
        super(inputStream);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(codingErrorAction);
        charsetDecoder.onUnmappableCharacter(codingErrorAction2);
        CharsetEncoder charsetEncoder = charset2.newEncoder();
        charsetEncoder.onMalformedInput(codingErrorAction);
        charsetEncoder.onUnmappableCharacter(codingErrorAction2);
        this.myCharsetConvertor = new SVNCharsetConvertor(charsetDecoder, charsetEncoder);
        this.mySourceBuffer = new byte[1024];
        this.myConvertedBuffer = ByteBuffer.allocate(1024);
        this.myEndOfStream = false;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 < 0) {
            return -1;
        }
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.myConvertedBuffer.position();
        if (this.myEndOfStream && n4 == 0) {
            return -1;
        }
        while (n4 < n3) {
            int n5 = this.fillBuffer();
            try {
                this.myConvertedBuffer = this.myCharsetConvertor.convertChunk(this.mySourceBuffer, 0, n5, this.myConvertedBuffer, this.myEndOfStream);
                if (!this.myEndOfStream) continue;
                this.myConvertedBuffer = this.myCharsetConvertor.flush(this.myConvertedBuffer);
                break;
            }
            catch (SVNException sVNException) {
                throw new IOExceptionWrapper(sVNException);
            }
            finally {
                n4 = this.myConvertedBuffer.position();
            }
        }
        this.myConvertedBuffer.flip();
        n3 = Math.min(this.myConvertedBuffer.remaining(), n3);
        this.myConvertedBuffer = this.myConvertedBuffer.get(byArray, n2, n3);
        this.myConvertedBuffer = this.myConvertedBuffer.compact();
        return n3;
    }

    private int fillBuffer() {
        int n2;
        int n3;
        for (n2 = 0; n2 < this.mySourceBuffer.length; n2 += n3) {
            n3 = this.in.read(this.mySourceBuffer, n2, this.mySourceBuffer.length - n2);
            if (n3 >= 0) continue;
            this.myEndOfStream = true;
            break;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SVNCharsetInputStream");
        stringBuffer.append("[").append(this.myCharsetConvertor);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

