/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCharsetConvertor {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private CharsetDecoder myDecoder;
    private CharsetEncoder myEncoder;
    private CharBuffer myCharBuffer;
    private ByteBuffer myInputByteBuffer;

    public SVNCharsetConvertor(CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder) {
        this.myDecoder = charsetDecoder;
        this.myEncoder = charsetEncoder;
        this.reset();
    }

    public SVNCharsetConvertor reset() {
        this.myEncoder = this.myEncoder.reset();
        this.myDecoder = this.myDecoder.reset();
        this.myCharBuffer = null;
        this.myInputByteBuffer = null;
        return this;
    }

    public ByteBuffer convertChunk(byte[] byArray, int n2, int n3, ByteBuffer byteBuffer, boolean bl2) {
        this.myInputByteBuffer = SVNCharsetConvertor.allocate(this.myInputByteBuffer, n3);
        this.myInputByteBuffer.put(byArray, n2, n3);
        this.myInputByteBuffer.flip();
        this.myCharBuffer = SVNCharsetConvertor.allocate(this.myCharBuffer, (int)(this.myDecoder.maxCharsPerByte() * (float)this.myInputByteBuffer.remaining()));
        CoderResult coderResult = this.myDecoder.decode(this.myInputByteBuffer, this.myCharBuffer, bl2);
        if (coderResult.isError()) {
            SVNCharsetConvertor.throwException(coderResult);
        } else if (coderResult.isUnderflow()) {
            this.myInputByteBuffer.compact();
        } else {
            this.myInputByteBuffer.clear();
        }
        this.myCharBuffer.flip();
        byteBuffer = SVNCharsetConvertor.allocate(byteBuffer, (int)(this.myEncoder.maxBytesPerChar() * (float)this.myCharBuffer.remaining()));
        coderResult = this.myEncoder.encode(this.myCharBuffer, byteBuffer, false);
        if (coderResult.isError()) {
            SVNCharsetConvertor.throwException(coderResult);
        } else if (coderResult.isUnderflow()) {
            this.myCharBuffer.compact();
        } else {
            this.myCharBuffer.clear();
        }
        return byteBuffer;
    }

    public ByteBuffer flush(ByteBuffer byteBuffer) {
        if (this.myCharBuffer != null) {
            CoderResult coderResult;
            do {
                if (!(coderResult = this.myDecoder.flush(this.myCharBuffer)).isError()) continue;
                SVNCharsetConvertor.throwException(coderResult);
            } while (!coderResult.isUnderflow());
            this.myCharBuffer.flip();
            byteBuffer = SVNCharsetConvertor.allocate(byteBuffer, (int)(this.myEncoder.maxBytesPerChar() * (float)this.myCharBuffer.remaining()));
            coderResult = this.myEncoder.encode(this.myCharBuffer, byteBuffer, true);
            if (coderResult.isError()) {
                SVNCharsetConvertor.throwException(coderResult);
            }
            do {
                if (!(coderResult = this.myEncoder.flush(byteBuffer)).isError()) continue;
                SVNCharsetConvertor.throwException(coderResult);
            } while (!coderResult.isUnderflow());
        }
        this.reset();
        return byteBuffer;
    }

    private static ByteBuffer allocate(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            n2 = Math.max(n2 * 3 / 2, 1024);
            return ByteBuffer.allocate(n2);
        }
        if (byteBuffer.remaining() < n2) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate((byteBuffer.position() + n2) * 3 / 2);
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    private static CharBuffer allocate(CharBuffer charBuffer, int n2) {
        if (charBuffer == null) {
            n2 = Math.max(n2 * 3 / 2, 1024);
            return CharBuffer.allocate(n2);
        }
        if (charBuffer.remaining() < n2) {
            CharBuffer charBuffer2 = CharBuffer.allocate((charBuffer.position() + n2) * 3 / 2);
            charBuffer.flip();
            charBuffer2.put(charBuffer);
            return charBuffer2;
        }
        return charBuffer;
    }

    private static void throwException(CoderResult coderResult) {
        try {
            coderResult.throwException();
        }
        catch (CharacterCodingException characterCodingException) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, characterCodingException), characterCodingException, SVNLogType.DEFAULT);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SVNCharsetConvertor");
        stringBuffer.append("[from=").append(this.myDecoder.charset().displayName());
        stringBuffer.append(", to=").append(this.myEncoder.charset().displayName());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

