/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.nio.CharBuffer;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;

public class SVNBase64 {
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] intToAltBase64 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', ',', '-', '.', ':', ';', '<', '>', '@', '[', ']', '^', '`', '_', '{', '|', '}', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '?'};
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] altBase64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 62, 9, 10, 11, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 12, 13, 14, -1, 15, 63, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, 18, 19, 21, 20, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 22, 23, 24, 25};

    public static String byteArrayToBase64(byte[] byArray) {
        return SVNBase64.byteArrayToBase64(byArray, false);
    }

    public static String byteArrayToAltBase64(byte[] byArray) {
        return SVNBase64.byteArrayToBase64(byArray, true);
    }

    private static String byteArrayToBase64(byte[] byArray, boolean bl2) {
        int n2;
        int n3;
        int n4 = byArray.length;
        int n5 = n4 / 3;
        int n6 = n4 - 3 * n5;
        int n7 = 4 * ((n4 + 2) / 3);
        StringBuffer stringBuffer = new StringBuffer(n7);
        char[] cArray = bl2 ? intToAltBase64 : intToBase64;
        int n8 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = byArray[n8++] & 0xFF;
            int n9 = byArray[n8++] & 0xFF;
            int n10 = byArray[n8++] & 0xFF;
            stringBuffer.append(cArray[n2 >> 2]);
            stringBuffer.append(cArray[n2 << 4 & 0x3F | n9 >> 4]);
            stringBuffer.append(cArray[n9 << 2 & 0x3F | n10 >> 6]);
            stringBuffer.append(cArray[n10 & 0x3F]);
        }
        if (n6 != 0) {
            n3 = byArray[n8++] & 0xFF;
            stringBuffer.append(cArray[n3 >> 2]);
            if (n6 == 1) {
                stringBuffer.append(cArray[n3 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n2 = byArray[n8++] & 0xFF;
                stringBuffer.append(cArray[n3 << 4 & 0x3F | n2 >> 4]);
                stringBuffer.append(cArray[n2 << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    public static int base64ToByteArray(StringBuffer stringBuffer, byte[] byArray) {
        try {
            return SVNBase64.base64ToByteArray(stringBuffer, byArray, false);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid SVNBase64 string: " + stringBuffer.toString(), arrayIndexOutOfBoundsException);
        }
    }

    public static int base64ToByteArray(char[] cArray, byte[] byArray) {
        try {
            return SVNBase64.base64ToByteArray(cArray, byArray, false);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid SVNBase64 string: " + cArray.toString(), arrayIndexOutOfBoundsException);
        }
    }

    public static StringBuffer normalizeBase64(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            if (Character.isWhitespace(stringBuffer.charAt(i2))) continue;
            stringBuffer2.append(stringBuffer.charAt(i2));
        }
        return stringBuffer2;
    }

    public static char[] normalizeBase64(char[] cArray) {
        char[] cArray2;
        CharBuffer charBuffer = CharBuffer.allocate(cArray.length);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (Character.isWhitespace(cArray[i2])) continue;
            charBuffer.put(cArray[i2]);
        }
        try {
            if (charBuffer.position() == cArray.length) {
                cArray2 = cArray;
            } else {
                cArray2 = new char[charBuffer.position()];
                charBuffer.flip();
                charBuffer.get(cArray2);
            }
        }
        finally {
            if (charBuffer.hasArray()) {
                SVNEncodingUtil.clearArray(charBuffer.array());
            }
        }
        return cArray2;
    }

    private static int base64ToByteArray(StringBuffer stringBuffer, byte[] byArray, boolean bl2) {
        return SVNBase64.base64ToByteArray(stringBuffer.toString().toCharArray(), byArray, bl2);
    }

    private static int base64ToByteArray(char[] cArray, byte[] byArray, boolean bl2) {
        byte by;
        byte by2;
        int n2;
        byte[] byArray2 = bl2 ? altBase64ToInt : base64ToInt;
        int n3 = cArray.length;
        int n4 = n3 / 4;
        if (4 * n4 != n3) {
            n3 = 4 * ++n4;
        }
        int n5 = 0;
        int n6 = n4;
        if (n3 != 0) {
            if (SVNBase64.charAt(cArray, n3 - 1) == '=') {
                ++n5;
                --n6;
            }
            if (SVNBase64.charAt(cArray, n3 - 2) == '=') {
                ++n5;
            }
        }
        int n7 = 3 * n4 - n5;
        int n8 = 0;
        int n9 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            by2 = byArray2[SVNBase64.charAt(cArray, n8++)];
            by = byArray2[SVNBase64.charAt(cArray, n8++)];
            byte by3 = byArray2[SVNBase64.charAt(cArray, n8++)];
            byte by4 = byArray2[SVNBase64.charAt(cArray, n8++)];
            byArray[n9++] = (byte)(by2 << 2 | by >> 4);
            byArray[n9++] = (byte)(by << 4 | by3 >> 2);
            byArray[n9++] = (byte)(by3 << 6 | by4);
        }
        if (n5 != 0) {
            n2 = byArray2[SVNBase64.charAt(cArray, n8++)];
            by2 = byArray2[SVNBase64.charAt(cArray, n8++)];
            byArray[n9++] = (byte)(n2 << 2 | by2 >> 4);
            if (n5 == 1) {
                by = byArray2[SVNBase64.charAt(cArray, n8++)];
                byArray[n9++] = (byte)(by2 << 4 | by >> 2);
            }
        }
        return n7;
    }

    private static char charAt(char[] cArray, int n2) {
        if (n2 >= cArray.length) {
            return '=';
        }
        return cArray[n2];
    }
}

