/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InputStream;

public class FixedSizeInputStream
extends InputStream {
    private long myLength;
    private InputStream mySource;

    public FixedSizeInputStream(InputStream inputStream, long l2) {
        this.mySource = inputStream;
        this.myLength = l2;
    }

    @Override
    public int read() {
        int n2 = -1;
        if (this.myLength > 0L && (n2 = this.mySource.read()) != -1) {
            --this.myLength;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.myLength <= 0L) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        long l2 = Math.min(this.myLength, (long)n3);
        if ((l2 = (long)this.mySource.read(byArray, n2, (int)l2)) >= 0L) {
            this.myLength -= l2;
        }
        return (int)l2;
    }

    @Override
    public void close() {
        if (this.myLength > 0L) {
            try {
                FixedSizeInputStream.consumeRemaining(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void consumeRemaining(InputStream inputStream) {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) >= 0) {
        }
    }
}

