/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.internal.util.DefaultSVNDebugFormatter;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNDebugLogger
extends SVNDebugLogAdapter {
    private Map myLoggers = new SVNHashMap();
    private Handler myTestHandler;

    @Override
    public void log(SVNLogType sVNLogType, Throwable throwable, Level level) {
        Logger logger = this.getLogger(sVNLogType);
        if (logger.isLoggable(level) && throwable != null) {
            logger.log(level, this.getMessage(sVNLogType, throwable.getMessage()), throwable);
        }
    }

    @Override
    public void log(SVNLogType sVNLogType, String string, Level level) {
        Logger logger = this.getLogger(sVNLogType);
        if (logger.isLoggable(level) && string != null) {
            logger.log(level, this.getMessage(sVNLogType, string));
        }
    }

    @Override
    public void log(SVNLogType sVNLogType, String string, byte[] byArray) {
        Logger logger = this.getLogger(sVNLogType);
        if (logger.isLoggable(Level.FINEST)) {
            try {
                logger.log(Level.FINEST, string + "\n" + new String(byArray, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.log(Level.FINEST, string + "\n" + new String(byArray));
            }
        }
    }

    @Override
    public InputStream createLogStream(SVNLogType sVNLogType, InputStream inputStream) {
        if (this.getLogger(sVNLogType).isLoggable(Level.FINEST)) {
            return super.createLogStream(sVNLogType, inputStream);
        }
        return inputStream;
    }

    @Override
    public OutputStream createLogStream(SVNLogType sVNLogType, OutputStream outputStream) {
        if (this.getLogger(sVNLogType).isLoggable(Level.FINEST)) {
            return super.createLogStream(sVNLogType, outputStream);
        }
        return outputStream;
    }

    private Logger getLogger(SVNLogType sVNLogType) {
        Logger logger = (Logger)this.myLoggers.get(sVNLogType);
        if (logger == null) {
            logger = Logger.getLogger(sVNLogType.getName());
            String string = SVNFileUtil.getEnvironmentVariable("SVN_CURRENT_TEST");
            if (string != null) {
                if (this.myTestHandler == null) {
                    try {
                        this.myTestHandler = DefaultSVNDebugLogger.createTestLogger(string);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.myTestHandler != null) {
                    Handler[] handlerArray = logger.getHandlers();
                    for (int i2 = 0; i2 < handlerArray.length; ++i2) {
                        logger.removeHandler(handlerArray[i2]);
                    }
                    logger.addHandler(this.myTestHandler);
                }
            }
            this.myLoggers.put(sVNLogType, logger);
        }
        return logger;
    }

    private String getMessage(SVNLogType sVNLogType, String string) {
        return sVNLogType.getShortName() + ": " + string;
    }

    private static Handler createTestLogger(String string) {
        URL uRL = DefaultSVNDebugLogger.class.getProtectionDomain().getCodeSource().getLocation();
        File file = new File(uRL.getPath()).getParentFile();
        File file2 = new File(file, "../logs/" + string.trim() + ".log");
        FileHandler fileHandler = new FileHandler(file2.getAbsolutePath(), 0, 1, true);
        fileHandler.setLevel(Level.FINEST);
        fileHandler.setFormatter(new DefaultSVNDebugFormatter());
        return fileHandler;
    }
}

