/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class ChunkedInputStream
extends InputStream {
    private String myCharset;
    private InputStream myInputStream;
    private int myChunkSize;
    private int myPosition;
    private boolean myIsBOF = true;
    private boolean myIsEOF = false;
    private boolean myIsClosed = false;

    public ChunkedInputStream(InputStream inputStream, String string) {
        this.myInputStream = inputStream;
        this.myPosition = 0;
        this.myCharset = string;
    }

    @Override
    public int read() {
        if (this.myIsClosed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.myIsEOF) {
            return -1;
        }
        if (this.myPosition >= this.myChunkSize) {
            this.nextChunk();
            if (this.myIsEOF) {
                return -1;
            }
        }
        ++this.myPosition;
        return this.myInputStream.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.myIsClosed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.myIsEOF) {
            return -1;
        }
        if (this.myPosition >= this.myChunkSize) {
            this.nextChunk();
            if (this.myIsEOF) {
                return -1;
            }
        }
        n3 = Math.min(n3, this.myChunkSize - this.myPosition);
        int n4 = this.myInputStream.read(byArray, n2, n3);
        this.myPosition += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    private void readCRLF() {
        int n2 = this.myInputStream.read();
        int n3 = this.myInputStream.read();
        if (n2 != 13 || n3 != 10) {
            throw new IOException("CRLF expected at end of chunk: " + n2 + "/" + n3);
        }
    }

    private void nextChunk() {
        if (!this.myIsBOF) {
            this.readCRLF();
        }
        this.myChunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.myInputStream, this.myCharset);
        this.myIsBOF = false;
        this.myPosition = 0;
        if (this.myChunkSize == 0) {
            this.myIsEOF = true;
        }
    }

    private static int getChunkSizeFromInputStream(InputStream inputStream, String string) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        block17: while (n3 != -1) {
            int n4 = inputStream.read();
            if (n4 == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            switch (n3) {
                case 0: {
                    switch (n4) {
                        case 13: {
                            n3 = 1;
                            continue block17;
                        }
                        case 34: {
                            n3 = 2;
                        }
                    }
                    byteArrayOutputStream.write(n4);
                    continue block17;
                }
                case 1: {
                    if (n4 == 10) {
                        n3 = -1;
                        continue block17;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (n4) {
                        case 92: {
                            n4 = inputStream.read();
                            byteArrayOutputStream.write(n4);
                            continue block17;
                        }
                        case 34: {
                            n3 = 0;
                        }
                    }
                    byteArrayOutputStream.write(n4);
                    continue block17;
                }
            }
            try {
                SVNErrorManager.assertionFailure(false, null, SVNLogType.NETWORK);
            }
            catch (SVNException sVNException) {
                throw new IOExceptionWrapper(sVNException);
            }
        }
        String string2 = new String(byteArrayOutputStream.toByteArray(), string);
        int n5 = string2.indexOf(59);
        string2 = n5 > 0 ? string2.substring(0, n5).trim() : string2.trim();
        try {
            n2 = Integer.parseInt(string2.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad chunk size: " + string2);
        }
        return n2;
    }

    @Override
    public void close() {
        if (!this.myIsClosed) {
            try {
                if (!this.myIsEOF) {
                    FixedSizeInputStream.consumeRemaining(this);
                }
            }
            finally {
                this.myIsEOF = true;
                this.myIsClosed = true;
            }
        }
    }
}

