/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class BufferedRandomAccessFile {
    private final RandomAccessFile randomAccessFile;
    private final byte[] buffer;
    private int bufferSize;
    private long bufferPointer;
    private long filePointer;

    public BufferedRandomAccessFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, 32768);
    }

    public BufferedRandomAccessFile(RandomAccessFile randomAccessFile, int n2) {
        this.randomAccessFile = randomAccessFile;
        this.buffer = new byte[n2];
        this.bufferSize = 0;
        this.bufferPointer = 0L;
        this.filePointer = 0L;
    }

    public void loadPosition() {
        this.filePointer = this.randomAccessFile.getFilePointer();
    }

    public void savePosition() {
        this.randomAccessFile.seek(this.filePointer);
    }

    public FileDescriptor getFD() {
        return this.randomAccessFile.getFD();
    }

    public FileChannel getChannel() {
        return this.randomAccessFile.getChannel();
    }

    public int read() {
        long l2 = this.getFilePointer();
        if (l2 >= this.bufferPointer && l2 < this.bufferPointer + (long)this.bufferSize) {
            int n2 = (int)(l2 - this.bufferPointer);
            this.seek(l2 + 1L);
            return this.buffer[n2] & 0xFF;
        }
        this.bufferSize = 0;
        this.bufferPointer = l2;
        this.randomAccessFile.seek(this.getFilePointer());
        int n3 = this.randomAccessFile.read(this.buffer);
        if (n3 < 0) {
            return -1;
        }
        this.seek(l2 + 1L);
        this.bufferSize = n3;
        return this.buffer[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) {
        long l2;
        long l3 = this.getFilePointer();
        long l4 = Math.max(l3, this.bufferPointer);
        if (l4 < (l2 = Math.min(l3 + l4, this.bufferPointer + (long)this.bufferSize))) {
            int n4;
            if (l3 < l4) {
                this.randomAccessFile.seek(this.getFilePointer());
                n4 = this.randomAccessFile.read(byArray, n2, (int)(l4 - l3));
                if (n4 < 0) {
                    return n4;
                }
            }
            System.arraycopy(this.buffer, (int)(l4 - this.bufferPointer), byArray, n2 + (int)(l4 - l3), (int)(l2 - l4));
            if (l3 + (long)n3 > l2) {
                this.randomAccessFile.seek(l2);
                n4 = this.randomAccessFile.read(this.buffer, 0, this.buffer.length);
                if (n4 < 0) {
                    this.bufferSize = 0;
                    this.seek(l2);
                    return (int)(l2 - l3);
                }
                this.bufferSize = n4;
                int n5 = (int)Math.min((long)n4, l3 + (long)n3 - l2);
                System.arraycopy(this.buffer, 0, byArray, n2 + (int)(l2 - l3), n5);
                this.seek(l2 + (long)n5);
                return (int)(l2 - l3 + (long)n5);
            }
            this.seek(l2);
            return (int)(l2 - l3);
        }
        this.randomAccessFile.seek(this.getFilePointer());
        int n6 = this.randomAccessFile.read(byArray, n2, n3);
        if (n6 >= 0) {
            this.seek(this.getFilePointer() + (long)n6);
        }
        return n6;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    public void seek(long l2) {
        this.filePointer = l2;
    }
}

