/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.trilead;

import com.trilead.ssh2.Session;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshConnection;

public class TrileadSshSession
implements SshSession {
    private SshConnection myOwner;
    private Session mySession;

    public TrileadSshSession(SshConnection sshConnection, Session session) {
        this.mySession = session;
        this.myOwner = sshConnection;
    }

    @Override
    public void close() {
        this.mySession.close();
        this.waitForCondition(2, 0L);
        this.myOwner.sessionClosed(this);
    }

    @Override
    public InputStream getOut() {
        return this.mySession.getStdout();
    }

    @Override
    public InputStream getErr() {
        return this.mySession.getStderr();
    }

    @Override
    public OutputStream getIn() {
        return this.mySession.getStdin();
    }

    public Integer getExitCode() {
        return this.mySession.getExitStatus();
    }

    public String getExitSignal() {
        return this.mySession.getExitSignal();
    }

    @Override
    public void waitForCondition(int n2, long l2) {
        this.mySession.waitForCondition(n2, l2);
    }

    @Override
    public void execCommand(String string) {
        this.mySession.execCommand(string);
    }

    @Override
    public void ping() {
        this.mySession.ping();
    }
}

