/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.trilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.auth.AgentProxy;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshAuthenticationException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshConnection;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHost$1;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHost$2;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHostDisposedException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.TrileadSshSession;

public class SshHost {
    private static final int CONNECTION_INACTIVITY_TIMEOUT = Integer.parseInt(System.getProperty("svnkit.ssh.connection.inactivity.timeout.secs", "600")) * 1000;
    private static final int MAX_CONCURRENT_OPENERS = Integer.parseInt(System.getProperty("svnkit.ssh.max.concurrent.connection.openers", "3"));
    private static final int MAX_SESSIONS_PER_CONNECTION = Integer.parseInt(System.getProperty("svnkit.ssh.max.sessions.per.connection", "8"));
    private String myHost;
    private int myPort;
    private ServerHostKeyVerifier myHostVerifier;
    private char[] myPrivateKey;
    private char[] myPassphrase;
    private char[] myPassword;
    private String myUserName;
    private AgentProxy myAgentProxy;
    private int myConnectTimeout;
    private boolean myIsLocked;
    private boolean myIsDisposed;
    private List myConnections;
    private Object myOpenerLock = new Object();
    private int myOpenersCount;
    private int myReadTimeout;

    public SshHost(String string, int n2) {
        this.myConnections = new LinkedList();
        this.myHost = string;
        this.myPort = n2;
    }

    public void setHostVerifier(ServerHostKeyVerifier serverHostKeyVerifier) {
        this.myHostVerifier = serverHostKeyVerifier;
    }

    public void setConnectionTimeout(int n2) {
        this.myConnectTimeout = n2;
    }

    public void setReadTimeout(int n2) {
        this.myReadTimeout = n2;
    }

    public void setCredentials(String string, char[] cArray, char[] cArray2, char[] cArray3, AgentProxy agentProxy) {
        this.myUserName = string;
        this.myPrivateKey = cArray;
        this.myPassphrase = cArray2;
        this.myPassword = cArray3;
        this.myAgentProxy = agentProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purge() {
        try {
            this.lock();
            int n2 = this.myConnections.size();
            long l2 = System.currentTimeMillis();
            Iterator iterator = this.myConnections.iterator();
            while (iterator.hasNext()) {
                SshConnection sshConnection = (SshConnection)iterator.next();
                if (sshConnection.getSessionsCount() != 0) continue;
                if (this.myConnections.size() == 1) {
                    long l3 = l2 - sshConnection.lastAcccessTime();
                    if (l3 < (long)CONNECTION_INACTIVITY_TIMEOUT) continue;
                    sshConnection.close();
                    iterator.remove();
                    continue;
                }
                sshConnection.close();
                iterator.remove();
            }
            if (this.myConnections.size() == 0 && n2 > 0) {
                this.setDisposed(true);
            }
            boolean bl2 = this.isDisposed();
            return bl2;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void setDisposed(boolean bl2) {
        this.myIsDisposed = bl2;
        if (bl2) {
            for (SshConnection sshConnection : this.myConnections) {
                sshConnection.close();
            }
            this.myConnections.clear();
        }
    }

    public String getKey() {
        String string = this.myUserName + ":" + this.myHost + ":" + this.myPort;
        if (this.myPrivateKey != null) {
            string = string + ":" + new String(this.myPrivateKey);
        }
        if (this.myPassphrase != null) {
            string = string + ":" + new String(this.myPassphrase);
        }
        if (this.myPassword != null) {
            string = string + ":" + new String(this.myPassword);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        List list = this.myConnections;
        synchronized (list) {
            while (this.myIsLocked) {
                try {
                    this.myConnections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myIsLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        List list = this.myConnections;
        synchronized (list) {
            this.myIsLocked = false;
            this.myConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrileadSshSession openSession() {
        TrileadSshSession trileadSshSession = this.useExistingConnection();
        if (trileadSshSession != null) {
            return trileadSshSession;
        }
        SshConnection sshConnection = null;
        this.addOpener();
        try {
            trileadSshSession = this.useExistingConnection();
            if (trileadSshSession != null) {
                TrileadSshSession trileadSshSession2 = trileadSshSession;
                return trileadSshSession2;
            }
            sshConnection = this.openConnection();
        }
        finally {
            this.removeOpener();
        }
        if (sshConnection != null) {
            this.lock();
            try {
                if (this.isDisposed()) {
                    sshConnection.close();
                    throw new SshHostDisposedException();
                }
                this.myConnections.add(sshConnection);
                TrileadSshSession trileadSshSession3 = sshConnection.openSession();
                return trileadSshSession3;
            }
            finally {
                this.unlock();
            }
        }
        throw new IOException("Cannot establish SSH connection with " + this.myHost + ":" + this.myPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TrileadSshSession useExistingConnection() {
        this.lock();
        try {
            if (this.isDisposed()) {
                throw new SshHostDisposedException();
            }
            Iterator iterator = this.myConnections.iterator();
            while (iterator.hasNext()) {
                SshConnection sshConnection = (SshConnection)iterator.next();
                if (sshConnection.getSessionsCount() >= MAX_SESSIONS_PER_CONNECTION) continue;
                try {
                    TrileadSshSession trileadSshSession = sshConnection.openSession();
                    return trileadSshSession;
                }
                catch (IOException iOException) {
                    try {
                        if (iOException.getMessage() == null || !iOException.getMessage().contains("connection is closed")) throw iOException;
                        sshConnection.close();
                        iterator.remove();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpener() {
        Object object = this.myOpenerLock;
        synchronized (object) {
            --this.myOpenersCount;
            this.myOpenerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpener() {
        Object object = this.myOpenerLock;
        synchronized (object) {
            while (this.myOpenersCount >= MAX_CONCURRENT_OPENERS) {
                try {
                    this.myOpenerLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.myOpenersCount;
        }
    }

    private SshConnection openConnection() {
        String string;
        Connection connection = new Connection(this.myHost, this.myPort);
        connection.connect(new SshHost$1(this), this.myConnectTimeout, this.myReadTimeout, this.myConnectTimeout);
        boolean bl2 = false;
        String string2 = this.myPassword != null ? new String(this.myPassword) : null;
        String string3 = string = this.myPassphrase != null ? new String(this.myPassphrase) : null;
        if (this.myAgentProxy != null) {
            bl2 = connection.authenticateWithAgent(this.myUserName, this.myAgentProxy);
        }
        if (!bl2 && this.myPrivateKey != null) {
            bl2 = connection.authenticateWithPublicKey(this.myUserName, this.myPrivateKey, string);
        }
        if (!bl2 && this.myPassword != null) {
            String[] stringArray = connection.getRemainingAuthMethods(this.myUserName);
            for (int i2 = 0; !bl2 && i2 < stringArray.length; ++i2) {
                if ("password".equals(stringArray[i2])) {
                    bl2 = connection.authenticateWithPassword(this.myUserName, string2);
                    continue;
                }
                if (!"keyboard-interactive".equals(stringArray[i2])) continue;
                bl2 = connection.authenticateWithKeyboardInteractive(this.myUserName, new SshHost$2(this, string2));
            }
        }
        if (!bl2) {
            connection.close();
            throw new SshAuthenticationException("Credentials rejected by SSH server.");
        }
        return new SshConnection(this, connection);
    }

    public String toString() {
        return this.myHost + ":" + this.myPort;
    }

    static /* synthetic */ ServerHostKeyVerifier access$000(SshHost sshHost) {
        return sshHost.myHostVerifier;
    }
}

