/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.trilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHost;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.TrileadSshSession;

public class SshConnection {
    private Connection myConnection;
    private volatile int mySessionCount;
    private SshHost myHost;
    private long myLastAccessTime;

    public SshConnection(SshHost sshHost, Connection connection) {
        this.myHost = sshHost;
        this.myConnection = connection;
        this.myLastAccessTime = System.currentTimeMillis();
    }

    public TrileadSshSession openSession() {
        Session session = this.myConnection.openSession();
        if (session != null) {
            ++this.mySessionCount;
            return new TrileadSshSession(this, session);
        }
        return null;
    }

    public void sessionClosed(TrileadSshSession trileadSshSession) {
        this.myHost.lock();
        try {
            this.myLastAccessTime = System.currentTimeMillis();
            --this.mySessionCount;
        }
        finally {
            this.myHost.unlock();
        }
    }

    public int getSessionsCount() {
        return this.mySessionCount;
    }

    public void close() {
        this.myConnection.close();
        this.mySessionCount = 0;
    }

    public long lastAcccessTime() {
        return this.myLastAccessTime;
    }
}

