/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.ApacheSshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshConnection;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHostDisposedException;

public class SshHost {
    private static final int CONNECTION_INACTIVITY_TIMEOUT = Integer.parseInt(System.getProperty("svnkit.ssh.connection.inactivity.timeout.secs", "600")) * 1000;
    private static final int MAX_CONCURRENT_OPENERS = Integer.parseInt(System.getProperty("svnkit.ssh.max.concurrent.connection.openers", "3"));
    private static final int MAX_SESSIONS_PER_CONNECTION = Integer.parseInt(System.getProperty("svnkit.ssh.max.sessions.per.connection", "8"));
    private final String hostName;
    private final int port;
    private char[] privateKey;
    private char[] privateKeyPassphrase;
    private char[] password;
    private String userName;
    private int myConnectTimeout;
    private boolean locked;
    private boolean disposed;
    private final List connections = new ArrayList();
    private final Object OPENER_LOCK = new Object();
    private int openersCount;
    private int readTimeout;
    private ISVNSSHHostVerifier hostVerifier;

    public SshHost(String string, int n2) {
        this.hostName = string;
        this.port = n2;
    }

    public void setConnectionTimeout(int n2) {
        this.myConnectTimeout = n2;
    }

    public void setReadTimeout(int n2) {
        this.readTimeout = n2;
    }

    public void setCredentials(String string, char[] cArray, char[] cArray2, char[] cArray3) {
        this.userName = string;
        this.privateKey = cArray;
        this.privateKeyPassphrase = cArray2;
        this.password = cArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purge() {
        try {
            this.lock();
            int n2 = this.connections.size();
            long l2 = System.currentTimeMillis();
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                SshConnection sshConnection = (SshConnection)iterator.next();
                if (sshConnection.getSessionsCount() != 0) continue;
                if (this.connections.size() == 1) {
                    long l3 = l2 - sshConnection.lastAcccessTime();
                    if (l3 < (long)CONNECTION_INACTIVITY_TIMEOUT) continue;
                    sshConnection.close();
                    iterator.remove();
                    continue;
                }
                sshConnection.close();
                iterator.remove();
            }
            if (this.connections.size() == 0 && n2 > 0) {
                this.setDisposed(true);
            }
            boolean bl2 = this.isDisposed();
            return bl2;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setDisposed(boolean bl2) {
        this.disposed = bl2;
        if (bl2) {
            for (SshConnection sshConnection : this.connections) {
                sshConnection.close();
            }
            this.connections.clear();
        }
    }

    public String getKey() {
        String string = this.userName + ":" + this.hostName + ":" + this.port;
        if (this.privateKey != null) {
            string = string + ":" + new String(this.privateKey);
        }
        if (this.privateKeyPassphrase != null) {
            string = string + ":" + new String(this.privateKeyPassphrase);
        }
        if (this.password != null) {
            string = string + ":" + new String(this.password);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        List list = this.connections;
        synchronized (list) {
            while (this.locked) {
                try {
                    this.connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        List list = this.connections;
        synchronized (list) {
            this.locked = false;
            this.connections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApacheSshSession openSession() {
        ApacheSshSession apacheSshSession = this.useExistingConnection();
        if (apacheSshSession != null) {
            return apacheSshSession;
        }
        SshConnection sshConnection = null;
        this.addOpener();
        try {
            apacheSshSession = this.useExistingConnection();
            if (apacheSshSession != null) {
                ApacheSshSession apacheSshSession2 = apacheSshSession;
                return apacheSshSession2;
            }
            sshConnection = this.openConnection();
        }
        finally {
            this.removeOpener();
        }
        if (sshConnection != null) {
            this.lock();
            try {
                if (this.isDisposed()) {
                    sshConnection.close();
                    throw new SshHostDisposedException();
                }
                this.connections.add(sshConnection);
                ApacheSshSession apacheSshSession3 = sshConnection.openSession();
                return apacheSshSession3;
            }
            finally {
                this.unlock();
            }
        }
        throw new IOException("Cannot establish SSH connection with " + this.hostName + ":" + this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApacheSshSession useExistingConnection() {
        this.lock();
        try {
            if (this.isDisposed()) {
                throw new SshHostDisposedException();
            }
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                SshConnection sshConnection = (SshConnection)iterator.next();
                if (sshConnection.getSessionsCount() >= MAX_SESSIONS_PER_CONNECTION) continue;
                try {
                    ApacheSshSession apacheSshSession = sshConnection.openSession();
                    return apacheSshSession;
                }
                catch (IOException iOException) {
                    try {
                        if (iOException.getMessage() == null || !iOException.getMessage().contains("connection is closed")) throw iOException;
                        sshConnection.close();
                        iterator.remove();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpener() {
        Object object = this.OPENER_LOCK;
        synchronized (object) {
            --this.openersCount;
            this.OPENER_LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpener() {
        Object object = this.OPENER_LOCK;
        synchronized (object) {
            while (this.openersCount >= MAX_CONCURRENT_OPENERS) {
                try {
                    this.OPENER_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.openersCount;
        }
    }

    private SshConnection openConnection() {
        try {
            return new SshConnection(this);
        }
        catch (Exception exception) {
            throw new IOException("Failed to connect to " + this.toString(), exception);
        }
    }

    public String toString() {
        return this.hostName + ":" + this.port;
    }

    public void setHostVerifier(ISVNSSHHostVerifier iSVNSSHHostVerifier) {
        this.hostVerifier = iSVNSSHHostVerifier;
    }

    public ISVNSSHHostVerifier getHostVerifier() {
        return this.hostVerifier;
    }

    public byte[] getPrivateKey() {
        if (this.privateKey != null) {
            return new String(this.privateKey).getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        if (this.password != null) {
            return new String(this.password);
        }
        return null;
    }

    public String getPrivateKeyPassphrase() {
        if (this.privateKeyPassphrase != null) {
            return new String(this.privateKeyPassphrase);
        }
        return null;
    }
}

