/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.DefaultConfigFileHostEntryResolver;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.ApacheSshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHost;

public class SshConnection {
    private static final Logger log = Logger.getLogger(SshConnection.class.getName());
    private final SshClient client;
    private final SshHost host;
    private ClientSession session;
    private long lastAccessTime = System.currentTimeMillis();
    private int sessionCount;

    public SshConnection(SshHost sshHost) {
        Object object;
        this.host = sshHost;
        this.client = SshClient.setUpDefaultClient();
        this.client.setIoServiceFactoryFactory(new Nio2ServiceFactoryFactory());
        byte[] byArray = sshHost.getPrivateKey();
        if (byArray != null) {
            object = SecurityUtils.loadKeyPairIdentities(null, () -> "private key", new ByteArrayInputStream(byArray), FilePasswordProvider.of(sshHost.getPrivateKeyPassphrase()));
            if (!object.iterator().hasNext()) {
                throw new RuntimeException("Did not find a keypair in the provided private key string: " + byArray);
            }
            this.client.addPublicKeyIdentity((KeyPair)object.iterator().next());
        }
        if (sshHost.getPassword() != null) {
            this.client.addPasswordIdentity(sshHost.getPassword());
        }
        this.client.setServerKeyVerifier((clientSession, socketAddress, publicKey) -> {
            try {
                ISVNSSHHostVerifier iSVNSSHHostVerifier = sshHost.getHostVerifier();
                if (iSVNSSHHostVerifier != null) {
                    iSVNSSHHostVerifier.verifyHostKey(sshHost.getHostName(), sshHost.getPort(), publicKey.getAlgorithm(), publicKey.getEncoded());
                }
                return true;
            }
            catch (SVNException sVNException) {
                log.log(Level.SEVERE, "Failed while verifying host key: " + sshHost.toString(), sVNException);
                return false;
            }
        });
        this.client.setHostConfigEntryResolver(DefaultConfigFileHostEntryResolver.INSTANCE);
        try {
            this.client.start();
            object = this.client.connect(sshHost.getUserName(), sshHost.getHostName(), sshHost.getPort());
            object.await();
            this.session = object.getClientSession();
            this.session.auth().verify(10000L);
        }
        catch (Exception exception) {
            this.client.stop();
            this.client.close();
            throw exception;
        }
    }

    public ApacheSshSession openSession() {
        ++this.sessionCount;
        return new ApacheSshSession(this);
    }

    public void sessionClosed(ApacheSshSession apacheSshSession) {
        this.lastAccessTime = System.currentTimeMillis();
        --this.sessionCount;
    }

    public int getSessionsCount() {
        return this.sessionCount;
    }

    public void close() {
        if (this.session != null) {
            this.session.close(false);
            this.session = null;
        }
        this.client.stop();
        this.client.close(false);
        this.sessionCount = 0;
    }

    public long lastAcccessTime() {
        return this.lastAccessTime;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public SshConnection reOpen() {
        try {
            return new SshConnection(this.host);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Failed to reopen connection");
        }
    }
}

