/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;

public class SaslOutputStream
extends OutputStream {
    private OutputStream myOut;
    private SaslClient myClient;
    private byte[] myLengthBuffer = new byte[4];
    private ByteBuffer myBuffer;

    public SaslOutputStream(SaslClient saslClient, int n2, OutputStream outputStream) {
        this.myOut = outputStream;
        this.myClient = saslClient;
        this.myBuffer = ByteBuffer.allocate(n2);
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)(n2 & 0xFF)});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = Math.min(this.myBuffer.remaining(), n3);
            this.myBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            if (this.myBuffer.remaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.myOut.close();
    }

    @Override
    public void flush() {
        byte[] byArray = this.myBuffer.array();
        int n2 = this.myBuffer.arrayOffset();
        int n3 = this.myBuffer.position();
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = this.myClient.wrap(byArray, n2, n3);
        this.myLengthBuffer[0] = (byte)((byArray2.length & 0xFF000000) >> 24);
        this.myLengthBuffer[1] = (byte)((byArray2.length & 0xFF0000) >> 16);
        this.myLengthBuffer[2] = (byte)((byArray2.length & 0xFF00) >> 8);
        this.myLengthBuffer[3] = (byte)(byArray2.length & 0xFF);
        this.myOut.write(this.myLengthBuffer, 0, this.myLengthBuffer.length);
        this.myOut.write(byArray2, 0, byArray2.length);
        this.myOut.flush();
        this.myBuffer.clear();
    }
}

