/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;

public class SaslInputStream
extends InputStream {
    private InputStream mySource;
    private SaslClient myClient;
    private byte[] myReadBuffer;
    private ByteBuffer myByteBuffer;

    public SaslInputStream(SaslClient saslClient, int n2, InputStream inputStream) {
        this.mySource = inputStream;
        this.myReadBuffer = new byte[n2 * 2];
        this.myClient = saslClient;
    }

    @Override
    public void close() {
        this.mySource.close();
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 != 1) {
            return -1;
        }
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        do {
            if (this.myByteBuffer == null) {
                this.fetchDecodedBuffer();
            }
            n4 = Math.min(n3, this.myByteBuffer.remaining());
            this.myByteBuffer.get(byArray, n2, n4);
            n2 += n4;
            n5 += n4;
        } while ((n3 -= n4) != 0 && this.myByteBuffer.remaining() != 0);
        if (this.myByteBuffer.remaining() == 0) {
            this.myByteBuffer = null;
        }
        return n5;
    }

    @Override
    public long skip(long l2) {
        return 0L;
    }

    private void fetchDecodedBuffer() {
        DataInputStream dataInputStream = new DataInputStream(this.mySource);
        int n2 = dataInputStream.readInt();
        if (this.myReadBuffer.length < n2) {
            this.myReadBuffer = new byte[n2 * 3 / 2];
        }
        dataInputStream.readFully(this.myReadBuffer, 0, n2);
        this.myByteBuffer = ByteBuffer.wrap(this.myClient.unwrap(this.myReadBuffer, 0, n2));
    }
}

