/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNPlainAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.sasl.SVNSaslAuthenticator$SVNCallbackHandler;
import org.tmatesoft.svn.core.internal.io.svn.sasl.SaslInputStream;
import org.tmatesoft.svn.core.internal.io.svn.sasl.SaslOutputStream;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSaslAuthenticator
extends SVNAuthenticator {
    private SaslClient myClient;
    private ISVNAuthenticationManager myAuthenticationManager;
    private SVNAuthentication myAuthentication;

    public SVNSaslAuthenticator(SVNConnection sVNConnection) {
        super(sVNConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNAuthentication authenticate(List arrayList, String string, SVNRepositoryImpl sVNRepositoryImpl) {
        boolean bl2 = true;
        this.setLastError(null);
        this.myAuthenticationManager = sVNRepositoryImpl.getAuthenticationManager();
        this.myAuthentication = null;
        boolean bl3 = false;
        if (arrayList.contains("EXTERNAL") && sVNRepositoryImpl.getExternalUserName() != null) {
            arrayList = new ArrayList();
            arrayList.add("EXTERNAL");
        } else {
            for (String object : arrayList) {
                if (!"ANONYMOUS".equals(object) && !"EXTERNAL".equals(object) && !"PLAIN".equals(object)) continue;
                arrayList = new ArrayList();
                bl3 = "ANONYMOUS".equals(object);
                arrayList.add(object);
                break;
            }
        }
        this.dispose();
        try {
            this.myClient = this.createSaslClient(arrayList, string, sVNRepositoryImpl, sVNRepositoryImpl.getLocation());
            while (true) {
                String string2;
                boolean bl4;
                block20: {
                    if (this.myClient == null) {
                        SVNAuthentication sVNAuthentication = new SVNPlainAuthenticator(this.getConnection()).authenticate(arrayList, string, sVNRepositoryImpl);
                        return sVNAuthentication;
                    }
                    bl4 = false;
                    try {
                        if (!this.tryAuthentication(sVNRepositoryImpl, SVNSaslAuthenticator.getMechanismName(this.myClient, bl3))) break block20;
                        if (this.myAuthenticationManager != null && this.myAuthentication != null) {
                            String string3 = SVNSaslAuthenticator.getFullRealmName(sVNRepositoryImpl.getLocation(), string);
                            BasicAuthenticationManager.acknowledgeAuthentication(true, this.myAuthentication.getKind(), string3, null, this.myAuthentication, sVNRepositoryImpl.getLocation(), this.myAuthenticationManager);
                        }
                        bl2 = false;
                        this.setLastError(null);
                        this.setEncryption(sVNRepositoryImpl);
                        break;
                    }
                    catch (SaslException saslException) {
                        string2 = SVNSaslAuthenticator.getMechanismName(this.myClient, bl3);
                        arrayList.remove(string2);
                        bl4 = true;
                    }
                }
                if (this.myAuthenticationManager != null) {
                    SVNErrorMessage sVNErrorMessage = this.getLastError();
                    if (sVNErrorMessage == null) {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED);
                        this.setLastError(sVNErrorMessage2);
                    }
                    if (this.myAuthentication != null) {
                        string2 = SVNSaslAuthenticator.getFullRealmName(sVNRepositoryImpl.getLocation(), string);
                        BasicAuthenticationManager.acknowledgeAuthentication(false, this.myAuthentication.getKind(), string2, this.getLastError(), this.myAuthentication, sVNRepositoryImpl.getLocation(), this.myAuthenticationManager);
                    } else {
                        arrayList.remove(SVNSaslAuthenticator.getMechanismName(this.myClient, bl3));
                    }
                }
                this.dispose();
                if (arrayList.isEmpty()) {
                    bl2 = true;
                    break;
                }
                if (bl4) {
                    this.myAuthentication = null;
                }
                this.myClient = this.createSaslClient(arrayList, string, sVNRepositoryImpl, sVNRepositoryImpl.getLocation());
            }
        }
        finally {
            if (bl2) {
                this.dispose();
            }
        }
        if (this.getLastError() != null) {
            SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
        }
        return this.myAuthentication;
    }

    @Override
    public void dispose() {
        if (this.myClient != null) {
            try {
                this.myClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
        }
    }

    protected boolean tryAuthentication(SVNRepositoryImpl sVNRepositoryImpl, String string) {
        Object object;
        Object object2;
        boolean bl2;
        String string2 = null;
        boolean bl3 = bl2 = !"ANONYMOUS".equals(string) && !"EXTERNAL".equals(string) && !"PLAIN".equals(string);
        if ("EXTERNAL".equals(string) && sVNRepositoryImpl.getExternalUserName() != null) {
            string2 = "";
        } else if (this.myClient.hasInitialResponse()) {
            object2 = null;
            object2 = this.myClient.evaluateChallenge(new byte[0]);
            if (object2 == null) {
                object = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected initial response received from {0}", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
            }
            string2 = SVNSaslAuthenticator.toBase64(object2);
        }
        if (string2 != null) {
            this.getConnection().write("(w(s))", new Object[]{string, string2});
        } else {
            this.getConnection().write("(w())", new Object[]{string});
        }
        object2 = "step";
        while ("step".equals(object2)) {
            Object object3;
            Object object4;
            String string3;
            object = this.getConnection().readTuple("w(?s)", true);
            object2 = (String)object.get(0);
            if ("failure".equals(object2)) {
                string3 = object.size() > 1 ? object.get(1) : "";
                this.setLastError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, string3));
                return false;
            }
            string3 = object.size() > 1 ? object.get(1) : null;
            if (string3 == null && ("CRAM-MD5".equals(string) || "GSSAPI".equals(string)) && "success".equals(object2)) {
                string3 = "";
            }
            if (!"step".equals(object2) && !"success".equals(object2) || string3 == null && bl2) {
                object4 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected server response to authentication");
                SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.NETWORK);
            }
            object4 = "CRAM-MD5".equals(string) ? string3.getBytes() : SVNSaslAuthenticator.fromBase64(string3);
            byte[] byArray = null;
            if (!this.myClient.isComplete()) {
                byArray = this.myClient.evaluateChallenge((byte[])object4);
            }
            if ("success".equals(object2)) {
                return true;
            }
            if (byArray == null) {
                object3 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected response received from {0}", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.NETWORK);
            }
            if (byArray.length > 0) {
                object3 = "CRAM-MD5".equals(string) ? new String(byArray) : SVNSaslAuthenticator.toBase64(byArray);
                this.getConnection().write("s", new Object[]{object3});
                continue;
            }
            this.getConnection().write("s", new Object[]{""});
        }
        return true;
    }

    protected void setEncryption(SVNRepositoryImpl sVNRepositoryImpl) {
        if (this.getConnection().isEncrypted()) {
            this.dispose();
            return;
        }
        String string = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.qop");
        String string2 = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.maxbuffer");
        String string3 = (String)this.myClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if ("auth-int".equals(string) || "auth-conf".equals(string)) {
            int n2 = 1000;
            int n3 = 1000;
            if (string3 != null) {
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 1000;
                }
            }
            if (string2 != null) {
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 1000;
                }
            }
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SASL read buffer size: " + n3);
            SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SASL write buffer size: " + n2);
            try {
                this.getPlainOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            OutputStream outputStream = new SaslOutputStream(this.myClient, n2, this.getPlainOutputStream());
            outputStream = sVNRepositoryImpl.getDebugLog().createLogStream(SVNLogType.NETWORK, outputStream);
            this.setOutputStream(outputStream);
            InputStream inputStream = new SaslInputStream(this.myClient, n3, this.getPlainInputStream());
            inputStream = sVNRepositoryImpl.getDebugLog().createLogStream(SVNLogType.NETWORK, inputStream);
            this.setInputStream(inputStream);
            this.getConnection().setEncrypted(this);
        } else {
            this.dispose();
        }
    }

    protected SaslClient createSaslClient(List list, String string, SVNRepositoryImpl sVNRepositoryImpl, SVNURL sVNURL) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        sVNHashMap.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
        sVNHashMap.put("javax.security.sasl.maxbuffer", "8192");
        sVNHashMap.put("javax.security.sasl.rawsendsize", "8192");
        sVNHashMap.put("javax.security.sasl.policy.noplaintext", "false");
        sVNHashMap.put("javax.security.sasl.reuse", "false");
        sVNHashMap.put("javax.security.sasl.policy.noanonymous", "true");
        String[] stringArray = list.toArray(new String[list.size()]);
        SaslClient saslClient = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            try {
                String string3;
                SaslClientFactory saslClientFactory;
                if ("ANONYMOUS".equals(string2) || "EXTERNAL".equals(string2) || "PLAIN".equals(string2)) {
                    sVNHashMap.put("javax.security.sasl.policy.noanonymous", "false");
                }
                if ((saslClientFactory = SVNSaslAuthenticator.getSaslClientFactory(string2, sVNHashMap)) == null) continue;
                SVNAuthentication sVNAuthentication = null;
                if ("ANONYMOUS".equals(string2)) {
                    sVNAuthentication = SVNPasswordAuthentication.newInstance("", new char[0], false, sVNURL, false);
                } else if ("EXTERNAL".equals(string2)) {
                    string3 = sVNRepositoryImpl.getExternalUserName();
                    if (string3 == null) {
                        string3 = "";
                    }
                    sVNAuthentication = SVNPasswordAuthentication.newInstance(string3, new char[0], false, sVNURL, false);
                } else {
                    if (this.myAuthenticationManager == null) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication required for ''{0}''", (Object)string), SVNLogType.NETWORK);
                    }
                    string3 = SVNSaslAuthenticator.getFullRealmName(sVNURL, string);
                    this.myAuthentication = this.myAuthentication != null ? this.myAuthenticationManager.getNextAuthentication("svn.simple", string3, sVNURL) : this.myAuthenticationManager.getFirstAuthentication("svn.simple", string3, sVNURL);
                    if (this.myAuthentication == null) {
                        if (this.getLastError() != null) {
                            SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
                        }
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication required for ''{0}''", (Object)string), SVNLogType.NETWORK);
                    }
                    sVNAuthentication = this.myAuthentication;
                }
                saslClient = saslClientFactory.createSaslClient(new String[]{"ANONYMOUS".equals(string2) ? "PLAIN" : string2}, null, "svn", sVNURL.getHost(), sVNHashMap, new SVNSaslAuthenticator$SVNCallbackHandler(string, sVNAuthentication));
                if (saslClient != null) break;
                this.myAuthentication = null;
                continue;
            }
            catch (SaslException saslException) {
                list.remove(stringArray[i2]);
                this.myAuthentication = null;
            }
        }
        return saslClient;
    }

    private static String getFullRealmName(SVNURL sVNURL, String string) {
        if (sVNURL == null || string == null) {
            return string;
        }
        return "<" + sVNURL.getProtocol() + "://" + sVNURL.getHost() + ":" + sVNURL.getPort() + "> " + string;
    }

    private static String toBase64(byte[] byArray) {
        return SVNBase64.byteArrayToBase64(byArray);
    }

    private static byte[] fromBase64(String string) {
        if (string == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2) || c2 == '\n' || c2 == '\r') continue;
            byteArrayOutputStream.write((byte)c2 & 0xFF);
        }
        byte[] byArray = new byte[string.length()];
        try {
            string = new String(byteArrayOutputStream.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n2 = SVNBase64.base64ToByteArray(new StringBuffer(string), byArray);
        byte[] byArray2 = new byte[n2];
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            if (i3 != -1) continue;
            --n2;
        }
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private static String getMechanismName(SaslClient saslClient, boolean bl2) {
        if (saslClient == null) {
            return null;
        }
        String string = saslClient.getMechanismName();
        if ("PLAIN".equals(string) && bl2) {
            string = "ANONYMOUS";
        }
        return string;
    }

    private static SaslClientFactory getSaslClientFactory(String string, Map map) {
        if (string == null) {
            return null;
        }
        if ("ANONYMOUS".equals(string)) {
            string = "PLAIN";
        }
        Enumeration<SaslClientFactory> enumeration = Sasl.getSaslClientFactories();
        while (enumeration.hasMoreElements()) {
            SaslClientFactory saslClientFactory = enumeration.nextElement();
            String[] stringArray = saslClientFactory.getMechanismNames(map);
            for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
                if (!string.endsWith(stringArray[i2])) continue;
                return saslClientFactory;
            }
        }
        return null;
    }
}

