/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;

public class StreamLogger
implements Closeable {
    private static final Logger log = Logger.getLogger(StreamLogger.class.getName());
    private int copied;
    private Thread thread = new Thread(() -> {
        try {
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (logger.isLoggable(level)) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            byte[] byArray = new byte[2048];
            int n2 = 0;
            while (!this.thread.isInterrupted() || n2 < 10) {
                int n3;
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.reset();
                }
                while (inputStream.available() > 0 && (n3 = inputStream.read(byArray)) > 0) {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.write(byArray, 0, n3);
                    }
                    this.copied += n3;
                    n2 = 0;
                }
                ++n2;
                if (byteArrayOutputStream != null && logger.isLoggable(level)) {
                    logger.log(level, "Discarded input from " + string + ": " + byteArrayOutputStream);
                }
                Thread.sleep(100L);
            }
        }
        catch (SshChannelClosedException sshChannelClosedException) {
            logger.log(level, string + ": Channel closed " + sshChannelClosedException);
        }
        catch (IOException iOException) {
            logger.log(level, string + ": Failed while streaming " + iOException);
        }
        catch (InterruptedException interruptedException) {
            logger.log(level, string + ": Got interrupted");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Got exception while closing the input stream", exception);
            }
        }
    });

    public StreamLogger(String string, InputStream inputStream, Logger logger, Level level) {
        this.thread.setName("Piping " + string);
        this.thread.start();
    }

    public static StreamLogger consume(InputStream inputStream) {
        return new StreamLogger("consumer", inputStream, log, Level.FINE);
    }

    @Override
    public void close() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }
    }

    public int getCopied() {
        return this.copied;
    }
}

