/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.util.ArrayList;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNAbstractTunnelConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTunnelConnector
extends SVNAbstractTunnelConnector {
    private String myTunnelSpec;
    private String myName;

    public SVNTunnelConnector(String string, String string2) {
        this.myName = string;
        this.myTunnelSpec = string2;
    }

    @Override
    public void open(SVNRepositoryImpl sVNRepositoryImpl) {
        String string;
        String[] stringArray = SVNTunnelConnector.expandTunnelSpec(this.myName, this.myTunnelSpec);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        String string2 = sVNRepositoryImpl.getLocation().getHost();
        if (sVNRepositoryImpl.getLocation().getUserInfo() != null && !"".equals(sVNRepositoryImpl.getLocation().getUserInfo())) {
            string = sVNRepositoryImpl.getLocation().getUserInfo();
            string2 = string + "@" + string2;
        }
        arrayList.add(string2);
        ISVNAuthenticationManager iSVNAuthenticationManager = sVNRepositoryImpl.getAuthenticationManager();
        if (iSVNAuthenticationManager != null) {
            String string3;
            SVNAuthentication sVNAuthentication = iSVNAuthenticationManager.getFirstAuthentication("svn.username", string2, sVNRepositoryImpl.getLocation());
            if (sVNAuthentication == null) {
                SVNErrorManager.cancel("Authentication cancelled", SVNLogType.NETWORK);
            }
            if ((string3 = sVNAuthentication.getUserName()) == null || "".equals(string3.trim())) {
                string3 = System.getProperty("user.name");
            }
            sVNAuthentication = new SVNUserNameAuthentication(string3, sVNAuthentication.isStorageAllowed(), sVNRepositoryImpl.getLocation(), false);
            BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.username", string2, null, sVNAuthentication, sVNRepositoryImpl.getLocation(), iSVNAuthenticationManager);
            string = "svnserve -t --tunnel-user \"" + string3 + "\"";
            sVNRepositoryImpl.setExternalUserName(string3);
        } else {
            string = "svnserve -t";
        }
        arrayList.add(string);
        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "tunnel command: " + arrayList);
        this.open(sVNRepositoryImpl, arrayList.toArray(new String[arrayList.size()]));
    }

    private static String[] expandTunnelSpec(String string, String string2) {
        String string3;
        int n2;
        if (string2 == null || string2.trim().length() == 0) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "No tunnel spec foound for ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        String string4 = (n2 = (string2 = string2.trim()).indexOf(32)) > 0 ? string2.substring(0, n2) : string2;
        String string5 = string3 = n2 > 0 ? string2.substring(n2).trim() : string2;
        if (string4.charAt(0) == '%' && string4.charAt(string4.length() - 1) == '%') {
            string4 = string4.substring(1);
            string4 = string4.substring(0, string4.length() - 1);
            string4 = SVNFileUtil.getEnvironmentVariable(string4);
        } else if (string4.charAt(0) == '$') {
            string4 = string4.substring(1);
            string4 = SVNFileUtil.getEnvironmentVariable(string4);
        } else {
            string4 = null;
            string3 = null;
        }
        if (string4 != null) {
            string2 = string4;
        } else if (string3 != null) {
            string2 = string3;
        }
        return string2.split("\\s");
    }

    @Override
    public void handleExceptionOnOpen(SVNRepositoryImpl sVNRepositoryImpl, SVNException sVNException) {
        throw sVNException;
    }
}

